/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;
import org.evosuite.shaded.org.objectweb.asm.Type;

public class VectorInstrumentation
extends ErrorBranchInstrumenter {
    private static final String VECTORNAME = Vector.class.getCanonicalName().replace('.', '/');
    private final List<String> emptyListMethods = Arrays.asList("firstElement", "lastElement");
    private final List<String> indexListMethods = Arrays.asList("elementAt", "removeElementAt");

    public VectorInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (owner.equals(VECTORNAME)) {
            if (this.emptyListMethods.contains(name)) {
                Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
                this.mv.visitMethodInsn(182, VECTORNAME, "isEmpty", "()Z", false);
                this.insertBranch(158, "java/util/NoSuchElementException");
                this.restoreMethodParameters(tempVariables, desc);
            } else if (this.indexListMethods.contains(name)) {
                Type[] args = Type.getArgumentTypes(desc);
                if (args.length == 0) {
                    return;
                }
                if (!args[0].equals(Type.INT_TYPE)) {
                    return;
                }
                Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
                this.tagBranchStart();
                this.mv.visitMethodInsn(182, VECTORNAME, "size", "()I", false);
                this.mv.loadLocal(tempVariables.get(0));
                this.insertBranch(163, "java/lang/IndexOutOfBoundsException");
                this.mv.loadLocal(tempVariables.get(0));
                this.insertBranch(156, "java/lang/IndexOutOfBoundsException");
                this.tagBranchEnd();
                this.restoreMethodParameters(tempVariables, desc);
            }
        }
    }
}

