/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.instrumentation.mutation.ReplaceArithmeticOperator;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;

public class ReplaceBitwiseOperator
implements MutationOperator {
    public static final String NAME = "ReplaceBitwiseOperator";
    private static Set<Integer> opcodesInt = new HashSet<Integer>();
    private static Set<Integer> opcodesIntShift = new HashSet<Integer>();
    private static Set<Integer> opcodesLong = new HashSet<Integer>();
    private static Set<Integer> opcodesLongShift = new HashSet<Integer>();
    private int numVariable = 0;

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        this.numVariable = ReplaceArithmeticOperator.getNextIndex(mn);
        InsnNode node = (InsnNode)instruction.getASMNode();
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        HashSet<Integer> replacement = new HashSet<Integer>();
        if (opcodesInt.contains(node.getOpcode())) {
            replacement.addAll(opcodesInt);
        } else if (opcodesIntShift.contains(node.getOpcode())) {
            replacement.addAll(opcodesIntShift);
        } else if (opcodesLong.contains(node.getOpcode())) {
            replacement.addAll(opcodesLong);
        } else if (opcodesLongShift.contains(node.getOpcode())) {
            replacement.addAll(opcodesLongShift);
        }
        replacement.remove(node.getOpcode());
        Iterator iterator = replacement.iterator();
        while (iterator.hasNext()) {
            int opcode = (Integer)iterator.next();
            InsnNode mutation = new InsnNode(opcode);
            Mutation mutationObject = MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).addMutation(className, methodName, "ReplaceBitwiseOperator " + this.getOp(node.getOpcode()) + " -> " + this.getOp(opcode), instruction, mutation, this.getInfectionDistance(node.getOpcode(), opcode));
            mutations.add(mutationObject);
        }
        return mutations;
    }

    private String getOp(int opcode) {
        switch (opcode) {
            case 126: 
            case 127: {
                return "&";
            }
            case 128: 
            case 129: {
                return "|";
            }
            case 130: 
            case 131: {
                return "^";
            }
            case 122: {
                return ">> I";
            }
            case 123: {
                return ">> L";
            }
            case 120: {
                return "<< I";
            }
            case 121: {
                return "<< L";
            }
            case 124: {
                return ">>> I";
            }
            case 125: {
                return ">>> L";
            }
        }
        throw new RuntimeException("Unknown opcode: " + opcode);
    }

    public InsnList getInfectionDistance(int opcodeOrig, int opcodeNew) {
        InsnList distance = new InsnList();
        if (opcodesInt.contains(opcodeOrig)) {
            distance.add(new InsnNode(92));
            distance.add(new LdcInsnNode((Object)opcodeOrig));
            distance.add(new LdcInsnNode((Object)opcodeNew));
            distance.add(new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceBitwiseOperator.class), "getInfectionDistanceInt", "(IIII)D", false));
        } else if (opcodesIntShift.contains(opcodeOrig)) {
            distance.add(new InsnNode(92));
            distance.add(new LdcInsnNode((Object)opcodeOrig));
            distance.add(new LdcInsnNode((Object)opcodeNew));
            distance.add(new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceBitwiseOperator.class), "getInfectionDistanceInt", "(IIII)D", false));
        } else if (opcodesLong.contains(opcodeOrig)) {
            distance.add(new VarInsnNode(55, this.numVariable));
            distance.add(new InsnNode(92));
            distance.add(new VarInsnNode(22, this.numVariable));
            distance.add(new InsnNode(94));
            distance.add(new LdcInsnNode((Object)opcodeOrig));
            distance.add(new LdcInsnNode((Object)opcodeNew));
            distance.add(new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceBitwiseOperator.class), "getInfectionDistanceLong", "(JJII)D", false));
            this.numVariable += 2;
        } else if (opcodesLongShift.contains(opcodeOrig)) {
            distance.add(new VarInsnNode(54, this.numVariable));
            distance.add(new InsnNode(92));
            distance.add(new VarInsnNode(21, this.numVariable));
            distance.add(new InsnNode(91));
            distance.add(new LdcInsnNode((Object)opcodeOrig));
            distance.add(new LdcInsnNode((Object)opcodeNew));
            distance.add(new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceBitwiseOperator.class), "getInfectionDistanceLong", "(JIII)D", false));
            ++this.numVariable;
        }
        return distance;
    }

    public static double getInfectionDistanceInt(int x, int y, int opcodeOrig, int opcodeNew) {
        int newValue;
        if (opcodeOrig == 122 && opcodeNew == 124) {
            if (x < 0 && y != 0) {
                int origValue = ReplaceBitwiseOperator.calculate(x, y, opcodeOrig);
                int newValue2 = ReplaceBitwiseOperator.calculate(x, y, opcodeNew);
                assert (origValue != newValue2);
                return 0.0;
            }
            return y != 0 && x > 0 ? (double)x + 1.0 : 1.0;
        }
        int origValue = ReplaceBitwiseOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceBitwiseOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static double getInfectionDistanceLong(long x, int y, int opcodeOrig, int opcodeNew) {
        long newValue;
        if (opcodeOrig == 123 && opcodeNew == 125) {
            if (x < 0L && y != 0) {
                long origValue = ReplaceBitwiseOperator.calculate(x, (long)y, opcodeOrig);
                long newValue2 = ReplaceBitwiseOperator.calculate(x, (long)y, opcodeNew);
                assert (origValue != newValue2);
                return 0.0;
            }
            return y != 0 && x > 0L ? (double)x + 1.0 : 1.0;
        }
        long origValue = ReplaceBitwiseOperator.calculate(x, (long)y, opcodeOrig);
        return origValue == (newValue = ReplaceBitwiseOperator.calculate(x, (long)y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static double getInfectionDistanceLong(long x, long y, int opcodeOrig, int opcodeNew) {
        long newValue;
        long origValue = ReplaceBitwiseOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceBitwiseOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static int calculate(int x, int y, int opcode) {
        switch (opcode) {
            case 126: {
                return x & y;
            }
            case 128: {
                return x | y;
            }
            case 130: {
                return x ^ y;
            }
            case 120: {
                return x << y;
            }
            case 122: {
                return x >> y;
            }
            case 124: {
                return x >>> y;
            }
        }
        throw new RuntimeException("Unknown integer opcode: " + opcode);
    }

    public static long calculate(long x, long y, int opcode) {
        switch (opcode) {
            case 127: {
                return x & y;
            }
            case 129: {
                return x | y;
            }
            case 131: {
                return x ^ y;
            }
            case 121: {
                return x << (int)y;
            }
            case 123: {
                return x >> (int)y;
            }
            case 125: {
                return x >>> (int)y;
            }
        }
        throw new RuntimeException("Unknown long opcode: " + opcode);
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        AbstractInsnNode node = instruction.getASMNode();
        int opcode = node.getOpcode();
        if (opcodesInt.contains(opcode)) {
            return true;
        }
        if (opcodesIntShift.contains(opcode)) {
            return true;
        }
        if (opcodesLong.contains(opcode)) {
            return true;
        }
        return opcodesLongShift.contains(opcode);
    }

    static {
        opcodesInt.addAll(Arrays.asList(126, 128, 130));
        opcodesIntShift.addAll(Arrays.asList(120, 122, 124));
        opcodesLong.addAll(Arrays.asList(127, 129, 131));
        opcodesLongShift.addAll(Arrays.asList(121, 123, 125));
    }
}

