/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.objectweb.asm.Opcodes;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.IntInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.TypeInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;

public class MethodNodeTransformer {
    protected int[] mapping = new int[40];
    protected Object[] newLocals = new Object[20];
    protected int firstLocal;
    protected int nextLocal;
    protected final List<Type> localTypes = new ArrayList<Type>();
    protected Map<Integer, Integer> parameterToLocalMap = new HashMap<Integer, Integer>();

    public void transform(MethodNode mn) {
        AbstractInsnNode node;
        this.setupLocals(mn);
        HashSet<AbstractInsnNode> originalNodes = new HashSet<AbstractInsnNode>();
        for (node = mn.instructions.getFirst(); node != mn.instructions.getLast(); node = node.getNext()) {
            originalNodes.add(node);
        }
        node = mn.instructions.getFirst();
        boolean finished = false;
        while (!finished) {
            if (node instanceof MethodInsnNode) {
                node = this.transformMethodInsnNode(mn, (MethodInsnNode)node);
            } else if (node instanceof VarInsnNode) {
                node = this.transformVarInsnNode(mn, (VarInsnNode)node);
            } else if (node instanceof FieldInsnNode) {
                node = this.transformFieldInsnNode(mn, (FieldInsnNode)node);
            } else if (node instanceof InsnNode) {
                node = this.transformInsnNode(mn, (InsnNode)node);
            } else if (node instanceof TypeInsnNode) {
                node = this.transformTypeInsnNode(mn, (TypeInsnNode)node);
            } else if (node instanceof JumpInsnNode) {
                node = this.transformJumpInsnNode(mn, (JumpInsnNode)node);
            } else if (node instanceof LabelNode) {
                node = this.transformLabelNode(mn, (LabelNode)node);
            } else if (node instanceof IntInsnNode) {
                node = this.transformIntInsnNode(mn, (IntInsnNode)node);
            } else if (node instanceof MultiANewArrayInsnNode) {
                node = this.transformMultiANewArrayInsnNode(mn, (MultiANewArrayInsnNode)node);
            }
            if (node == mn.instructions.getLast()) {
                finished = true;
                continue;
            }
            node = node.getNext();
        }
    }

    protected AbstractInsnNode transformMethodInsnNode(MethodNode mn, MethodInsnNode methodNode) {
        return methodNode;
    }

    protected AbstractInsnNode transformVarInsnNode(MethodNode mn, VarInsnNode varNode) {
        return varNode;
    }

    protected AbstractInsnNode transformFieldInsnNode(MethodNode mn, FieldInsnNode fieldNode) {
        return fieldNode;
    }

    protected AbstractInsnNode transformInsnNode(MethodNode mn, InsnNode insnNode) {
        return insnNode;
    }

    protected AbstractInsnNode transformTypeInsnNode(MethodNode mn, TypeInsnNode typeNode) {
        return typeNode;
    }

    protected AbstractInsnNode transformJumpInsnNode(MethodNode mn, JumpInsnNode jumpNode) {
        return jumpNode;
    }

    protected AbstractInsnNode transformLabelNode(MethodNode mn, LabelNode labelNode) {
        return labelNode;
    }

    protected AbstractInsnNode transformIntInsnNode(MethodNode mn, IntInsnNode intInsnNode) {
        return intInsnNode;
    }

    protected AbstractInsnNode transformMultiANewArrayInsnNode(MethodNode mn, MultiANewArrayInsnNode arrayInsnNode) {
        return arrayInsnNode;
    }

    protected void setupLocals(MethodNode mn) {
        Type[] args = Type.getArgumentTypes(mn.desc);
        this.nextLocal = (8 & mn.access) == 0 ? 1 : 0;
        for (Type arg : args) {
            this.nextLocal += arg.getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void storeLocal(int local) {
        this.storeInsn(this.getLocalType(local), local);
    }

    public void loadLocal(int local) {
        this.loadInsn(this.getLocalType(local), local);
    }

    public Type getLocalType(int local) {
        return this.localTypes.get(local - this.firstLocal);
    }

    public int newLocal(Type type) {
        Object t;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                t = Opcodes.INTEGER;
                break;
            }
            case 6: {
                t = Opcodes.FLOAT;
                break;
            }
            case 7: {
                t = Opcodes.LONG;
                break;
            }
            case 8: {
                t = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                t = type.getDescriptor();
                break;
            }
            default: {
                t = type.getInternalName();
            }
        }
        int local = this.newLocalMapping(type);
        this.setLocalType(local, type);
        this.setFrameLocal(local, t);
        return local;
    }

    protected int newLocalMapping(Type type) {
        int local = this.nextLocal;
        this.nextLocal += type.getSize();
        return local;
    }

    private void setFrameLocal(int local, Object type) {
        int l = this.newLocals.length;
        if (local >= l) {
            Object[] a = new Object[Math.max(2 * l, local + 1)];
            System.arraycopy(this.newLocals, 0, a, 0, l);
            this.newLocals = a;
        }
        this.newLocals[local] = type;
    }

    protected void setLocalType(int local, Type type) {
    }

    private void storeInsn(Type type, int index) {
    }

    private void loadInsn(Type type, int index) {
    }

    protected void popParametersToLocals(MethodNode mn) {
        Type[] args = Type.getArgumentTypes(mn.desc);
        for (int i = args.length - 1; i >= 0; --i) {
            int loc = this.newLocal(args[i]);
            this.storeLocal(loc);
            this.parameterToLocalMap.put(i, loc);
        }
    }

    protected void pushParametersToLocals(MethodNode mn) {
        Type[] args = Type.getArgumentTypes(mn.desc);
        for (int i = 0; i < args.length; ++i) {
            this.loadLocal(this.parameterToLocalMap.get(i));
        }
        this.parameterToLocalMap.clear();
    }
}

