/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.rules;

import java.util.Arrays;
import org.evosuite.junit.rules.BaseRule;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.agent.InstrumentingAgent;

public class InitializeClasses
extends BaseRule {
    private String[] classNames;

    public InitializeClasses(String ... classesToInitialize) {
        this.classNames = Arrays.copyOf(classesToInitialize, classesToInitialize.length);
    }

    @Override
    protected void before() {
        InstrumentingAgent.activate();
        for (String className : this.classNames) {
            Runtime.getInstance().resetRuntime();
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                Class.forName(className, true, classLoader);
            }
            catch (ExceptionInInitializerError ex) {
                System.err.println("Could not initialize " + className);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        InstrumentingAgent.deactivate();
    }

    @Override
    protected void after() {
    }
}

