/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.writer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.GuiSupport;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.classhandling.ClassResetter;
import org.evosuite.runtime.classhandling.ClassStateSupport;
import org.evosuite.runtime.classhandling.JDKClassResetter;
import org.evosuite.runtime.jvm.ShutdownHookHandler;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.thread.KillSwitchHandler;
import org.evosuite.runtime.thread.ThreadStopper;
import org.evosuite.runtime.util.JOptionPaneInputs;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.runtime.vnet.NonFunctionalRequirementRule;
import org.evosuite.shaded.org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.reset.ClassReInitializer;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.utils.generic.GenericClass;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.rules.Timeout;

public class Scaffolding {
    public static final String EXECUTOR_SERVICE = "executor";
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String THREAD_STOPPER = "threadStopper";

    public static String getScaffoldingFileContent(String testName, List<ExecutionResult> results, boolean wasSecurityException) {
        String name = Scaffolding.getFileName(testName);
        StringBuilder builder = new StringBuilder();
        builder.append(Scaffolding.getHeader(name, results, wasSecurityException));
        if (results.isEmpty()) {
            builder.append("  ");
            builder.append("// Empty scaffolding for empty test suite\n");
        } else {
            builder.append(new Scaffolding().getBeforeAndAfterMethods(name, wasSecurityException, results));
        }
        builder.append(Scaffolding.getFooter());
        return builder.toString();
    }

    protected static String getFooter() {
        return "}\n";
    }

    protected static String getHeader(String name, List<ExecutionResult> results, boolean wasSecurityException) {
        StringBuilder builder = new StringBuilder();
        builder.append("/**\n");
        builder.append(" * Scaffolding file used to store all the setups needed to run \n");
        builder.append(" * tests automatically generated by EvoSuite\n");
        builder.append(" * " + new Date() + "\n");
        builder.append(" */\n\n");
        if (!Properties.CLASS_PREFIX.equals("")) {
            builder.append("package ");
            builder.append(Properties.CLASS_PREFIX);
            builder.append(";\n");
        }
        builder.append("\n");
        for (String imp : Scaffolding.getScaffoldingImports(wasSecurityException, results)) {
            builder.append("import ");
            builder.append(imp);
            builder.append(";\n");
        }
        builder.append("\n");
        if (TestSuiteWriterUtils.doesUseMocks(results)) {
            builder.append("import static " + Mockito.class.getCanonicalName() + ".*;\n");
        }
        builder.append("@EvoSuiteClassExclude\n");
        builder.append(TestSuiteWriterUtils.getAdapter().getClassDefinition(name));
        builder.append(" {\n");
        return builder.toString();
    }

    public static String getFileName(String testName) throws IllegalArgumentException {
        if (testName == null || testName.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty test name");
        }
        return testName + "_" + Properties.SCAFFOLDING_SUFFIX;
    }

    public static List<String> getScaffoldingImports(boolean wasSecurityException, List<ExecutionResult> results) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EvoSuiteClassExclude.class.getCanonicalName());
        if (TestSuiteWriterUtils.needToUseAgent() || wasSecurityException || SystemInUtil.getInstance().hasBeenUsed() || JOptionPaneInputs.getInstance().hasAnyDialog() || !Properties.NO_RUNTIME_DEPENDENCY || TestSuiteWriterUtils.doesUseMocks(results)) {
            list.add(BeforeClass.class.getCanonicalName());
            list.add(Before.class.getCanonicalName());
            list.add(After.class.getCanonicalName());
        }
        if (wasSecurityException || TestSuiteWriterUtils.shouldResetProperties(results)) {
            list.add(AfterClass.class.getCanonicalName());
        }
        if (Properties.RESET_STATIC_FIELDS || wasSecurityException) {
            list.add(Sandbox.class.getCanonicalName());
            list.add(Sandbox.SandboxMode.class.getCanonicalName());
        }
        if (wasSecurityException) {
            list.add(ExecutorService.class.getCanonicalName());
            list.add(Executors.class.getCanonicalName());
            list.add(Future.class.getCanonicalName());
            list.add(TimeUnit.class.getCanonicalName());
        }
        return list;
    }

    public String getBeforeAndAfterMethods(String name, boolean wasSecurityException, List<ExecutionResult> results) {
        StringBuilder bd = new StringBuilder("");
        bd.append("\n");
        this.generateNFRRule(bd);
        this.generateFields(bd, wasSecurityException, results);
        this.generateBeforeClass(bd, wasSecurityException, results);
        this.generateAfterClass(bd, wasSecurityException, results);
        this.generateBefore(bd, wasSecurityException, results);
        this.generateAfter(bd, wasSecurityException);
        this.generateSetSystemProperties(bd, results);
        this.generateInitializeClasses(name, bd);
        this.generateMockInitialization(name, bd, results);
        if (Properties.RESET_STATIC_FIELDS) {
            this.generateResetClasses(name, bd);
        }
        return bd.toString();
    }

    private void generateMockInitialization(String testClassName, StringBuilder bd, List<ExecutionResult> results) {
        if (!TestSuiteWriterUtils.doesUseMocks(results)) {
            return;
        }
        bd.append("  ");
        bd.append("private static void initMocksToAvoidTimeoutsInTheTests() throws ClassNotFoundException { \n");
        LinkedHashSet<String> mockStatements = new LinkedHashSet<String>();
        for (ExecutionResult er : results) {
            for (Statement st : er.test) {
                if (!(st instanceof FunctionalMockStatement)) continue;
                FunctionalMockStatement fms = (FunctionalMockStatement)st;
                String name = new GenericClass(fms.getReturnType()).getRawClass().getTypeName();
                mockStatements.add("mock(Class.forName(\"" + name + "\", false, " + testClassName + ".class.getClassLoader()));");
            }
        }
        mockStatements.stream().sorted().forEach(m -> {
            bd.append("    ");
            bd.append((String)m);
            bd.append("\n");
        });
        bd.append("  ");
        bd.append("}\n");
    }

    private void generateNFRRule(StringBuilder bd) {
        bd.append("  ");
        bd.append("@org.junit.Rule \n");
        bd.append("  ");
        bd.append("public " + NonFunctionalRequirementRule.class.getName() + " nfr = new " + NonFunctionalRequirementRule.class.getName() + "();\n\n");
    }

    private void generateTimeoutRule(StringBuilder bd) {
        bd.append("  ");
        bd.append("@org.junit.Rule \n");
        bd.append("  ");
        int timeout = Properties.TIMEOUT + 1000;
        bd.append("public " + Timeout.class.getName() + " globalTimeout = new " + Timeout.class.getName() + "(" + timeout);
        boolean useNew = false;
        try {
            Class<?> timeoutOfSUTJunit = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Timeout.class.getName());
            Constructor<?> c = timeoutOfSUTJunit.getDeclaredConstructor(Long.TYPE, TimeUnit.class);
            useNew = true;
        }
        catch (ClassNotFoundException e) {
            TestSuiteWriterUtils.logger.error("Failed to load Timeout rule from SUT classloader: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (NoSuchMethodException e) {
            TestSuiteWriterUtils.logger.warn("SUT is using an old version of JUnit");
            useNew = false;
        }
        if (useNew) {
            // empty if block
        }
        bd.append("); \n");
        bd.append("\n");
    }

    private void generateResetClasses(String testClassName, StringBuilder bd) {
        List<String> classesToReset = ClassReInitializer.getInstance().getInitializedClasses();
        bd.append("\n");
        bd.append("  ");
        bd.append("private static void resetClasses() {\n");
        if (classesToReset.size() != 0) {
            bd.append("    ");
            bd.append(ClassResetter.class.getName() + ".getInstance().setClassLoader(");
            bd.append(testClassName + ".class.getClassLoader()); \n\n");
            bd.append("    ");
            bd.append(ClassStateSupport.class.getName() + ".resetClasses(");
            for (int i = 0; i < classesToReset.size(); ++i) {
                String className = classesToReset.get(i);
                bd.append("\n      \"" + className + "\"");
                if (i >= classesToReset.size() - 1) continue;
                bd.append(",");
            }
            bd.append("\n");
            bd.append("    ");
            bd.append(");\n");
        }
        bd.append("  ");
        bd.append("}\n");
    }

    private List<String> getClassesToInit(List<String> allInstrumentedClasses) {
        ArrayList<String> classes = new ArrayList<String>();
        for (String name : allInstrumentedClasses) {
            if (name.contains(Properties.TARGET_CLASS) && (name.endsWith(Properties.JUNIT_SUFFIX) || name.endsWith(Properties.SCAFFOLDING_SUFFIX))) continue;
            classes.add(name);
        }
        return classes;
    }

    private void generateInitializeClasses(String testClassName, StringBuilder bd) {
        List<String> allInstrumentedClasses = TestGenerationContext.getInstance().getClassLoaderForSUT().getViewOfInstrumentedClasses();
        List<String> classesToInit = this.getClassesToInit(allInstrumentedClasses);
        bd.append("\n");
        bd.append("  ");
        bd.append("private static void initializeClasses() {\n");
        if (classesToInit.size() != 0) {
            bd.append("    ");
            bd.append(ClassStateSupport.class.getName() + ".initializeClasses(");
            bd.append(testClassName + ".class.getClassLoader() ");
            for (String className : classesToInit) {
                if (!BytecodeInstrumentation.checkIfCanInstrument(className)) continue;
                bd.append(",\n      \"" + className + "\"");
            }
            bd.append("\n");
            bd.append("    ");
            bd.append(");\n");
        }
        bd.append("  ");
        bd.append("} \n");
    }

    private void generateAfter(StringBuilder bd, boolean wasSecurityException) {
        if (Properties.NO_RUNTIME_DEPENDENCY) {
            return;
        }
        bd.append("  ");
        bd.append("@After \n");
        bd.append("  ");
        bd.append("public void doneWithTestCase(){ \n");
        bd.append("    ");
        bd.append("threadStopper.killAndJoinClientThreads();\n");
        if (Properties.REPLACE_CALLS) {
            bd.append("    ");
            bd.append(ShutdownHookHandler.class.getName() + ".getInstance().safeExecuteAddedHooks(); \n");
        }
        if (Properties.RESET_STANDARD_STREAMS) {
            bd.append("    ");
            bd.append("java.lang.System.setErr(systemErr); \n");
            bd.append("    ");
            bd.append("java.lang.System.setOut(systemOut); \n");
            bd.append("    ");
            bd.append("DebugGraphics.setLogStream(logStream); \n");
        }
        if (Properties.RESET_STATIC_FIELDS) {
            bd.append("    ");
            bd.append(JDKClassResetter.class.getName() + ".reset(); \n");
            bd.append("    ");
            bd.append("resetClasses(); \n");
        }
        if (Properties.RESET_STATIC_FIELDS || wasSecurityException) {
            bd.append("    ");
            bd.append(Sandbox.class.getName() + ".doneWithExecutingSUTCode(); \n");
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            bd.append("    ");
            bd.append(InstrumentingAgent.class.getName() + ".deactivate(); \n");
        }
        if (Properties.HEADLESS_MODE) {
            bd.append("    ");
            bd.append(GuiSupport.class.getName() + ".restoreHeadlessMode(); \n");
        }
        bd.append("  ");
        bd.append("} \n");
        bd.append("\n");
    }

    private void generateBefore(StringBuilder bd, boolean wasSecurityException, List<ExecutionResult> results) {
        if (Properties.NO_RUNTIME_DEPENDENCY) {
            return;
        }
        bd.append("  ");
        bd.append("@Before \n");
        bd.append("  ");
        bd.append("public void initTestCase(){ \n");
        bd.append("    ");
        bd.append("threadStopper.storeCurrentThreads();\n");
        bd.append("    ");
        bd.append("threadStopper.startRecordingTime();\n");
        if (Properties.REPLACE_CALLS) {
            bd.append("    ");
            bd.append(ShutdownHookHandler.class.getName() + ".getInstance().initHandler(); \n");
        }
        if (Properties.RESET_STATIC_FIELDS || wasSecurityException) {
            bd.append("    ");
            bd.append(Sandbox.class.getName() + ".goingToExecuteSUTCode(); \n");
        }
        if (Properties.RESET_STANDARD_STREAMS) {
            bd.append("    ");
            bd.append("systemErr = java.lang.System.err;");
            bd.append(" \n");
            bd.append("    ");
            bd.append("systemOut = java.lang.System.out;");
            bd.append(" \n");
            bd.append("    ");
            bd.append("logStream = DebugGraphics.logStream();");
            bd.append(" \n");
        }
        if (TestSuiteWriterUtils.shouldResetProperties(results)) {
            bd.append("    ");
            bd.append("setSystemProperties();");
            bd.append(" \n");
        }
        if (Properties.HEADLESS_MODE) {
            bd.append("    ");
            bd.append(GuiSupport.class.getName() + ".setHeadless(); \n");
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            bd.append("    ");
            bd.append(Runtime.class.getName() + ".getInstance().resetRuntime(); \n");
            bd.append("    ");
            bd.append(InstrumentingAgent.class.getName() + ".activate(); \n");
        }
        if (SystemInUtil.getInstance().hasBeenUsed()) {
            bd.append("    ");
            bd.append(SystemInUtil.class.getName() + ".getInstance().initForTestCase(); \n");
        }
        if (JOptionPaneInputs.getInstance().hasAnyDialog()) {
            bd.append("    ");
            bd.append(JOptionPaneInputs.class.getName() + ".getInstance().initForTestCase(); \n");
        }
        bd.append("  ");
        bd.append("} \n");
        bd.append("\n");
    }

    private String getResetPropertiesCommand() {
        return "java.lang.System.setProperties((java.util.Properties) defaultProperties.clone());";
    }

    private void generateAfterClass(StringBuilder bd, boolean wasSecurityException, List<ExecutionResult> results) {
        if (wasSecurityException || TestSuiteWriterUtils.shouldResetProperties(results)) {
            bd.append("  ");
            bd.append("@AfterClass \n");
            bd.append("  ");
            bd.append("public static void clearEvoSuiteFramework(){ \n");
            if (Properties.RESET_STATIC_FIELDS || wasSecurityException) {
                bd.append("    ");
                bd.append("Sandbox.resetDefaultSecurityManager(); \n");
            }
            if (wasSecurityException) {
                bd.append("    ");
                bd.append("executor.shutdownNow(); \n");
            }
            if (TestSuiteWriterUtils.shouldResetProperties(results)) {
                bd.append("    ");
                bd.append(this.getResetPropertiesCommand());
                bd.append(" \n");
            }
            bd.append("  ");
            bd.append("} \n");
            bd.append("\n");
        }
    }

    private void generateSetSystemProperties(StringBuilder bd, List<ExecutionResult> results) {
        if (!Properties.REPLACE_CALLS) {
            return;
        }
        bd.append("  ");
        bd.append("public static void setSystemProperties() {\n");
        bd.append(" \n");
        if (TestSuiteWriterUtils.shouldResetProperties(results)) {
            bd.append("    ");
            bd.append(this.getResetPropertiesCommand());
            bd.append(" \n");
            Set<String> readProperties = TestSuiteWriterUtils.mergeProperties(results);
            for (String prop : readProperties) {
                String currentValue = System.getProperty(prop);
                String escaped_prop = StringEscapeUtils.escapeJava(prop);
                if (currentValue == null) continue;
                String escaped_currentValue = StringEscapeUtils.escapeJava(currentValue);
                bd.append("    ");
                bd.append("java.lang.System.setProperty(\"" + escaped_prop + "\", \"" + escaped_currentValue + "\"); \n");
            }
        } else {
            bd.append("    /*No java.lang.System property to set*/\n");
        }
        bd.append("  ");
        bd.append("}\n");
    }

    private void generateBeforeClass(StringBuilder bd, boolean wasSecurityException, List<ExecutionResult> results) {
        if (!wasSecurityException && !TestSuiteWriterUtils.needToUseAgent()) {
            return;
        }
        bd.append("\n");
        bd.append("  ");
        bd.append("@BeforeClass \n");
        bd.append("  ");
        bd.append("public static void initEvoSuiteFramework() { \n");
        bd.append("    ");
        bd.append("" + RuntimeSettings.class.getName() + ".className = \"" + Properties.TARGET_CLASS + "\"; \n");
        bd.append("    ");
        bd.append("" + GuiSupport.class.getName() + ".initialize(); \n");
        if (Properties.REPLACE_CALLS) {
            bd.append("    ");
            bd.append("" + RuntimeSettings.class.getName() + ".maxNumberOfThreads = " + Properties.MAX_STARTED_THREADS + "; \n");
        }
        bd.append("    ");
        bd.append("" + RuntimeSettings.class.getName() + ".maxNumberOfIterationsPerLoop = " + Properties.MAX_LOOP_ITERATIONS + "; \n");
        if (Properties.REPLACE_SYSTEM_IN) {
            bd.append("    ");
            bd.append(RuntimeSettings.class.getName() + ".mockSystemIn = true; \n");
        }
        if (Properties.REPLACE_GUI) {
            bd.append("    ");
            bd.append(RuntimeSettings.class.getName() + ".mockGUI = true; \n");
        }
        if (Properties.RESET_STATIC_FIELDS || wasSecurityException) {
            bd.append("    ");
            bd.append(RuntimeSettings.class.getName() + ".sandboxMode = " + Sandbox.SandboxMode.class.getCanonicalName() + "." + (Object)((Object)Properties.SANDBOX_MODE) + "; \n");
            bd.append("    ");
            bd.append(Sandbox.class.getName() + ".initializeSecurityManagerForSUT(); \n");
        }
        if (wasSecurityException) {
            bd.append("    ");
            bd.append("executor = Executors.newCachedThreadPool(); \n");
        }
        if (Properties.RESET_STATIC_FIELDS && Properties.REPLACE_CALLS) {
            bd.append("    ");
            bd.append(JDKClassResetter.class.getName() + ".init();\n");
            bd.append("    ");
            bd.append("setSystemProperties();\n");
            bd.append("    ");
            bd.append("initializeClasses();\n");
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            bd.append("    ");
            bd.append(Runtime.class.getName() + ".getInstance().resetRuntime(); \n");
        } else {
            bd.append("    ");
            bd.append(LoopCounter.class.getName() + ".getInstance().reset(); \n");
        }
        if (TestSuiteWriterUtils.doesUseMocks(results)) {
            bd.append("    ");
            bd.append("try { initMocksToAvoidTimeoutsInTheTests(); } catch(ClassNotFoundException e) {} \n");
        }
        bd.append("  ");
        bd.append("} \n");
        bd.append("\n");
    }

    private void generateFields(StringBuilder bd, boolean wasSecurityException, List<ExecutionResult> results) {
        if (Properties.RESET_STANDARD_STREAMS) {
            bd.append("  ");
            bd.append("private PrintStream systemOut = null;\n");
            bd.append("  ");
            bd.append("private PrintStream systemErr = null;\n");
            bd.append("  ");
            bd.append("private PrintStream logStream = null;\n");
        }
        if (wasSecurityException) {
            bd.append("  ");
            bd.append("protected static ExecutorService executor; \n");
            bd.append("\n");
        }
        if (TestSuiteWriterUtils.shouldResetProperties(results)) {
            bd.append("  ");
            bd.append("private static final java.util.Properties defaultProperties");
            bd.append(" = (java.util.Properties) java.lang.System.getProperties().clone(); \n");
            bd.append("\n");
        }
        bd.append("  ");
        bd.append("private " + ThreadStopper.class.getName() + " " + THREAD_STOPPER + " = ");
        bd.append(" new " + ThreadStopper.class.getName() + " (");
        bd.append("" + KillSwitchHandler.class.getName() + ".getInstance(), ");
        bd.append("" + Properties.TIMEOUT + "");
        LinkedHashSet<String> threadsToIgnore = new LinkedHashSet<String>(Arrays.asList(Properties.IGNORE_THREADS));
        for (String s : threadsToIgnore) {
            bd.append(", " + s);
        }
        bd.append(");\n\n");
    }
}

