/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.writer;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.DebugGraphics;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.junit.UnitTestAdapter;
import org.evosuite.junit.naming.methods.CoverageGoalTestNameGenerationStrategy;
import org.evosuite.junit.naming.methods.NumberedTestNameGenerationStrategy;
import org.evosuite.junit.naming.methods.TestNameGenerationStrategy;
import org.evosuite.junit.writer.Scaffolding;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.runtime.EvoAssertions;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.testdata.EnvironmentDataList;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.objectweb.asm.Opcodes;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.FileIOUtils;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteWriter
implements Opcodes {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteWriter.class);
    public static final String NOT_GENERATED_TEST_NAME = "notGeneratedAnyTest";
    protected TestCaseExecutor executor = TestCaseExecutor.getInstance();
    protected List<TestCase> testCases = new ArrayList<TestCase>();
    protected Map<Integer, String> testComment = new HashMap<Integer, String>();
    private final UnitTestAdapter adapter = TestSuiteWriterUtils.getAdapter();
    private TestCodeVisitor visitor = new TestCodeVisitor();
    private static final String NEWLINE = System.getProperty("line.separator");
    private TestNameGenerationStrategy nameGenerator = null;

    public int insertTest(TestCase test) {
        if (Properties.CALL_PROBABILITY <= 0.0) {
            for (int i = 0; i < this.testCases.size(); ++i) {
                if (test.isPrefix(this.testCases.get(i))) {
                    logger.info("This is a prefix of an existing test");
                    this.testCases.get(i).addAssertions(test);
                    return i;
                }
                if (!this.testCases.get(i).isPrefix(test)) continue;
                test.addAssertions(this.testCases.get(i));
                this.testCases.set(i, test);
                logger.info("We have a prefix of this one");
                return i;
            }
        }
        logger.info("Adding new test case:");
        if (logger.isDebugEnabled()) {
            logger.debug(test.toCode());
        }
        this.testCases.add(test);
        return this.testCases.size() - 1;
    }

    public int insertTest(TestCase test, String comment) {
        int id = this.insertTest(test);
        if (this.testComment.containsKey(id)) {
            if (!this.testComment.get(id).contains(comment)) {
                this.testComment.put(id, this.testComment.get(id) + NEWLINE + "  " + "//" + comment);
            }
        } else {
            this.testComment.put(id, comment);
        }
        return id;
    }

    public void insertTests(List<TestCase> tests) {
        for (TestCase test : tests) {
            this.insertTest(test);
        }
    }

    public void insertAllTests(List<TestCase> tests) {
        this.testCases.addAll(tests);
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public List<File> writeTestSuite(String name, String directory, List<ExecutionResult> cachedResults) throws IllegalArgumentException {
        File file;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty test class name");
        }
        if (!name.endsWith("Test")) {
            throw new IllegalArgumentException("Test classes should have name ending with 'Test'. Invalid input name: " + name);
        }
        ArrayList<File> generated = new ArrayList<File>();
        String dir = TestSuiteWriterUtils.makeDirectory(directory);
        String content = "";
        this.executor.newObservers();
        LoopCounter.getInstance().setActive(true);
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        for (TestCase test : this.testCases) {
            boolean added = false;
            if (!TimeController.getInstance().hasTimeToExecuteATestCase()) {
                logger.info("Using cached result");
                for (ExecutionResult result : cachedResults) {
                    if (result == null || result.test != test) continue;
                    results.add(result);
                    added = true;
                    break;
                }
            }
            if (added) continue;
            ExecutionResult result = this.runTest(test);
            results.add(result);
        }
        if (Properties.TEST_NAMING_STRATEGY == Properties.TestNamingStrategy.NUMBERED) {
            this.nameGenerator = new NumberedTestNameGenerationStrategy(this.testCases, results);
        } else if (Properties.TEST_NAMING_STRATEGY == Properties.TestNamingStrategy.COVERAGE) {
            this.nameGenerator = new CoverageGoalTestNameGenerationStrategy(this.testCases, results);
        } else {
            throw new RuntimeException("Unsupported naming strategy: " + (Object)((Object)Properties.TEST_NAMING_STRATEGY));
        }
        this.removeUnnecessaryDownCasts(results);
        this.removeAssertionsAfterException(results);
        if (Properties.OUTPUT_GRANULARITY == Properties.OutputGranularity.MERGED || this.testCases.size() == 0) {
            File file2 = new File(dir + "/" + name + ".java");
            content = this.getUnitTestsAllInSameFile(name, results);
            FileIOUtils.writeFile(content, file2);
            generated.add(file2);
        } else {
            for (int i = 0; i < this.testCases.size(); ++i) {
                file = new File(dir + "/" + name + "_" + i + ".java");
                String testCode = this.getOneUnitTestInAFile(name, i, results);
                FileIOUtils.writeFile(testCode, file);
                content = content + testCode;
                generated.add(file);
            }
        }
        if (Properties.TEST_SCAFFOLDING && !Properties.NO_RUNTIME_DEPENDENCY) {
            String scaffoldingName = Scaffolding.getFileName(name);
            file = new File(dir + "/" + scaffoldingName + ".java");
            String scaffoldingContent = Scaffolding.getScaffoldingFileContent(name, results, TestSuiteWriterUtils.hasAnySecurityException(results));
            FileIOUtils.writeFile(scaffoldingContent, file);
            generated.add(file);
            content = content + scaffoldingContent;
        }
        this.writeCoveredGoalsFile();
        TestGenerationResultBuilder.getInstance().setTestSuiteCode(content);
        return generated;
    }

    private String getEmptyTest() {
        StringBuilder bd = new StringBuilder();
        bd.append("  ");
        bd.append("@Test\n");
        bd.append("  ");
        bd.append("public void notGeneratedAnyTest() {\n");
        bd.append("    ");
        bd.append("// EvoSuite did not generate any tests\n");
        bd.append("  ");
        bd.append("}\n");
        return bd.toString();
    }

    private void removeUnnecessaryDownCasts(List<ExecutionResult> results) {
        for (ExecutionResult result : results) {
            if (!(result.test instanceof DefaultTestCase)) continue;
            ((DefaultTestCase)result.test).removeDownCasts();
        }
    }

    private void removeAssertionsAfterException(List<ExecutionResult> results) {
        for (ExecutionResult result : results) {
            if (result.noThrownExceptions()) continue;
            int exceptionPosition = result.getFirstPositionOfThrownException();
            if (result.test.size() <= exceptionPosition) continue;
            result.test.getStatement(exceptionPosition).removeAssertions();
        }
    }

    private String getUnitTestsAllInSameFile(String name, List<ExecutionResult> results) {
        boolean wasSecurityException = TestSuiteWriterUtils.hasAnySecurityException(results);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader(name, name, results));
        if (!Properties.TEST_SCAFFOLDING && !Properties.NO_RUNTIME_DEPENDENCY) {
            builder.append(new Scaffolding().getBeforeAndAfterMethods(name, wasSecurityException, results));
        }
        if (this.testCases.isEmpty()) {
            builder.append(this.getEmptyTest());
        } else {
            for (int i = 0; i < this.testCases.size(); ++i) {
                builder.append(this.testToString(i, i, results.get(i)));
            }
        }
        builder.append(this.getFooter());
        return builder.toString();
    }

    private String getOneUnitTestInAFile(String name, int testId, List<ExecutionResult> results) {
        boolean wasSecurityException = results.get(testId).hasSecurityException();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader(name + "_" + testId, name, results));
        if (!Properties.TEST_SCAFFOLDING) {
            builder.append(new Scaffolding().getBeforeAndAfterMethods(name + "_" + testId, wasSecurityException, results));
        }
        builder.append(this.testToString(testId, testId, results.get(testId)));
        builder.append(this.getFooter());
        return builder.toString();
    }

    protected ExecutionResult runTest(TestCase test) {
        ExecutionResult result = new ExecutionResult(test, null);
        try {
            logger.debug("Executing test");
            result = this.executor.execute(test);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    protected String getImports(List<ExecutionResult> results) {
        StringBuilder builder = new StringBuilder();
        HashSet imports = new HashSet();
        HashSet accessedClasses = new HashSet();
        boolean wasSecurityException = TestSuiteWriterUtils.hasAnySecurityException(results);
        boolean hasException = false;
        for (ExecutionResult executionResult : results) {
            this.visitor.clearExceptions();
            this.visitor.setExceptions(executionResult.exposeExceptionMapping());
            executionResult.test.accept(this.visitor);
            imports.addAll(this.visitor.getImports());
            accessedClasses.addAll(executionResult.test.getAccessedClasses());
            if (hasException) continue;
            hasException = !executionResult.noThrownExceptions();
        }
        this.visitor.clearExceptions();
        if (TestSuiteWriterUtils.doesUseMocks(results)) {
            String mockito = Mockito.class.getCanonicalName();
            builder.append("import static " + mockito + ".*;" + NEWLINE);
            imports.add(ViolatedAssumptionAnswer.class);
        }
        if (hasException && !Properties.NO_RUNTIME_DEPENDENCY) {
            builder.append("import static " + EvoAssertions.class.getCanonicalName() + ".*;" + NEWLINE);
        }
        if (Properties.RESET_STANDARD_STREAMS) {
            imports.add(PrintStream.class);
            imports.add(DebugGraphics.class);
        }
        if (TestSuiteWriterUtils.needToUseAgent() && !Properties.NO_RUNTIME_DEPENDENCY) {
            imports.add(EvoRunner.class);
            imports.add(EvoRunnerParameters.class);
            imports.add(RunWith.class);
        }
        HashSet<String> importNames = new HashSet<String>();
        for (Class<?> imp : imports) {
            String name;
            while (imp.isArray()) {
                imp = imp.getComponentType();
            }
            if (imp.isPrimitive() || imp.getName().startsWith("java.lang") && !(name = imp.getName().replace("java.lang.", "")).contains(".") || !imp.getName().contains(".")) continue;
            if (imp.getName().contains("$")) {
                importNames.add(imp.getName().replace("$", "."));
                continue;
            }
            importNames.add(imp.getName());
        }
        for (Class<?> klass : EnvironmentDataList.getListOfClasses()) {
            if (!accessedClasses.contains(klass)) continue;
            importNames.add(klass.getCanonicalName());
        }
        if (wasSecurityException) {
            importNames.add(ExecutorService.class.getCanonicalName());
            importNames.add(Executors.class.getCanonicalName());
            importNames.add(Future.class.getCanonicalName());
            importNames.add(TimeUnit.class.getCanonicalName());
        }
        if (!Properties.TEST_SCAFFOLDING && !Properties.NO_RUNTIME_DEPENDENCY) {
            importNames.addAll(Scaffolding.getScaffoldingImports(wasSecurityException, results));
        }
        importNames.remove(CodeUnderTestException.class.getCanonicalName());
        ArrayList arrayList = new ArrayList(importNames);
        Collections.sort(arrayList);
        for (String imp : arrayList) {
            builder.append("import ");
            builder.append(imp);
            builder.append(";");
            builder.append(NEWLINE);
        }
        builder.append(NEWLINE);
        return builder.toString();
    }

    protected String getHeader(String test_name, String scaffolding_name, List<ExecutionResult> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append(NEWLINE);
        builder.append(" * This file was automatically generated by EvoSuite");
        builder.append(NEWLINE);
        builder.append(" * " + new Date());
        builder.append(NEWLINE);
        builder.append(" */");
        builder.append(NEWLINE);
        builder.append(NEWLINE);
        if (!Properties.CLASS_PREFIX.equals("")) {
            builder.append("package ");
            builder.append(Properties.CLASS_PREFIX);
            builder.append(";");
            builder.append(NEWLINE);
        }
        builder.append(NEWLINE);
        builder.append(this.adapter.getImports());
        builder.append(this.getImports(results));
        if (TestSuiteWriterUtils.needToUseAgent() && !Properties.NO_RUNTIME_DEPENDENCY) {
            builder.append(this.getRunner());
        }
        builder.append(this.adapter.getClassDefinition(test_name));
        if (Properties.TEST_SCAFFOLDING && !Properties.NO_RUNTIME_DEPENDENCY) {
            builder.append(" extends " + Scaffolding.getFileName(scaffolding_name));
        }
        builder.append(" {");
        builder.append(NEWLINE);
        return builder.toString();
    }

    private Object getRunner() {
        String s = "@RunWith(EvoRunner.class) @EvoRunnerParameters(";
        ArrayList<String> list = new ArrayList<String>();
        if (Properties.REPLACE_CALLS) {
            list.add("mockJVMNonDeterminism = true");
        }
        if (Properties.VIRTUAL_FS) {
            list.add("useVFS = true");
        }
        if (Properties.VIRTUAL_NET) {
            list.add("useVNET = true");
        }
        if (Properties.RESET_STATIC_FIELDS) {
            list.add("resetStaticState = true");
        }
        if (Properties.USE_SEPARATE_CLASSLOADER) {
            list.add("separateClassLoader = true");
        }
        if (Properties.REPLACE_GUI) {
            list.add("mockGUI = true");
        }
        if (!list.isEmpty()) {
            s = s + (String)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                s = s + ", " + (String)list.get(i);
            }
        }
        s = s + ") " + NEWLINE;
        return s;
    }

    protected String getFooter() {
        return "}" + NEWLINE;
    }

    protected String testToString(int number, int id, ExecutionResult result) {
        Object exceptions;
        String methodName;
        boolean wasSecurityException = result.hasSecurityException();
        String testInfo = this.getInformation(id);
        StringBuilder builder = new StringBuilder();
        builder.append(NEWLINE);
        if (Properties.TEST_COMMENTS || this.testComment.containsKey(id)) {
            builder.append("  ");
            builder.append("//");
            builder.append(testInfo);
            builder.append(NEWLINE);
        }
        if ((methodName = this.nameGenerator.getName(this.testCases.get(id))) == null) {
            methodName = TestSuiteWriterUtils.getNameOfTest(this.testCases, number);
        }
        builder.append(this.adapter.getMethodDefinition(methodName));
        builder.append(" throws Throwable ");
        builder.append(" {");
        builder.append(NEWLINE);
        String CODE_SPACE = "      ";
        TestCase test = this.testCases.get(id);
        Integer pos = result.getFirstPositionOfThrownException();
        if (pos != null) {
            if (result.getExceptionThrownAtPosition(pos) instanceof CodeUnderTestException) {
                test.chop(pos);
            } else {
                test.chop(pos + 1);
            }
        }
        if (wasSecurityException) {
            builder.append("    ");
            builder.append("Future<?> future = executor.submit(new Runnable(){ ");
            builder.append(NEWLINE);
            builder.append("      ");
            builder.append("      ");
            builder.append("@Override public void run() { ");
            builder.append(NEWLINE);
            exceptions = test.getDeclaredExceptions();
            if (!exceptions.isEmpty()) {
                builder.append("        ");
                builder.append("try {");
                builder.append(NEWLINE);
            }
            CODE_SPACE = "          ";
        }
        for (String line : this.adapter.getTestString(id, test, result.exposeExceptionMapping(), this.visitor).split("\\r?\\n")) {
            builder.append(CODE_SPACE);
            builder.append(line);
            builder.append(NEWLINE);
        }
        if (wasSecurityException) {
            exceptions = test.getDeclaredExceptions();
            if (!exceptions.isEmpty()) {
                builder.append("        ");
                builder.append("} catch(Throwable t) {");
                builder.append(NEWLINE);
                builder.append("          ");
                builder.append("  // Need to catch declared exceptions");
                builder.append(NEWLINE);
                builder.append("        ");
                builder.append("}");
                builder.append(NEWLINE);
            }
            builder.append("      ");
            builder.append("} ");
            builder.append(NEWLINE);
            builder.append("    ");
            builder.append("});");
            builder.append(NEWLINE);
            long time = Properties.TIMEOUT + 1000;
            builder.append("    ");
            builder.append("future.get(" + time + ", TimeUnit.MILLISECONDS);");
            builder.append(NEWLINE);
        }
        builder.append("  ");
        builder.append("}");
        builder.append(NEWLINE);
        String testCode = builder.toString();
        TestGenerationResultBuilder.getInstance().setTestCase(methodName, testCode, test, testInfo, result);
        return testCode;
    }

    protected String getInformation(int num) {
        if (this.testComment.containsKey(num)) {
            String comment = this.testComment.get(num);
            if (!comment.endsWith("\n")) {
                comment = comment + NEWLINE;
            }
            return comment;
        }
        TestCase test = this.testCases.get(num);
        Set<TestFitnessFunction> coveredGoals = test.getCoveredGoals();
        StringBuilder builder = new StringBuilder();
        builder.append("Test case number: " + num);
        if (!coveredGoals.isEmpty()) {
            builder.append(NEWLINE);
            builder.append("  /*");
            builder.append(NEWLINE);
            builder.append("   * ");
            builder.append(coveredGoals.size() + " covered goal");
            if (coveredGoals.size() != 1) {
                builder.append("s");
            }
            builder.append(":");
            int nr = 1;
            for (TestFitnessFunction goal : coveredGoals) {
                DefUseCoverageTestFitness duGoal;
                builder.append(NEWLINE);
                builder.append("   * Goal " + nr + ". " + goal.toString());
                if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && goal instanceof DefUseCoverageTestFitness && (duGoal = (DefUseCoverageTestFitness)goal).getCoveringTrace() != null) {
                    String traceInformation = duGoal.getCoveringTrace().toDefUseTraceInformation(duGoal.getGoalVariable(), duGoal.getCoveringObjectId());
                    traceInformation = traceInformation.replaceAll("\n", "");
                    builder.append(NEWLINE);
                    builder.append("     * DUTrace: " + traceInformation);
                }
                ++nr;
            }
            builder.append(NEWLINE);
            builder.append("   */");
            builder.append(NEWLINE);
        }
        return builder.toString();
    }

    private void writeCoveredGoalsFile() {
        if (Properties.WRITE_COVERED_GOALS_FILE) {
            StringBuilder builder = new StringBuilder();
            File file = new File(Properties.COVERED_GOALS_FILE);
            for (int i = 0; i < this.testCases.size(); ++i) {
                TestCase test = this.testCases.get(i);
                String generatedName = this.nameGenerator.getName(test);
                String testName = generatedName != null ? generatedName : TestSuiteWriterUtils.getNameOfTest(this.testCases, i);
                Set<TestFitnessFunction> coveredGoals = test.getCoveredGoals();
                for (TestFitnessFunction goal : coveredGoals) {
                    builder.append(testName + "," + goal.toString() + NEWLINE);
                }
            }
            FileIOUtils.writeFile(builder.toString(), file);
        }
    }
}

