/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi.service;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.coverage.ClassStatisticsPrinter;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.stoppingconditions.RMIStoppingCondition;
import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.service.ClientNodeLocal;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.FileIOUtils;
import org.evosuite.utils.Listener;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNodeImpl<T extends Chromosome<T>>
implements ClientNodeLocal<T>,
ClientNodeRemote<T> {
    private static final Logger logger = LoggerFactory.getLogger(ClientNodeImpl.class);
    private static final long serialVersionUID = 485858845631346580L;
    private volatile ClientState state;
    private MasterNodeRemote masterNode;
    private String clientRmiIdentifier;
    protected volatile CountDownLatch doneLatch;
    protected volatile CountDownLatch finishedLatch;
    protected Registry registry;
    protected final Collection<Listener<Set<T>>> listeners = Collections.synchronizedList(new ArrayList());
    protected final ExecutorService searchExecutor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<OutputVariable> outputVariableQueue = new LinkedBlockingQueue<OutputVariable>();
    private Collection<Set<T>> bestSolutions;
    private Thread statisticsThread;

    protected ClientNodeImpl() {
    }

    public ClientNodeImpl(Registry registry, String identifier) {
        this.registry = registry;
        this.state = ClientState.NOT_STARTED;
        this.clientRmiIdentifier = identifier;
        this.doneLatch = new CountDownLatch(1);
        this.finishedLatch = new CountDownLatch(1);
        this.bestSolutions = Collections.synchronizedList(new ArrayList(Properties.NUM_PARALLEL_CLIENTS));
    }

    @Override
    public void startNewSearch() throws RemoteException, IllegalStateException {
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            throw new IllegalStateException("Search has already been started");
        }
        this.searchExecutor.submit(() -> {
            this.changeState(ClientState.STARTED);
            if (Properties.SANDBOX) {
                Sandbox.initializeSecurityManagerForSUT();
            }
            ArrayList<TestGenerationResult> results = new ArrayList<TestGenerationResult>();
            try {
                TestSuiteGenerator generator = new TestSuiteGenerator();
                results.add(generator.generateTestSuite());
                this.masterNode.evosuite_collectTestGenerationResult(this.clientRmiIdentifier, results);
            }
            catch (Throwable t) {
                logger.error("Error when generating tests for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                results.add(TestGenerationResultBuilder.buildErrorResult("Error when generating tests for: " + Properties.TARGET_CLASS + ": " + t));
            }
            this.changeState(ClientState.DONE);
            if (Properties.SANDBOX) {
                Sandbox.resetDefaultSecurityManager();
            }
        });
    }

    @Override
    public void cancelCurrentSearch() throws RemoteException {
        if (this.state == ClientState.INITIALIZATION) {
            System.exit(1);
        }
        RMIStoppingCondition.getInstance().stop();
    }

    @Override
    public boolean waitUntilFinished(long timeoutInMs) throws RemoteException, InterruptedException {
        return this.finishedLatch.await(timeoutInMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void waitUntilDone() {
        try {
            this.doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void emigrate(Set<T> immigrants) {
        try {
            logger.debug(ClientProcess.getPrettyPrintIdentifier() + "Sending " + immigrants.size() + " immigrants");
            this.masterNode.evosuite_migrate(this.clientRmiIdentifier, immigrants);
        }
        catch (RemoteException e) {
            logger.error(ClientProcess.getPrettyPrintIdentifier() + "Cannot send immigrating individuals to master", e);
        }
    }

    @Override
    public void sendBestSolution(Set<T> solutions) {
        try {
            logger.debug(ClientProcess.getPrettyPrintIdentifier() + "sending best solutions to " + "Client-0");
            this.masterNode.evosuite_collectBestSolutions(this.clientRmiIdentifier, solutions);
        }
        catch (RemoteException e) {
            logger.error(ClientProcess.getPrettyPrintIdentifier() + "Cannot send best solution to master", e);
        }
    }

    @Override
    public void changeState(ClientState state) {
        this.changeState(state, new ClientStateInformation(state));
    }

    @Override
    public void changeState(ClientState state, ClientStateInformation information) {
        if (this.state != state) {
            logger.info(ClientProcess.getPrettyPrintIdentifier() + "Client changing state from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
        }
        this.state = state;
        TimeController.getInstance().updateState(state);
        try {
            this.masterNode.evosuite_informChangeOfStateInClient(this.clientRmiIdentifier, state, information);
        }
        catch (RemoteException e) {
            logger.error("Cannot inform master of change of state", e);
        }
        if (this.state.equals((Object)ClientState.DONE)) {
            this.doneLatch.countDown();
        }
        if (this.state.equals((Object)ClientState.FINISHED)) {
            this.finishedLatch.countDown();
        }
    }

    @Override
    public void updateStatistics(T individual) {
        logger.info("Sending current best individual to master process");
        try {
            this.masterNode.evosuite_collectStatistics(this.clientRmiIdentifier, (Chromosome)individual);
        }
        catch (RemoteException e) {
            logger.error("Cannot inform master of change of state", e);
        }
    }

    @Override
    public void flushStatisticsForClassChange() {
        logger.info("Flushing output variables to master process");
        try {
            this.masterNode.evosuite_flushStatisticsForClassChange(this.clientRmiIdentifier);
        }
        catch (RemoteException e) {
            logger.error("Cannot inform master of change of state", e);
        }
    }

    @Override
    public void updateProperty(String propertyName, Object value) {
        logger.info("Updating property '" + propertyName + "' with value '" + value + "' on master process");
        try {
            this.masterNode.evosuite_updateProperty(this.clientRmiIdentifier, propertyName, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | RemoteException | Properties.NoSuchParameterException e) {
            logger.error("Cannot inform master of change of state", e);
        }
    }

    @Override
    public void trackOutputVariable(RuntimeVariable variable, Object value) {
        logger.info("Sending output variable to master process: " + (Object)((Object)variable) + " = " + value);
        this.outputVariableQueue.offer(new OutputVariable(variable, value));
    }

    @Override
    public void publishPermissionStatistics() {
        this.trackOutputVariable(RuntimeVariable.AllPermission, PermissionStatistics.getInstance().getNumAllPermission());
        this.trackOutputVariable(RuntimeVariable.SecurityPermission, PermissionStatistics.getInstance().getNumSecurityPermission());
        this.trackOutputVariable(RuntimeVariable.UnresolvedPermission, PermissionStatistics.getInstance().getNumUnresolvedPermission());
        this.trackOutputVariable(RuntimeVariable.AWTPermission, PermissionStatistics.getInstance().getNumAWTPermission());
        this.trackOutputVariable(RuntimeVariable.FilePermission, PermissionStatistics.getInstance().getNumFilePermission());
        this.trackOutputVariable(RuntimeVariable.SerializablePermission, PermissionStatistics.getInstance().getNumSerializablePermission());
        this.trackOutputVariable(RuntimeVariable.ReflectPermission, PermissionStatistics.getInstance().getNumReflectPermission());
        this.trackOutputVariable(RuntimeVariable.RuntimePermission, PermissionStatistics.getInstance().getNumRuntimePermission());
        this.trackOutputVariable(RuntimeVariable.NetPermission, PermissionStatistics.getInstance().getNumNetPermission());
        this.trackOutputVariable(RuntimeVariable.SocketPermission, PermissionStatistics.getInstance().getNumSocketPermission());
        this.trackOutputVariable(RuntimeVariable.SQLPermission, PermissionStatistics.getInstance().getNumSQLPermission());
        this.trackOutputVariable(RuntimeVariable.PropertyPermission, PermissionStatistics.getInstance().getNumPropertyPermission());
        this.trackOutputVariable(RuntimeVariable.LoggingPermission, PermissionStatistics.getInstance().getNumLoggingPermission());
        this.trackOutputVariable(RuntimeVariable.SSLPermission, PermissionStatistics.getInstance().getNumSSLPermission());
        this.trackOutputVariable(RuntimeVariable.AuthPermission, PermissionStatistics.getInstance().getNumAuthPermission());
        this.trackOutputVariable(RuntimeVariable.AudioPermission, PermissionStatistics.getInstance().getNumAudioPermission());
        this.trackOutputVariable(RuntimeVariable.OtherPermission, PermissionStatistics.getInstance().getNumOtherPermission());
        this.trackOutputVariable(RuntimeVariable.Threads, PermissionStatistics.getInstance().getMaxThreads());
    }

    public void stop() {
        if (this.statisticsThread != null) {
            this.statisticsThread.interrupt();
            ArrayList vars = new ArrayList();
            this.outputVariableQueue.drainTo(vars);
            for (OutputVariable ov : vars) {
                try {
                    this.masterNode.evosuite_collectStatistics(this.clientRmiIdentifier, ov.variable, ov.value);
                }
                catch (RemoteException e) {
                    logger.error("Error when exporting statistics: " + (Object)((Object)ov.variable) + "=" + ov.value, e);
                    break;
                }
            }
            try {
                this.statisticsThread.join(3000L);
            }
            catch (InterruptedException e) {
                logger.error("Failed to stop statisticsThread in time");
            }
            this.statisticsThread = null;
        }
        this.changeState(ClientState.FINISHED);
    }

    @Override
    public boolean init() {
        try {
            this.masterNode = (MasterNodeRemote)this.registry.lookup("MasterNode");
            this.masterNode.evosuite_registerClientNode(this.clientRmiIdentifier);
            this.masterNode.evosuite_informChangeOfStateInClient(this.clientRmiIdentifier, this.state, new ClientStateInformation(this.state));
            this.statisticsThread = new Thread(){

                @Override
                public void run() {
                    while (!this.isInterrupted()) {
                        OutputVariable ov = null;
                        try {
                            ov = (OutputVariable)ClientNodeImpl.this.outputVariableQueue.take();
                            ClientNodeImpl.this.masterNode.evosuite_collectStatistics(ClientNodeImpl.this.clientRmiIdentifier, ov.variable, ov.value);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        catch (RemoteException e) {
                            logger.error("Error when exporting statistics: " + (Object)((Object)ov.variable) + "=" + ov.value, e);
                            break;
                        }
                    }
                }
            };
            this.statisticsThread.setName("Statistics sender in client process");
            Sandbox.addPrivilegedThread(this.statisticsThread);
            this.statisticsThread.start();
        }
        catch (Exception e) {
            logger.error("Error when connecting to master via RMI", e);
            return false;
        }
        return true;
    }

    public String getClientRmiIdentifier() {
        return this.clientRmiIdentifier;
    }

    @Override
    public void doCoverageAnalysis() throws RemoteException {
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            throw new IllegalArgumentException("Search has already been started");
        }
        this.searchExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ClientNodeImpl.this.changeState(ClientState.STARTED);
                if (Properties.SANDBOX) {
                    Sandbox.initializeSecurityManagerForSUT();
                }
                try {
                    boolean archive = Properties.TEST_ARCHIVE;
                    Properties.TEST_ARCHIVE = false;
                    CoverageAnalysis.analyzeCoverage();
                    Properties.TEST_ARCHIVE = archive;
                }
                catch (Throwable t) {
                    logger.error("Error when analysing coverage for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                }
                ClientNodeImpl.this.changeState(ClientState.DONE);
                if (Properties.SANDBOX) {
                    Sandbox.resetDefaultSecurityManager();
                }
            }
        });
    }

    @Override
    public void doDependencyAnalysis(String fileName) throws RemoteException {
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            throw new IllegalArgumentException("Search has already been started");
        }
        this.searchExecutor.submit(() -> {
            this.changeState(ClientState.STARTED);
            Sandbox.goingToExecuteSUTCode();
            TestGenerationContext.getInstance().goingToExecuteSUTCode();
            Sandbox.goingToExecuteUnsafeCodeOnSameThread();
            try {
                LoggingUtils.getEvoLogger().info("* Analyzing classpath (dependency analysis)");
                DependencyAnalysis.analyzeClass(Properties.TARGET_CLASS, Arrays.asList(ClassPathHandler.getInstance().getClassPathElementsForTargetProject()));
                StringBuffer fileNames = new StringBuffer();
                for (Class<?> clazz : TestCluster.getInstance().getAnalyzedClasses()) {
                    fileNames.append(clazz.getName());
                    fileNames.append("\n");
                }
                LoggingUtils.getEvoLogger().info("* Writing class dependencies to file " + fileName);
                FileIOUtils.writeFile(fileNames.toString(), fileName);
            }
            catch (Throwable t) {
                logger.error("Error when analysing coverage for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
            }
            finally {
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                Sandbox.doneWithExecutingSUTCode();
                TestGenerationContext.getInstance().doneWithExecutingSUTCode();
            }
            this.changeState(ClientState.DONE);
        });
    }

    @Override
    public void printClassStatistics() throws RemoteException {
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            throw new IllegalArgumentException("Search has already been started");
        }
        this.searchExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ClientNodeImpl.this.changeState(ClientState.STARTED);
                if (Properties.SANDBOX) {
                    Sandbox.initializeSecurityManagerForSUT();
                }
                try {
                    ClassStatisticsPrinter.printClassStatistics();
                }
                catch (Throwable t) {
                    logger.error("Error when analysing coverage for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                }
                ClientNodeImpl.this.changeState(ClientState.DONE);
            }
        });
    }

    @Override
    public void immigrate(Set<T> migrants) throws RemoteException {
        logger.debug(ClientProcess.getPrettyPrintIdentifier() + "receiving " + (migrants != null ? migrants.size() : 0) + " immigrants");
        this.fireEvent(migrants);
    }

    @Override
    public void collectBestSolutions(Set<T> solutions) throws RemoteException {
        logger.debug(ClientProcess.getPrettyPrintIdentifier() + "added solution to set");
        this.bestSolutions.add(solutions);
    }

    @Override
    public void addListener(Listener<Set<T>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void deleteListener(Listener<Set<T>> listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(Set<T> event) {
        for (Listener<Set<Set<T>>> listener : this.listeners) {
            listener.receiveEvent(event);
        }
    }

    @Override
    public Set<Set<T>> getBestSolutions() {
        do {
            if (this.bestSolutions.size() != Properties.NUM_PARALLEL_CLIENTS - 1) continue;
            return new HashSet<Set<T>>(this.bestSolutions);
        } while (this.finishedLatch.getCount() != 0L);
        return null;
    }

    private static class OutputVariable {
        public RuntimeVariable variable;
        public Object value;

        public OutputVariable(RuntimeVariable variable, Object value) {
            this.variable = variable;
            this.value = value;
        }
    }
}

