/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi.service;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.rmi.service.MasterNodeLocal;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.SearchStatistics;
import org.evosuite.utils.Listener;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterNodeImpl
implements MasterNodeRemote,
MasterNodeLocal {
    private static final long serialVersionUID = -6329473514791197464L;
    private static final Logger logger = LoggerFactory.getLogger(MasterNodeImpl.class);
    private final Registry registry;
    private final Map<String, ClientNodeRemote> clients;
    protected final Collection<Listener<ClientStateInformation>> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, ClientState> clientStates;
    private final Map<String, ClientStateInformation> clientStateInformation;

    public MasterNodeImpl(Registry registry) {
        this.clients = new ConcurrentHashMap<String, ClientNodeRemote>();
        this.clientStates = new ConcurrentHashMap<String, ClientState>();
        this.clientStateInformation = new ConcurrentHashMap<String, ClientStateInformation>();
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evosuite_registerClientNode(String clientRmiIdentifier) throws RemoteException {
        ClientNodeRemote node = null;
        try {
            node = (ClientNodeRemote)this.registry.lookup(clientRmiIdentifier);
        }
        catch (Exception e) {
            logger.error("Error when client " + clientRmiIdentifier + " tries to register to master", e);
            return;
        }
        Map<String, ClientNodeRemote> map = this.clients;
        synchronized (map) {
            this.clients.put(clientRmiIdentifier, node);
            this.clients.notifyAll();
        }
    }

    @Override
    public void evosuite_informChangeOfStateInClient(String clientRmiIdentifier, ClientState state, ClientStateInformation information) throws RemoteException {
        this.clientStates.put(clientRmiIdentifier, state);
        information.setState(state);
        this.clientStateInformation.put(clientRmiIdentifier, information);
        this.fireEvent(information);
    }

    @Override
    public Collection<ClientState> getCurrentState() {
        return this.clientStates.values();
    }

    @Override
    public ClientState getCurrentState(String clientId) {
        return this.clientStates.get(clientId);
    }

    @Override
    public Collection<ClientStateInformation> getCurrentStateInformation() {
        return this.clientStateInformation.values();
    }

    @Override
    public String getSummaryOfClientStatuses() {
        if (this.clientStates.isEmpty()) {
            return "No client has registered";
        }
        String summary = "";
        for (String id : this.clientStates.keySet()) {
            ClientState state = this.clientStates.get(id);
            summary = summary + id + ": " + (Object)((Object)state) + "\n";
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ClientNodeRemote> getClientsOnceAllConnected(long timeoutInMs) throws InterruptedException {
        long start = System.currentTimeMillis();
        int numberOfExpectedClients = Properties.NUM_PARALLEL_CLIENTS;
        Map<String, ClientNodeRemote> map = this.clients;
        synchronized (map) {
            while (this.clients.size() != numberOfExpectedClients) {
                long elapsed = System.currentTimeMillis() - start;
                long timeRemained = timeoutInMs - elapsed;
                if (timeRemained <= 0L) {
                    return null;
                }
                this.clients.wait(timeRemained);
            }
            return Collections.unmodifiableMap(this.clients);
        }
    }

    @Override
    public void cancelAllClients() {
        for (ClientNodeRemote client : this.clients.values()) {
            try {
                LoggingUtils.getEvoLogger().info("Trying to kill client " + client);
                client.cancelCurrentSearch();
            }
            catch (RemoteException e) {
                logger.warn("Error while trying to cancel client: " + e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void evosuite_collectStatistics(String clientRmiIdentifier, Chromosome individual) {
        SearchStatistics.getInstance(clientRmiIdentifier).currentIndividual(individual);
    }

    @Override
    public void evosuite_collectStatistics(String clientRmiIdentifier, RuntimeVariable variable, Object value) throws RemoteException {
        SearchStatistics.getInstance(clientRmiIdentifier).setOutputVariable(variable, value);
    }

    @Override
    public void evosuite_collectTestGenerationResult(String clientRmiIdentifier, List<TestGenerationResult> results) throws RemoteException {
        SearchStatistics.getInstance(clientRmiIdentifier).addTestGenerationResult(results);
    }

    @Override
    public void evosuite_flushStatisticsForClassChange(String clientRmiIdentifier) throws RemoteException {
        SearchStatistics.getInstance(clientRmiIdentifier).writeStatisticsForAnalysis();
    }

    @Override
    public void evosuite_updateProperty(String clientRmiIdentifier, String propertyName, Object value) throws RemoteException, IllegalArgumentException, IllegalAccessException, Properties.NoSuchParameterException {
        Properties.getInstance().setValue(propertyName, value);
    }

    @Override
    public void evosuite_migrate(String clientRmiIdentifier, Set<? extends Chromosome> migrants) throws RemoteException {
        int idSender = Integer.parseInt(clientRmiIdentifier.replaceAll("[^0-9]", ""));
        int idNeighbour = (idSender + 1) % Properties.NUM_PARALLEL_CLIENTS;
        while (!ClientState.SEARCH.equals((Object)this.clientStates.get("ClientNode" + idNeighbour)) && idNeighbour != idSender) {
            idNeighbour = (idNeighbour + 1) % Properties.NUM_PARALLEL_CLIENTS;
        }
        if (idNeighbour != idSender) {
            ClientNodeRemote node = this.clients.get("ClientNode" + idNeighbour);
            node.immigrate(migrants);
        }
    }

    @Override
    public void evosuite_collectBestSolutions(String clientRmiIdentifier, Set<? extends Chromosome> solutions) {
        try {
            ClientNodeRemote node = this.clients.get("Client-0");
            node.collectBestSolutions(solutions);
        }
        catch (RemoteException e) {
            logger.error("Cannot send best solutions to client 0", e);
        }
    }

    @Override
    public void addListener(Listener<ClientStateInformation> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void deleteListener(Listener<ClientStateInformation> listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(ClientStateInformation event) {
        for (Listener<ClientStateInformation> listener : this.listeners) {
            listener.receiveEvent(event);
        }
    }
}

