/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.evosuite.runtime.System;
import org.evosuite.runtime.jvm.ShutdownHookHandler;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;

public class MockRuntime
implements StaticReplacementMock {
    @Override
    public String getMockedClassName() {
        return Runtime.class.getName();
    }

    public static Runtime getRuntime() {
        return Runtime.getRuntime();
    }

    public static void runFinalizersOnExit(boolean value) {
    }

    public static void exit(Runtime runtime, int status) {
        throw new System.SystemExitException();
    }

    public static void addShutdownHook(Runtime runtime, Thread hook) {
        runtime.addShutdownHook(hook);
    }

    public static boolean removeShutdownHook(Runtime runtime, Thread hook) {
        return runtime.removeShutdownHook(hook);
    }

    public static void halt(Runtime runtime, int status) {
        ShutdownHookHandler.getInstance().processWasHalted();
        throw new System.SystemExitException();
    }

    public static Process exec(Runtime runtime, String command) throws IOException {
        return MockRuntime.exec(runtime, command, null, null);
    }

    public static Process exec(Runtime runtime, String command, String[] envp) throws IOException {
        return MockRuntime.exec(runtime, command, envp, null);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, File dir) throws IOException {
        if (command.length() == 0) {
            throw new MockIllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return MockRuntime.exec(runtime, cmdarray, envp, dir);
    }

    public static Process exec(Runtime runtime, String[] cmdarray) throws IOException {
        return MockRuntime.exec(runtime, cmdarray, null, null);
    }

    public static Process exec(Runtime runtime, String[] cmdarray, String[] envp) throws IOException {
        return MockRuntime.exec(runtime, cmdarray, envp, null);
    }

    public static Process exec(Runtime runtime, String[] cmdarray, String[] envp, File dir) throws IOException {
        throw new MockIOException("Cannot start processes in a unit test");
    }

    public static void gc(Runtime runtime) {
    }

    public static void runFinalization(Runtime runtime) {
    }

    public static void traceInstructions(Runtime runtime, boolean on) {
    }

    public static void traceMethodCalls(Runtime runtime, boolean on) {
    }

    public static void load(Runtime runtime, String filename) {
        runtime.load(filename);
    }

    public static void loadLibrary(Runtime runtime, String libname) {
        runtime.loadLibrary(libname);
    }

    public static InputStream getLocalizedInputStream(Runtime runtime, InputStream in) {
        return in;
    }

    public static OutputStream getLocalizedOutputStream(Runtime runtime, OutputStream out) {
        return out;
    }

    public static int availableProcessors(Runtime runtime) {
        return 1;
    }

    public static long freeMemory(Runtime runtime) {
        return 200L;
    }

    public static long totalMemory(Runtime runtime) {
        return 400L;
    }

    public static long maxMemory(Runtime runtime) {
        return 500L;
    }
}

