/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.lang.MockError;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.mock.java.net.EvoDatagramSocketImpl;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockDatagramSocket
extends DatagramSocket
implements OverrideMock {
    private static final Logger logger = LoggerFactory.getLogger(MockDatagramSocket.class);
    private static final int ST_NOT_CONNECTED = 0;
    private static final int ST_CONNECTED = 1;
    private static final int ST_CONNECTED_NO_IMPL = 2;
    private static final Method CREATE_IMPL;
    private static final Field IMPL;
    private final Object closeLock = new Object();
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private int connectState = 0;
    private EvoDatagramSocketImpl impl;
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;

    protected MockDatagramSocket(DatagramSocketImpl impl) throws SocketException {
        super(MockFramework.isEnabled() ? new EvoDatagramSocketImpl() : impl);
        if (!MockFramework.isEnabled()) {
            return;
        }
        this.createImpl();
    }

    public MockDatagramSocket() throws SocketException {
        super(new EvoDatagramSocketImpl());
        if (!MockFramework.isEnabled()) {
            try {
                IMPL.set(this, null);
                CREATE_IMPL.invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new SocketException("" + e.getCause().getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error("Failed reflection");
            }
            super.bind(new InetSocketAddress(0));
            return;
        }
        this.createImpl();
        try {
            this.bind(new MockInetSocketAddress(0));
        }
        catch (SocketException se) {
            throw se;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    public MockDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(new EvoDatagramSocketImpl());
        if (!MockFramework.isEnabled()) {
            try {
                IMPL.set(this, null);
                CREATE_IMPL.invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new SocketException("" + e.getCause().getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error("Failed reflection");
            }
            if (bindaddr != null) {
                super.bind(bindaddr);
            }
            return;
        }
        this.createImpl();
        if (bindaddr != null) {
            this.bind(bindaddr);
        }
    }

    public MockDatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public MockDatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(MockFramework.isEnabled() ? new MockInetSocketAddress(laddr, port) : new InetSocketAddress(laddr, port));
    }

    private void createImpl() throws SocketException {
        if (this.impl == null) {
            this.impl = new EvoDatagramSocketImpl();
        }
        this.impl.create();
        this.created = true;
    }

    private synchronized void connectInternal(InetAddress address, int port) throws SocketException {
        if (port < 0 || port > 65535) {
            throw new MockIllegalArgumentException("connect: " + port);
        }
        if (address == null) {
            throw new MockIllegalArgumentException("connect: null address");
        }
        this.checkAddress(address, "connect");
        if (this.isClosed()) {
            return;
        }
        if (!this.isBound()) {
            this.bind(new MockInetSocketAddress(0));
        }
        try {
            this.getImpl().connect(address, port);
            this.connectState = 1;
        }
        catch (SocketException se) {
            this.connectState = 2;
        }
        this.connectedAddress = address;
        this.connectedPort = port;
    }

    private EvoDatagramSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.bind(addr);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("already bound");
        }
        if (addr == null) {
            addr = new MockInetSocketAddress(0);
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new MockIllegalArgumentException("Unsupported address type!");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        InetAddress iaddr = epoint.getAddress();
        int port = epoint.getPort();
        this.checkAddress(iaddr, "bind");
        try {
            this.getImpl().bind(port, iaddr);
        }
        catch (SocketException e) {
            this.getImpl().close();
            throw e;
        }
        this.bound = true;
    }

    private void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new MockIllegalArgumentException(op + ": invalid address type");
        }
    }

    @Override
    public void connect(InetAddress address, int port) {
        if (!MockFramework.isEnabled()) {
            super.connect(address, port);
            return;
        }
        try {
            this.connectInternal(address, port);
        }
        catch (SocketException se) {
            throw new MockError("connect failed", se);
        }
    }

    @Override
    public void connect(SocketAddress addr) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.connect(addr);
            return;
        }
        if (addr == null) {
            throw new MockIllegalArgumentException("Address can't be null");
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new MockIllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.connectInternal(epoint.getAddress(), epoint.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (!MockFramework.isEnabled()) {
            super.disconnect();
            return;
        }
        MockDatagramSocket mockDatagramSocket = this;
        synchronized (mockDatagramSocket) {
            if (this.isClosed()) {
                return;
            }
            if (this.connectState == 1) {
                this.impl.disconnect();
            }
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connectState = 0;
        }
    }

    @Override
    public boolean isBound() {
        if (!MockFramework.isEnabled()) {
            return super.isBound();
        }
        return this.bound;
    }

    @Override
    public boolean isConnected() {
        if (!MockFramework.isEnabled()) {
            return super.isConnected();
        }
        return this.connectState != 0;
    }

    @Override
    public InetAddress getInetAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getInetAddress();
        }
        return this.connectedAddress;
    }

    @Override
    public int getPort() {
        if (!MockFramework.isEnabled()) {
            return super.getPort();
        }
        return this.connectedPort;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getRemoteSocketAddress();
        }
        if (!this.isConnected()) {
            return null;
        }
        return new MockInetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalSocketAddress();
        }
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        return new MockInetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.send(p);
            return;
        }
        InetAddress packetAddress = null;
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.checkAddress(p.getAddress(), "send");
            if (this.connectState != 0) {
                packetAddress = p.getAddress();
                if (packetAddress == null) {
                    p.setAddress(this.connectedAddress);
                    p.setPort(this.connectedPort);
                } else if (!packetAddress.equals(this.connectedAddress) || p.getPort() != this.connectedPort) {
                    throw new MockIllegalArgumentException("connected address and packet address differ");
                }
            }
            if (!this.isBound()) {
                this.bind(new MockInetSocketAddress(0));
            }
            this.getImpl().send(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receive(DatagramPacket p) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.receive(p);
            return;
        }
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (!this.isBound()) {
                this.bind(new MockInetSocketAddress(0));
            }
            if (this.connectState == 2) {
                // empty if block
            }
            this.getImpl().receive(p);
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalAddress();
        }
        if (this.isClosed()) {
            return null;
        }
        InetAddress in = null;
        try {
            in = (InetAddress)this.getImpl().getOption(15);
            if (in.isAnyLocalAddress()) {
                in = MockInetAddress.anyLocalAddress();
            }
        }
        catch (Exception e) {
            in = MockInetAddress.anyLocalAddress();
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!MockFramework.isEnabled()) {
            super.close();
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.impl.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        if (!MockFramework.isEnabled()) {
            return super.isClosed();
        }
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public DatagramChannel getChannel() {
        if (!MockFramework.isEnabled()) {
            return super.getChannel();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalPort();
        }
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        throw new MockIOException("Setting of factory is not supported");
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setSoTimeout(timeout);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, (Object)timeout);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getSoTimeout();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.getImpl() == null) {
            return 0;
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setSendBufferSize(size);
            return;
        }
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, (Object)size);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getSendBufferSize();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setReceiveBufferSize(size);
            return;
        }
        if (size <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, (Object)size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getReceiveBufferSize();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public synchronized void setReuseAddress(boolean on) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setReuseAddress(on);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    @Override
    public synchronized boolean getReuseAddress() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getReuseAddress();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4);
        return (Boolean)o;
    }

    @Override
    public synchronized void setBroadcast(boolean on) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setBroadcast(on);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(32, (Object)on);
    }

    @Override
    public synchronized boolean getBroadcast() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getBroadcast();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(32);
    }

    @Override
    public synchronized void setTrafficClass(int tc) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setTrafficClass(tc);
            return;
        }
        if (tc < 0 || tc > 255) {
            throw new MockIllegalArgumentException("tc is not in range 0 -- 255");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(3, (Object)tc);
    }

    @Override
    public synchronized int getTrafficClass() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getTrafficClass();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Integer)this.getImpl().getOption(3);
    }

    static {
        Method m = null;
        try {
            m = DatagramSocket.class.getDeclaredMethod("createImpl", new Class[0]);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            logger.error("Failed reflection on DatagramSocket: " + e.getMessage());
        }
        Field f = null;
        try {
            f = DatagramSocket.class.getDeclaredField("impl");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            logger.error("Failed reflection on DatagramSocket: " + e.getMessage());
        }
        CREATE_IMPL = m;
        IMPL = f;
    }
}

