/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.util.prefs;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.util.prefs.PreferencesImpl;

public class MockPreferences
implements StaticReplacementMock {
    private static PreferencesImpl userRoot = new PreferencesImpl(null, "");
    private static PreferencesImpl systemRoot = new PreferencesImpl(null, "");

    @Override
    public String getMockedClassName() {
        return Preferences.class.getName();
    }

    public static void resetPreferences() {
        try {
            userRoot.removeNodeSpi();
            systemRoot.removeNodeSpi();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static Preferences userRoot() {
        return userRoot;
    }

    public static Preferences systemRoot() {
        return systemRoot;
    }

    public static Preferences systemNodeForPackage(Class<?> c) {
        return MockPreferences.systemRoot().node(MockPreferences.nodeName(c));
    }

    public static Preferences userNodeForPackage(Class<?> c) {
        return MockPreferences.userRoot().node(MockPreferences.nodeName(c));
    }

    private static String nodeName(Class c) {
        if (c.isArray()) {
            throw new IllegalArgumentException("Arrays have no associated preferences node.");
        }
        String className = c.getName();
        int pkgEndIndex = className.lastIndexOf(46);
        if (pkgEndIndex < 0) {
            return "/<unnamed>";
        }
        String packageName = className.substring(0, pkgEndIndex);
        return "/" + packageName.replace('.', '/');
    }
}

