/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.thread;

import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.java.util.MockTimer;
import org.evosuite.runtime.thread.KillSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadStopper {
    private static final Logger logger = LoggerFactory.getLogger(ThreadStopper.class);
    protected transient Set<Thread> currentRunningThreads;
    private final KillSwitch killSwitch;
    private final Set<String> threadsToIgnore;
    private final long timeout;
    private long startTime;

    public ThreadStopper(KillSwitch killSwitch, Set<String> threadsToIgnore, long timeout) {
        this.killSwitch = killSwitch;
        this.timeout = timeout;
        this.threadsToIgnore = threadsToIgnore == null ? new LinkedHashSet<String>() : threadsToIgnore;
        this.startTime = 0L;
    }

    public ThreadStopper(KillSwitch killSwitch, long timeout, String ... threadsToIgnore) {
        this(killSwitch, new LinkedHashSet<String>(Arrays.asList(threadsToIgnore)), timeout);
    }

    public void startRecordingTime() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void storeCurrentThreads() {
        if (this.currentRunningThreads == null) {
            this.currentRunningThreads = Collections.newSetFromMap(new IdentityHashMap());
        } else {
            this.currentRunningThreads.clear();
        }
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Thread t : threadMap.keySet()) {
            if (!t.isAlive()) continue;
            this.currentRunningThreads.add(t);
        }
    }

    public void killAndJoinClientThreads() throws IllegalStateException {
        if (this.currentRunningThreads == null) {
            throw new IllegalStateException("The current threads are not set. You need to call storeCurrentThreads() first");
        }
        if (RuntimeSettings.mockJVMNonDeterminism) {
            MockTimer.stopAllTimers();
        }
        Thread[] threadArray = new Thread[Thread.activeCount() + 2];
        Thread.enumerate(threadArray);
        this.killSwitch.setKillSwitch(true);
        block2: for (Thread t : threadArray) {
            if (t == null || !t.isAlive() || this.currentRunningThreads.contains(t)) continue;
            for (String name : this.threadsToIgnore) {
                if (!t.getName().startsWith(name)) continue;
                continue block2;
            }
            t.interrupt();
        }
        block4: for (Thread t : threadArray) {
            block8: {
                if (t == null || !t.isAlive() || this.currentRunningThreads.contains(t)) continue;
                for (String name : this.threadsToIgnore) {
                    if (!t.getName().startsWith(name)) continue;
                    continue block4;
                }
                logger.info("Found new thread");
                try {
                    long delta = System.currentTimeMillis() - this.startTime;
                    long waitingTime = this.timeout - delta;
                    if (waitingTime <= 0L) break block8;
                    t.join(waitingTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (!t.isAlive()) continue;
            logger.info("Thread is still alive: " + t.getName());
        }
        this.killSwitch.setKillSwitch(false);
        this.currentRunningThreads = null;
    }
}

