/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vfs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.evosuite.runtime.vfs.FSObject;

public class VFolder
extends FSObject {
    private final List<FSObject> children = new CopyOnWriteArrayList<FSObject>();

    public VFolder(String path, VFolder parent) {
        super(path, parent);
    }

    @Override
    public boolean delete() {
        if (this.children.size() > 0) {
            return false;
        }
        return super.delete();
    }

    public boolean isRoot() {
        return this.parent == null && this.path == null;
    }

    public void addChild(FSObject child) {
        this.children.add(child);
    }

    public boolean removeChild(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
        for (FSObject element : this.children) {
            if (!name.equals(element.getName())) continue;
            return this.children.remove(element);
        }
        return false;
    }

    public boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    public String[] getChildrenNames() {
        ArrayList<String> list = new ArrayList<String>(this.children.size());
        for (FSObject child : this.children) {
            list.add(child.getName());
        }
        return list.toArray(new String[0]);
    }

    public FSObject getChild(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
        for (FSObject current : this.children) {
            if (!name.equals(current.getName())) continue;
            return current;
        }
        return null;
    }
}

