/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.DynamicConstantPool;
import org.evosuite.seeding.DynamicConstantVariableProbabilityPool;
import org.evosuite.seeding.StaticConstantPool;
import org.evosuite.seeding.StaticConstantVariableProbabilityPool;
import org.evosuite.utils.Randomness;

public class ConstantPoolManager {
    private static ConstantPoolManager instance = new ConstantPoolManager();
    private ConstantPool[] pools;
    private double[] probabilities;
    private static final int DYNAMIC_POOL_INDEX = 2;

    private ConstantPoolManager() {
        this.init();
    }

    private void init() {
        this.pools = !Properties.VARIABLE_POOL ? new ConstantPool[]{new StaticConstantPool(), new StaticConstantPool(), new DynamicConstantPool()} : new ConstantPool[]{new StaticConstantVariableProbabilityPool(), new StaticConstantVariableProbabilityPool(), new DynamicConstantVariableProbabilityPool()};
        this.initDefaultProbabilities();
    }

    private void initDefaultProbabilities() {
        this.probabilities = new double[this.pools.length];
        double p = (1.0 - Properties.DYNAMIC_POOL) / (double)(this.probabilities.length - 1);
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.probabilities[i] = p;
        }
        this.probabilities[2] = Properties.DYNAMIC_POOL;
        this.normalizeProbabilities();
    }

    private void normalizeProbabilities() {
        double sum = 0.0;
        for (double p : this.probabilities) {
            sum += p;
        }
        double delta = 1.0 / sum;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.probabilities[i] = this.probabilities[i] * delta;
        }
    }

    public static ConstantPoolManager getInstance() {
        return instance;
    }

    public void addSUTConstant(Object value) {
        this.pools[0].add(value);
    }

    public void addNonSUTConstant(Object value) {
        this.pools[1].add(value);
    }

    public void addDynamicConstant(Object value) {
        this.pools[2].add(value);
    }

    public ConstantPool getConstantPool() {
        double p = Randomness.nextDouble();
        double k = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if (!(p < (k += this.probabilities[i]))) continue;
            return this.pools[i];
        }
        return this.pools[0];
    }

    public ConstantPool getDynamicConstantPool() {
        return this.pools[2];
    }

    public void reset() {
        this.init();
    }
}

