/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.seeding.ObjectSequence;
import org.evosuite.testcarver.extraction.CarvingClassLoader;
import org.evosuite.testcarver.extraction.CarvingRunListener;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.DebuggingObjectOutputStream;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericClass;
import org.junit.runner.JUnitCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPool
implements Serializable {
    private static final long serialVersionUID = 2016387518459994272L;
    protected final Map<GenericClass, Set<TestCase>> pool = new HashMap<GenericClass, Set<TestCase>>();
    protected static final Logger logger = LoggerFactory.getLogger(ObjectPool.class);

    public void addSequence(GenericClass clazz, TestCase sequence) {
        ObjectSequence seq = new ObjectSequence(clazz, sequence);
        this.addSequence(seq);
    }

    private void addSequence(ObjectSequence sequence) {
        if (!this.pool.containsKey(sequence.getGeneratedClass())) {
            this.pool.put(sequence.getGeneratedClass(), new HashSet());
        }
        this.pool.get(sequence.getGeneratedClass()).add(sequence.getSequence());
        logger.info("Added new sequence for " + sequence.getGeneratedClass());
        logger.info(sequence.getSequence().toCode());
    }

    public TestCase getRandomSequence(GenericClass clazz) {
        return Randomness.choice(this.getSequences(clazz));
    }

    public Set<TestCase> getSequences(GenericClass clazz) {
        if (this.pool.containsKey(clazz)) {
            return this.pool.get(clazz);
        }
        LinkedHashSet<Set<TestCase>> candidates = new LinkedHashSet<Set<TestCase>>();
        for (GenericClass poolClazz : this.pool.keySet()) {
            if (!poolClazz.isAssignableTo(clazz)) continue;
            candidates.add(this.pool.get(poolClazz));
        }
        return (Set)Randomness.choice(candidates);
    }

    public Set<GenericClass> getClasses() {
        return this.pool.keySet();
    }

    public boolean hasSequence(GenericClass clazz) {
        if (this.pool.containsKey(clazz)) {
            return true;
        }
        return this.pool.keySet().stream().anyMatch(poolClazz -> poolClazz.isAssignableTo(clazz));
    }

    public int getNumberOfClasses() {
        return this.pool.size();
    }

    public int getNumberOfSequences() {
        return this.pool.values().stream().mapToInt(Set::size).sum();
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public static ObjectPool getPoolFromFile(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream objectIn = new ObjectInputStream(in);
            ObjectPool pool = (ObjectPool)objectIn.readObject();
            ((InputStream)in).close();
            pool.filterUnaccessibleTests();
            return pool;
        }
        catch (Exception e) {
            logger.error("Exception while trying to get object pool from " + fileName + " , " + e.getMessage(), e);
            return null;
        }
    }

    protected void filterUnaccessibleTests() {
        for (Set<TestCase> testSet : this.pool.values()) {
            Iterator<TestCase> testIterator = testSet.iterator();
            while (testIterator.hasNext()) {
                TestCase currentTest = testIterator.next();
                if (currentTest.isAccessible()) continue;
                logger.info("Removing test containing inaccessible elements");
                testIterator.remove();
            }
        }
    }

    public static ObjectPool getPoolFromTestSuite(TestSuiteChromosome testSuite) {
        ObjectPool pool = new ObjectPool();
        for (TestChromosome testChromosome : testSuite.getTestChromosomes()) {
            TestCase test = testChromosome.getTestCase().clone();
            test.removeAssertions();
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (testChromosome.hasException() || !test.hasObject(targetClass, test.size())) continue;
            pool.addSequence(new GenericClass(targetClass), test);
        }
        return pool;
    }

    public static ObjectPool getPoolFromJUnit(GenericClass targetClass, Class<?> testSuite) {
        JUnitCore runner = new JUnitCore();
        CarvingRunListener listener = new CarvingRunListener();
        runner.addListener(listener);
        CarvingClassLoader classLoader = new CarvingClassLoader();
        try {
            classLoader.loadClass(Properties.TARGET_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ObjectPool pool = new ObjectPool();
        runner.run(testSuite);
        for (TestCase test : listener.getTestCases().get(Properties.getTargetClassAndDontInitialise())) {
            pool.addSequence(targetClass, test);
        }
        return pool;
    }

    public void writePool(String fileName) {
        try {
            DebuggingObjectOutputStream out = new DebuggingObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(this);
            out.close();
        }
        catch (IOException e) {
            logger.warn("Error while writing pool to file " + fileName + ": " + e);
        }
    }
}

