/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.evosuite.instrumentation.ExceptionTransformationClassAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMapGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionMapGenerator.class);

    public static void initializeExceptionMap(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        if (targetClass != null) {
            for (MethodNode mn : targetClass.methods) {
                logger.debug("Method: " + mn.name);
                ExceptionMapGenerator.handleMethodNode(targetClass, mn);
                ExceptionMapGenerator.handleMethodCalls(targetClass, mn);
            }
        }
    }

    private static void handleDependency(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        if (targetClass != null) {
            for (MethodNode mn : targetClass.methods) {
                logger.debug("Method: " + mn.name);
                ExceptionMapGenerator.handleMethodNode(targetClass, mn);
            }
        }
    }

    private static void handleMethodNode(ClassNode cn, MethodNode mn) {
        if (!ExceptionTransformationClassAdapter.methodExceptionMap.containsKey(cn.name)) {
            ExceptionTransformationClassAdapter.methodExceptionMap.put(cn.name, new LinkedHashMap());
        }
        String methodNameDesc = mn.name + mn.desc;
        LinkedHashSet<Type> exceptionTypes = new LinkedHashSet<Type>();
        if (mn.exceptions != null) {
            for (String exceptionName : mn.exceptions) {
                exceptionTypes.add(Type.getObjectType(exceptionName));
                logger.debug("Method {} throws {}", (Object)mn.name, (Object)exceptionName);
            }
        }
        ExceptionTransformationClassAdapter.methodExceptionMap.get(cn.name).put(methodNameDesc, exceptionTypes);
    }

    private static void handleMethodCalls(ClassNode cn, MethodNode mn) {
        InsnList instructions = mn.instructions;
        for (AbstractInsnNode insn : instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minsn = (MethodInsnNode)insn;
            ExceptionMapGenerator.handleDependency(minsn.owner);
        }
    }
}

