/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.GetStaticGraph;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStaticGraphGenerator {
    private static final Logger logger = LoggerFactory.getLogger(GetStaticGraphGenerator.class);
    private static final String CLINIT = "<clinit>";
    private static final String CLASS_INIT_NAME = "<clinit>" + Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);

    public static GetStaticGraph generate(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        GetStaticGraph staticUsageTree = new GetStaticGraph();
        if (targetClass != null) {
            GetStaticGraphGenerator.handle(staticUsageTree, targetClass, 0);
        }
        if (Properties.INSTRUMENT_PARENT) {
            GetStaticGraphGenerator.handleSuperClasses(staticUsageTree, targetClass);
        }
        return staticUsageTree;
    }

    private static boolean isOverridden(String methodName) {
        return true;
    }

    private static void handleSuperClasses(GetStaticGraph staticUsageTree, ClassNode targetClass) {
        String superClassName = targetClass.superName;
        if (superClassName == null || superClassName.isEmpty()) {
            return;
        }
        if (superClassName.equals("java/lang/Object")) {
            return;
        }
        logger.debug("Creating calltree for superclass: " + superClassName);
        ClassNode superClass = DependencyAnalysis.getClassNode(superClassName);
        List<MethodNode> methods = superClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            if (mn.name.equals("<init>") || mn.name.equals(CLINIT) || (mn.access & 0x400) == 1024 || (mn.access & 1) != 1 || GetStaticGraphGenerator.isOverridden(mn.name + mn.desc)) continue;
            GetStaticGraphGenerator.handleMethodNode(staticUsageTree, superClass, mn, 0);
        }
        GetStaticGraphGenerator.handleSuperClasses(staticUsageTree, superClass);
    }

    private static void handle(GetStaticGraph staticUsageTree, ClassNode targetClass, int depth) {
        List<MethodNode> methods = targetClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            GetStaticGraphGenerator.handleMethodNode(staticUsageTree, targetClass, mn, depth);
        }
    }

    private static void handle(GetStaticGraph staticUsageTree, ClassNode targetClass, String methodName, int depth) {
        List<MethodNode> methods = targetClass.methods;
        for (MethodNode mn : methods) {
            if (!methodName.equals(mn.name + mn.desc)) continue;
            GetStaticGraphGenerator.handleMethodNode(staticUsageTree, targetClass, mn, depth);
        }
    }

    private static void handle(GetStaticGraph staticUsageTree, String className, String methodName, int depth) {
        ClassNode cn = DependencyAnalysis.getClassNode(className);
        if (cn == null) {
            return;
        }
        GetStaticGraphGenerator.handle(staticUsageTree, cn, methodName, depth);
    }

    private static void handleMethodNode(GetStaticGraph staticUsageTree, ClassNode cn, MethodNode mn, int depth) {
        InsnList instructions = mn.instructions;
        for (AbstractInsnNode insn : instructions) {
            if (insn instanceof MethodInsnNode) {
                GetStaticGraphGenerator.handleMethodInsnNode(staticUsageTree, cn, mn, (MethodInsnNode)insn, depth + 1);
                continue;
            }
            if (!(insn instanceof FieldInsnNode)) continue;
            GetStaticGraphGenerator.handleFieldInsnNode(staticUsageTree, cn, mn, (FieldInsnNode)insn, depth + 1);
        }
    }

    private static void handleFieldInsnNode(GetStaticGraph staticUsageTree, ClassNode cn, MethodNode mn, FieldInsnNode insn, int depth) {
        if (insn.getOpcode() != 178) {
            return;
        }
        String calleeClassName = insn.owner.replaceAll("/", ".");
        if (BytecodeInstrumentation.checkIfCanInstrument(calleeClassName)) {
            logger.debug("Handling field read: " + insn.name);
            if (!staticUsageTree.hasStaticFieldRead(cn.name, mn.name + mn.desc, insn.owner, insn.name)) {
                GetStaticGraphGenerator.handleClassInitializer(staticUsageTree, cn, mn, insn.owner, depth);
                staticUsageTree.addStaticFieldRead(cn.name, mn.name + mn.desc, insn.owner, insn.name);
                GetStaticGraphGenerator.handle(staticUsageTree, insn.owner, insn.name + insn.desc, depth);
            }
        }
    }

    private static void handleMethodInsnNode(GetStaticGraph staticUsageTree, ClassNode cn, MethodNode mn, MethodInsnNode methodCall, int depth) {
        if (methodCall.getOpcode() != 184) {
            return;
        }
        String calleeClassName = methodCall.owner.replaceAll("/", ".");
        if (BytecodeInstrumentation.checkIfCanInstrument(calleeClassName)) {
            logger.debug("Handling method: " + methodCall.name);
            GetStaticGraphGenerator.handleClassInitializer(staticUsageTree, cn, mn, methodCall.owner, depth);
            if (!staticUsageTree.hasStaticMethodCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc)) {
                staticUsageTree.addStaticMethodCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc);
                GetStaticGraphGenerator.handle(staticUsageTree, methodCall.owner, methodCall.name + methodCall.desc, depth);
            }
        }
    }

    private static void handleClassInitializer(GetStaticGraph staticUsageTree, ClassNode cn, MethodNode mn, String owner, int depth) {
        if (!staticUsageTree.hasStaticMethodCall(cn.name, mn.name + mn.desc, owner, CLASS_INIT_NAME)) {
            staticUsageTree.addStaticMethodCall(cn.name, mn.name + mn.desc, owner, CLASS_INIT_NAME);
            GetStaticGraphGenerator.handle(staticUsageTree, owner, CLASS_INIT_NAME, depth);
        }
    }
}

