/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.annotations.EvoSuiteTest;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.graphs.GraphPool;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.utils.Java9InvisiblePackage;
import org.evosuite.utils.LoggingUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUsageChecker {
    private static final Logger logger = LoggerFactory.getLogger(TestUsageChecker.class);

    public static boolean canUse(Constructor<?> c) {
        String packageName;
        if (c.isSynthetic()) {
            return false;
        }
        if (Modifier.isAbstract(c.getDeclaringClass().getModifiers())) {
            return false;
        }
        if (c.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (c.getDeclaringClass().isAnonymousClass()) {
            return false;
        }
        if (c.getDeclaringClass().isLocalClass()) {
            logger.debug("Skipping constructor of local class " + c.getName());
            return false;
        }
        if (c.getDeclaringClass().isMemberClass() && !TestUsageChecker.canUse(c.getDeclaringClass())) {
            return false;
        }
        if (!Properties.USE_DEPRECATED && c.isAnnotationPresent(Deprecated.class)) {
            Type[] targetClass = Properties.getTargetClassAndDontInitialise();
            if (Properties.hasTargetClassBeenLoaded() && !c.getDeclaringClass().equals(targetClass)) {
                logger.debug("Excluding deprecated constructor " + c.getName());
                return false;
            }
        }
        if (TestUsageChecker.isForbiddenNonDeterministicCall(c)) {
            return false;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            TestClusterUtils.makeAccessible(c);
            return true;
        }
        for (Type paramType : c.getGenericParameterTypes()) {
            if (TestUsageChecker.canUse(paramType)) continue;
            return false;
        }
        if (!Modifier.isPrivate(c.getModifiers()) && (packageName = ClassUtils.getPackageName(c.getDeclaringClass())).equals(Properties.CLASS_PREFIX)) {
            TestClusterUtils.makeAccessible(c);
            return true;
        }
        return false;
    }

    public static boolean canUse(Type t) {
        if (t instanceof Class) {
            return TestUsageChecker.canUse((Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type parameterType : pt.getActualTypeArguments()) {
                if (TestUsageChecker.canUse(parameterType)) continue;
                return false;
            }
            if (!TestUsageChecker.canUse(pt.getOwnerType())) {
                return false;
            }
        }
        return true;
    }

    public static boolean canUse(Class<?> c) {
        String packageName;
        if (Modifier.isPrivate(c.getModifiers())) {
            return false;
        }
        if (!Properties.USE_DEPRECATED) {
            try {
                if (c.isAnnotationPresent(Deprecated.class)) {
                    Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
                    if (Properties.hasTargetClassBeenLoaded() && !c.equals(targetClass)) {
                        logger.debug("Skipping deprecated class " + c.getName());
                        return false;
                    }
                }
            }
            catch (ArrayStoreException e) {
                AtMostOnceLogger.warn(LoggingUtils.getEvoLogger(), "ArrayStoreException caught while handling class " + c.getName());
                AtMostOnceLogger.warn(LoggingUtils.getEvoLogger(), "This is likely due to a missing dependency used as annotation: https://bugs.java.com/view_bug.do?bug_id=JDK-7183985");
                return false;
            }
        }
        if (c.isAnonymousClass()) {
            return false;
        }
        if (TestUsageChecker.isClassIncludedInPackage(c.getName(), Java9InvisiblePackage.instance.getClassesToBeIgnored())) {
            return false;
        }
        if (c.getName().startsWith("junit")) {
            return false;
        }
        if (TestClusterUtils.isEvoSuiteClass(c) && !MockList.isAMockClass(c.getCanonicalName())) {
            return false;
        }
        if (c.getEnclosingClass() != null && !TestUsageChecker.canUse(c.getEnclosingClass())) {
            return false;
        }
        if (c.getDeclaringClass() != null && !TestUsageChecker.canUse(c.getDeclaringClass())) {
            return false;
        }
        if (!(c.isArray() || c.isPrimitive() || Properties.CLASS_PREFIX.isEmpty() || c.getName().contains("."))) {
            return false;
        }
        if (c.getName().contains("EnhancerByMockito")) {
            return false;
        }
        if (c.getName().contains("$MockitoMock")) {
            return false;
        }
        if (c.getName().contains("$$Lambda")) {
            return false;
        }
        if (TestClusterUtils.isAnonymousClass(c.getName())) {
            String message = c + " looks like an anonymous class, ignoring it (although reflection says " + c.isAnonymousClass() + ") " + c.getSimpleName();
            LoggingUtils.logWarnAtMostOnce(logger, message);
            return false;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            return true;
        }
        if (!Modifier.isPrivate(c.getModifiers()) && (packageName = ClassUtils.getPackageName(c)).equals(Properties.CLASS_PREFIX)) {
            return true;
        }
        logger.debug("Not public");
        return false;
    }

    public static boolean canUse(Field f) {
        return TestUsageChecker.canUse(f, f.getDeclaringClass());
    }

    public static boolean canUse(Field f, Class<?> ownerClass) {
        if (f.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (f.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (!Properties.USE_DEPRECATED && f.isAnnotationPresent(Deprecated.class)) {
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (Properties.hasTargetClassBeenLoaded() && !f.getDeclaringClass().equals(targetClass)) {
                logger.debug("Skipping deprecated field " + f.getName());
                return false;
            }
        }
        if (f.isSynthetic()) {
            logger.debug("Skipping synthetic field " + f.getName());
            return false;
        }
        if (f.getName().startsWith("ajc$")) {
            logger.debug("Skipping AspectJ field " + f.getName());
            return false;
        }
        if (!f.getType().equals(String.class) && !TestUsageChecker.canUse(f.getType())) {
            return false;
        }
        if (f.getDeclaringClass().equals(FileDescriptor.class)) {
            return false;
        }
        if (f.getName().equals("serialVersionUID")) {
            return false;
        }
        if (Modifier.isPublic(f.getModifiers())) {
            TestClusterUtils.makeAccessible(f);
            return true;
        }
        if (!Modifier.isPrivate(f.getModifiers())) {
            String packageName = ClassUtils.getPackageName(ownerClass);
            String declaredPackageName = ClassUtils.getPackageName(f.getDeclaringClass());
            if (packageName.equals(Properties.CLASS_PREFIX) && packageName.equals(declaredPackageName)) {
                TestClusterUtils.makeAccessible(f);
                return true;
            }
        }
        return false;
    }

    public static boolean canUse(Method m) {
        return TestUsageChecker.canUse(m, m.getDeclaringClass());
    }

    public static boolean canUse(Method m, Class<?> ownerClass) {
        MethodNameMatcher matcher = new MethodNameMatcher();
        String methodSignature = m.getName() + org.evosuite.shaded.org.objectweb.asm.Type.getMethodDescriptor(m);
        if (!matcher.methodMatches(methodSignature)) {
            logger.debug("Excluding method '" + methodSignature + "' that does not match criteria");
            return false;
        }
        if (m.isBridge()) {
            logger.debug("Excluding bridge method: " + m.toString());
            return false;
        }
        if (m.isSynthetic()) {
            logger.debug("Excluding synthetic method: " + m.toString());
            return false;
        }
        if (!Properties.USE_DEPRECATED && m.isAnnotationPresent(Deprecated.class)) {
            Class<?> clazz = Properties.getTargetClassAndDontInitialise();
            if (Properties.hasTargetClassBeenLoaded() && !m.getDeclaringClass().equals(clazz)) {
                logger.debug("Excluding deprecated method " + m.getName());
                return false;
            }
        }
        if (m.isAnnotationPresent(Test.class) || m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(BeforeClass.class) || m.isAnnotationPresent(After.class) || m.isAnnotationPresent(AfterClass.class)) {
            logger.debug("Excluding test method " + m.getName());
            return false;
        }
        if (m.isAnnotationPresent(EvoSuiteTest.class)) {
            logger.debug("Excluding EvoSuite test method " + m.getName());
            return false;
        }
        if (m.isAnnotationPresent(EvoSuiteExclude.class)) {
            logger.debug("Excluding method with exclusion annotation " + m.getName());
            return false;
        }
        if (m.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (m.getDeclaringClass().equals(Map.class) && Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        if (m.getDeclaringClass().equals(Set.class) && Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        if (!(m.getReturnType().equals(String.class) || TestUsageChecker.canUse(m.getReturnType()) && TestUsageChecker.canUse(m.getGenericReturnType()))) {
            return false;
        }
        for (Type paramType : m.getGenericParameterTypes()) {
            if (TestUsageChecker.canUse(paramType)) continue;
            return false;
        }
        if (m.getDeclaringClass().equals(Enum.class)) {
            return false;
        }
        if (m.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (m.getName().equals("hashCode")) {
            Class<?> clazz = Properties.getTargetClassAndDontInitialise();
            if (!m.getDeclaringClass().equals(clazz)) {
                return false;
            }
            if (GraphPool.getInstance(ownerClass.getClassLoader()).getActualCFG(Properties.TARGET_CLASS, m.getName() + org.evosuite.shaded.org.objectweb.asm.Type.getMethodDescriptor(m)) == null) {
                return false;
            }
        }
        if (m.getName().equals("deepHashCode") && m.getDeclaringClass().equals(Arrays.class)) {
            return false;
        }
        if (m.getName().equals("getAvailableLocales")) {
            return false;
        }
        if (m.getName().equals("__STATIC_RESET")) {
            logger.debug("Ignoring static reset method");
            return false;
        }
        if (TestUsageChecker.isForbiddenNonDeterministicCall(m)) {
            return false;
        }
        if (!Properties.CONSIDER_MAIN_METHODS && m.getName().equals("main") && Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())) {
            logger.debug("Ignoring static main method ");
            return false;
        }
        if (Modifier.isPublic(m.getModifiers())) {
            TestClusterUtils.makeAccessible(m);
            return true;
        }
        if (!Modifier.isPrivate(m.getModifiers())) {
            String string = ClassUtils.getPackageName(ownerClass);
            String declaredPackageName = ClassUtils.getPackageName(m.getDeclaringClass());
            if (string.equals(Properties.CLASS_PREFIX) && string.equals(declaredPackageName) && !Modifier.isAbstract(m.getModifiers())) {
                TestClusterUtils.makeAccessible(m);
                return true;
            }
        }
        return false;
    }

    private static boolean isForbiddenNonDeterministicCall(Method m) {
        if (!Properties.REPLACE_CALLS) {
            return false;
        }
        Class<?> declaringClass = m.getDeclaringClass();
        if (declaringClass.equals(Calendar.class) && m.getName().equals("getInstance")) {
            return true;
        }
        if (declaringClass.equals(Locale.class)) {
            if (m.getName().equals("getDefault")) {
                return true;
            }
            if (m.getName().equals("getAvailableLocales")) {
                return true;
            }
        }
        if (declaringClass.equals(MessageFormat.class) && m.getName().equals("getLocale")) {
            return true;
        }
        if (m.getDeclaringClass().equals(Date.class) && m.getName().equals("toLocaleString")) {
            return true;
        }
        if (m.getDeclaringClass().equals(ClassLoader.class)) {
            String name = m.getName();
            if (name.startsWith("getSystemResource")) {
                return true;
            }
            if (name.startsWith("getResource")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isForbiddenNonDeterministicCall(Constructor<?> c) {
        if (!Properties.REPLACE_CALLS) {
            return false;
        }
        if (c.getDeclaringClass().equals(Date.class) && c.getParameterTypes().length == 0) {
            return true;
        }
        return c.getDeclaringClass().equals(Random.class) && c.getParameterTypes().length == 0;
    }

    private static boolean isClassIncludedInPackage(String className, List<String> classList) {
        String result = classList.stream().filter(class1 -> className.startsWith((String)class1)).findAny().orElse(null);
        return result != null;
    }
}

