/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito;

import org.evosuite.shaded.org.mockito.ArgumentMatcher;
import org.evosuite.shaded.org.mockito.internal.matchers.ArrayEquals;
import org.evosuite.shaded.org.mockito.internal.matchers.CompareEqual;
import org.evosuite.shaded.org.mockito.internal.matchers.EqualsWithDelta;
import org.evosuite.shaded.org.mockito.internal.matchers.Find;
import org.evosuite.shaded.org.mockito.internal.matchers.GreaterOrEqual;
import org.evosuite.shaded.org.mockito.internal.matchers.GreaterThan;
import org.evosuite.shaded.org.mockito.internal.matchers.LessOrEqual;
import org.evosuite.shaded.org.mockito.internal.matchers.LessThan;
import org.evosuite.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;

public class AdditionalMatchers {
    public static <T extends Comparable<T>> T geq(T value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<T>(value));
        return null;
    }

    public static byte geq(byte value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Byte>(value));
        return 0;
    }

    public static double geq(double value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Double>(value));
        return 0.0;
    }

    public static float geq(float value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int geq(int value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Integer>(value));
        return 0;
    }

    public static long geq(long value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Long>(value));
        return 0L;
    }

    public static short geq(short value) {
        AdditionalMatchers.reportMatcher(new GreaterOrEqual<Short>(value));
        return 0;
    }

    public static <T extends Comparable<T>> T leq(T value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<T>(value));
        return null;
    }

    public static byte leq(byte value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Byte>(value));
        return 0;
    }

    public static double leq(double value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Double>(value));
        return 0.0;
    }

    public static float leq(float value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int leq(int value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Integer>(value));
        return 0;
    }

    public static long leq(long value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Long>(value));
        return 0L;
    }

    public static short leq(short value) {
        AdditionalMatchers.reportMatcher(new LessOrEqual<Short>(value));
        return 0;
    }

    public static <T extends Comparable<T>> T gt(T value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<T>(value));
        return null;
    }

    public static byte gt(byte value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Byte>(value));
        return 0;
    }

    public static double gt(double value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Double>(value));
        return 0.0;
    }

    public static float gt(float value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int gt(int value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Integer>(value));
        return 0;
    }

    public static long gt(long value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Long>(value));
        return 0L;
    }

    public static short gt(short value) {
        AdditionalMatchers.reportMatcher(new GreaterThan<Short>(value));
        return 0;
    }

    public static <T extends Comparable<T>> T lt(T value) {
        AdditionalMatchers.reportMatcher(new LessThan<T>(value));
        return null;
    }

    public static byte lt(byte value) {
        AdditionalMatchers.reportMatcher(new LessThan<Byte>(value));
        return 0;
    }

    public static double lt(double value) {
        AdditionalMatchers.reportMatcher(new LessThan<Double>(value));
        return 0.0;
    }

    public static float lt(float value) {
        AdditionalMatchers.reportMatcher(new LessThan<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int lt(int value) {
        AdditionalMatchers.reportMatcher(new LessThan<Integer>(value));
        return 0;
    }

    public static long lt(long value) {
        AdditionalMatchers.reportMatcher(new LessThan<Long>(value));
        return 0L;
    }

    public static short lt(short value) {
        AdditionalMatchers.reportMatcher(new LessThan<Short>(value));
        return 0;
    }

    public static <T extends Comparable<T>> T cmpEq(T value) {
        AdditionalMatchers.reportMatcher(new CompareEqual<T>(value));
        return null;
    }

    public static String find(String regex) {
        AdditionalMatchers.reportMatcher(new Find(regex));
        return null;
    }

    public static <T> T[] aryEq(T[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static short[] aryEq(short[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static long[] aryEq(long[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static int[] aryEq(int[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static float[] aryEq(float[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static double[] aryEq(double[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static char[] aryEq(char[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static byte[] aryEq(byte[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static boolean[] aryEq(boolean[] value) {
        AdditionalMatchers.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static boolean and(boolean first, boolean second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return false;
    }

    public static byte and(byte first, byte second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0;
    }

    public static char and(char first, char second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return '\u0000';
    }

    public static double and(double first, double second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0.0;
    }

    public static float and(float first, float second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0.0f;
    }

    public static int and(int first, int second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0;
    }

    public static long and(long first, long second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0L;
    }

    public static short and(short first, short second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return 0;
    }

    public static <T> T and(T first, T second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportAnd();
        return null;
    }

    public static boolean or(boolean first, boolean second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return false;
    }

    public static <T> T or(T first, T second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return null;
    }

    public static short or(short first, short second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0;
    }

    public static long or(long first, long second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0L;
    }

    public static int or(int first, int second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0;
    }

    public static float or(float first, float second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0.0f;
    }

    public static double or(double first, double second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0.0;
    }

    public static char or(char first, char second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return '\u0000';
    }

    public static byte or(byte first, byte second) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportOr();
        return 0;
    }

    public static <T> T not(T first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return null;
    }

    public static short not(short first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0;
    }

    public static int not(int first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0;
    }

    public static long not(long first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0L;
    }

    public static float not(float first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0.0f;
    }

    public static double not(double first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0.0;
    }

    public static char not(char first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return '\u0000';
    }

    public static boolean not(boolean first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return false;
    }

    public static byte not(byte first) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportNot();
        return 0;
    }

    public static double eq(double value, double delta) {
        AdditionalMatchers.reportMatcher(new EqualsWithDelta(value, delta));
        return 0.0;
    }

    public static float eq(float value, float delta) {
        AdditionalMatchers.reportMatcher(new EqualsWithDelta(Float.valueOf(value), Float.valueOf(delta)));
        return 0.0f;
    }

    private static void reportMatcher(ArgumentMatcher<?> matcher) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportMatcher(matcher);
    }
}

