/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.internal.util.MockUtil;
import org.evosuite.shaded.org.mockito.internal.util.reflection.FieldInitializationReport;
import org.evosuite.shaded.org.mockito.internal.util.reflection.FieldReader;
import org.evosuite.shaded.org.mockito.plugins.MemberAccessor;

public class FieldInitializer {
    private final Object fieldOwner;
    private final Field field;
    private final ConstructorInstantiator instantiator;

    public FieldInitializer(Object fieldOwner, Field field) {
        this(fieldOwner, field, new NoArgConstructorInstantiator(fieldOwner, field));
    }

    public FieldInitializer(Object fieldOwner, Field field, ConstructorArgumentResolver argResolver) {
        this(fieldOwner, field, new ParameterizedConstructorInstantiator(fieldOwner, field, argResolver));
    }

    private FieldInitializer(Object fieldOwner, Field field, ConstructorInstantiator instantiator) {
        if (new FieldReader(fieldOwner, field).isNull()) {
            this.checkNotLocal(field);
            this.checkNotInner(field);
            this.checkNotInterface(field);
            this.checkNotEnum(field);
            this.checkNotAbstract(field);
        }
        this.fieldOwner = fieldOwner;
        this.field = field;
        this.instantiator = instantiator;
    }

    public FieldInitializationReport initialize() {
        try {
            return this.acquireFieldInstance();
        }
        catch (IllegalAccessException e) {
            throw new MockitoException("Problems initializing field '" + this.field.getName() + "' of type '" + this.field.getType().getSimpleName() + "'", e);
        }
    }

    private void checkNotLocal(Field field) {
        if (field.getType().isLocalClass()) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is a local class.");
        }
    }

    private void checkNotInner(Field field) {
        Class<?> type = field.getType();
        if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new MockitoException("the type '" + type.getSimpleName() + "' is an inner non static class.");
        }
    }

    private void checkNotInterface(Field field) {
        if (field.getType().isInterface()) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is an interface.");
        }
    }

    private void checkNotAbstract(Field field) {
        if (Modifier.isAbstract(field.getType().getModifiers())) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is an abstract class.");
        }
    }

    private void checkNotEnum(Field field) {
        if (field.getType().isEnum()) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is an enum.");
        }
    }

    private FieldInitializationReport acquireFieldInstance() throws IllegalAccessException {
        MemberAccessor accessor = Plugins.getMemberAccessor();
        Object fieldInstance = accessor.get(this.field, this.fieldOwner);
        if (fieldInstance != null) {
            return new FieldInitializationReport(fieldInstance, false, false);
        }
        return this.instantiator.instantiate();
    }

    static class ParameterizedConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;
        private final ConstructorArgumentResolver argResolver;
        private final Comparator<Constructor<?>> byParameterNumber = new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> constructorA, Constructor<?> constructorB) {
                int argLengths = constructorB.getParameterTypes().length - constructorA.getParameterTypes().length;
                if (argLengths == 0) {
                    int constructorAMockableParamsSize = this.countMockableParams(constructorA);
                    int constructorBMockableParamsSize = this.countMockableParams(constructorB);
                    return constructorBMockableParamsSize - constructorAMockableParamsSize;
                }
                return argLengths;
            }

            private int countMockableParams(Constructor<?> constructor) {
                int constructorMockableParamsSize = 0;
                for (Class<?> aClass : constructor.getParameterTypes()) {
                    if (!MockUtil.typeMockabilityOf(aClass).mockable()) continue;
                    ++constructorMockableParamsSize;
                }
                return constructorMockableParamsSize;
            }
        };

        ParameterizedConstructorInstantiator(Object testClass, Field field, ConstructorArgumentResolver argumentResolver) {
            this.testClass = testClass;
            this.field = field;
            this.argResolver = argumentResolver;
        }

        @Override
        public FieldInitializationReport instantiate() {
            MemberAccessor accessor = Plugins.getMemberAccessor();
            Constructor<?> constructor = this.biggestConstructor(this.field.getType());
            Object[] args = this.argResolver.resolveTypeInstances(constructor.getParameterTypes());
            try {
                Object newFieldInstance = accessor.newInstance(constructor, args);
                accessor.set(this.field, this.testClass, newFieldInstance);
                return new FieldInitializationReport(accessor.get(this.field, this.testClass), false, true);
            }
            catch (IllegalArgumentException e) {
                throw new MockitoException("internal error : argResolver provided incorrect types for constructor " + constructor + " of type " + this.field.getType().getSimpleName(), e);
            }
            catch (InvocationTargetException e) {
                throw new MockitoException("the constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + e.getTargetException().toString(), e);
            }
            catch (InstantiationException e) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + e.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + e.toString(), e);
            }
        }

        private void checkParameterized(Constructor<?> constructor, Field field) {
            if (constructor.getParameterTypes().length == 0) {
                throw new MockitoException("the field " + field.getName() + " of type " + field.getType() + " has no parameterized constructor");
            }
        }

        private Constructor<?> biggestConstructor(Class<?> clazz) {
            List<Constructor<?>> constructors = Arrays.asList(clazz.getDeclaredConstructors());
            Collections.sort(constructors, this.byParameterNumber);
            Constructor<?> constructor = constructors.get(0);
            this.checkParameterized(constructor, this.field);
            return constructor;
        }
    }

    static class NoArgConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;

        NoArgConstructorInstantiator(Object testClass, Field field) {
            this.testClass = testClass;
            this.field = field;
        }

        @Override
        public FieldInitializationReport instantiate() {
            MemberAccessor invoker = Plugins.getMemberAccessor();
            try {
                Constructor<?> constructor = this.field.getType().getDeclaredConstructor(new Class[0]);
                Object[] noArg = new Object[]{};
                Object newFieldInstance = invoker.newInstance(constructor, noArg);
                invoker.set(this.field, this.testClass, newFieldInstance);
                return new FieldInitializationReport(invoker.get(this.field, this.testClass), true, false);
            }
            catch (NoSuchMethodException e) {
                throw new MockitoException("the type '" + this.field.getType().getSimpleName() + "' has no default constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new MockitoException("the default constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + e.getTargetException().toString(), e);
            }
            catch (InstantiationException e) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + e.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + e.toString(), e);
            }
        }
    }

    private static interface ConstructorInstantiator {
        public FieldInitializationReport instantiate();
    }

    public static interface ConstructorArgumentResolver {
        public Object[] resolveTypeInstances(Class<?> ... var1);
    }
}

