/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.execution.UncompilableCodeException;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedNumRandomTestStrategy
extends TestGenerationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(FixedNumRandomTestStrategy.class);

    @Override
    public TestSuiteChromosome generateTests() {
        LoggingUtils.getEvoLogger().info("* Generating fixed number of random tests");
        ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
        RandomLengthTestFactory factory = new RandomLengthTestFactory();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        if (!this.canGenerateTestsForSUT()) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, 0);
            return suite;
        }
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = FixedNumRandomTestStrategy.getFitnessFactories();
        ArrayList<? extends TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
            goals.addAll(goalFactory.getCoverageGoals());
            LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        for (int i = 0; i < Properties.NUM_RANDOM_TESTS; ++i) {
            logger.info("Current test: " + i + "/" + Properties.NUM_RANDOM_TESTS);
            TestChromosome test = factory.getChromosome();
            ExecutionResult result = TestCaseExecutor.runTest(test.getTestCase());
            Integer pos = result.getFirstPositionOfThrownException();
            if (pos != null) {
                if (result.getExceptionThrownAtPosition(pos) instanceof CodeUnderTestException || result.getExceptionThrownAtPosition(pos) instanceof UncompilableCodeException || result.getExceptionThrownAtPosition(pos) instanceof TestCaseExecutor.TimeoutExceeded) continue;
                test.getTestCase().chop(pos + 1);
                test.setChanged(true);
            } else {
                test.setLastExecutionResult(result);
            }
            suite.addTest(test);
        }
        for (TestSuiteFitnessFunction fitnessFunction : this.getFitnessFunctions()) {
            fitnessFunction.getFitness(suite);
        }
        this.sendExecutionStatistics();
        return suite;
    }
}

