/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import org.evosuite.Properties;
import org.evosuite.ShutdownTestWriter;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.archive.ArchiveTestChromosomeFactory;
import org.evosuite.ga.metaheuristics.NoveltySearch;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointFixedCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointRelativeCrossOver;
import org.evosuite.ga.operators.ranking.FastNonDominatedSorting;
import org.evosuite.ga.operators.ranking.RankBasedPreferenceSorting;
import org.evosuite.ga.operators.ranking.RankingFunction;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.FitnessProportionateSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.operators.selection.TournamentSelection;
import org.evosuite.ga.operators.selection.TournamentSelectionRankAndCrowdingDistanceComparator;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.RMIStoppingCondition;
import org.evosuite.ga.stoppingconditions.SocketStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.statistics.StatisticsListener;
import org.evosuite.strategy.PropertiesSearchAlgorithmFactory;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.factories.AllMethodsTestChromosomeFactory;
import org.evosuite.testcase.factories.JUnitTestCarvedChromosomeFactory;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testcase.secondaryobjectives.TestCaseSecondaryObjective;
import org.evosuite.testsuite.RelativeSuiteLengthBloatControl;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.ResourceController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class PropertiesNoveltySearchFactory
extends PropertiesSearchAlgorithmFactory<TestChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesNoveltySearchFactory.class);

    private ChromosomeFactory<TestChromosome> getChromosomeFactory() {
        switch (Properties.TEST_FACTORY) {
            case ALLMETHODS: {
                logger.info("Using all methods chromosome factory");
                return new AllMethodsTestChromosomeFactory();
            }
            case RANDOM: {
                logger.info("Using random chromosome factory");
                return new RandomLengthTestFactory();
            }
            case ARCHIVE: {
                logger.info("Using archive chromosome factory");
                return new ArchiveTestChromosomeFactory();
            }
            case JUNIT: {
                logger.info("Using seeding chromosome factory");
                return new JUnitTestCarvedChromosomeFactory(new RandomLengthTestFactory());
            }
            case SERIALIZATION: {
                logger.info("Using serialization seeding chromosome factory");
                return new RandomLengthTestFactory();
            }
        }
        throw new RuntimeException("Unsupported test factory: " + (Object)((Object)Properties.TEST_FACTORY));
    }

    protected SelectionFunction<TestChromosome> getSelectionFunction() {
        switch (Properties.SELECTION_FUNCTION) {
            case ROULETTEWHEEL: {
                return new FitnessProportionateSelection<TestChromosome>();
            }
            case TOURNAMENT: {
                return new TournamentSelection<TestChromosome>();
            }
            case BINARY_TOURNAMENT: {
                return new BinaryTournamentSelectionCrowdedComparison<TestChromosome>();
            }
            case RANK_CROWD_DISTANCE_TOURNAMENT: {
                return new TournamentSelectionRankAndCrowdingDistanceComparator<TestChromosome>();
            }
        }
        return new RankSelection<TestChromosome>();
    }

    protected CrossOverFunction<TestChromosome> getCrossoverFunction() {
        switch (Properties.CROSSOVER_FUNCTION) {
            case SINGLEPOINTFIXED: {
                return new SinglePointFixedCrossOver<TestChromosome>();
            }
            case SINGLEPOINTRELATIVE: {
                return new SinglePointRelativeCrossOver<TestChromosome>();
            }
            case SINGLEPOINT: {
                return new SinglePointCrossOver<TestChromosome>();
            }
            case COVERAGE: {
                throw new RuntimeException("Coverage crossover not supported in test case mode");
            }
        }
        throw new RuntimeException("Unknown crossover function: " + (Object)((Object)Properties.CROSSOVER_FUNCTION));
    }

    private RankingFunction<TestChromosome> getRankingFunction() {
        switch (Properties.RANKING_TYPE) {
            case FAST_NON_DOMINATED_SORTING: {
                return new FastNonDominatedSorting<TestChromosome>();
            }
        }
        return new RankBasedPreferenceSorting<TestChromosome>();
    }

    public NoveltySearch getSearchAlgorithm() {
        ChromosomeFactory<TestChromosome> factory = this.getChromosomeFactory();
        NoveltySearch ga = new NoveltySearch(factory);
        if (Properties.NEW_STATISTICS) {
            ga.addListener(new StatisticsListener());
        }
        SelectionFunction<TestChromosome> selectionFunction = this.getSelectionFunction();
        selectionFunction.setMaximize(false);
        ga.setSelectionFunction(selectionFunction);
        RankingFunction<TestChromosome> ranking_function = this.getRankingFunction();
        ga.setRankingFunction(ranking_function);
        StoppingCondition stopping_condition = this.getStoppingCondition();
        ga.setStoppingCondition(stopping_condition);
        if (Properties.STOP_ZERO) {
            ga.addStoppingCondition(new ZeroFitnessStoppingCondition());
        }
        if (!(stopping_condition instanceof MaxTimeStoppingCondition)) {
            ga.addStoppingCondition(new GlobalTimeStoppingCondition());
        }
        if ((ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) && Properties.STRATEGY == Properties.Strategy.ONEBRANCH) {
            ga.addStoppingCondition(new MutationTimeoutStoppingCondition());
        }
        ga.resetStoppingConditions();
        ga.setPopulationLimit(this.getPopulationLimit());
        CrossOverFunction<TestChromosome> crossover_function = this.getCrossoverFunction();
        ga.setCrossOverFunction(crossover_function);
        if (Properties.CHECK_BEST_LENGTH) {
            RelativeSuiteLengthBloatControl bloat_control = new RelativeSuiteLengthBloatControl();
            ga.addBloatControl(bloat_control);
            ga.addListener(bloat_control);
        }
        TestCaseSecondaryObjective.setSecondaryObjectives();
        if (Properties.DYNAMIC_LIMIT) {
            stopping_condition.setLimit(Properties.SEARCH_BUDGET *= (long)(BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getNumBranchlessMethods(Properties.TARGET_CLASS) + BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCountForClass(Properties.TARGET_CLASS) * 2));
            logger.info("Setting dynamic length limit to " + Properties.SEARCH_BUDGET);
        }
        if (Properties.LOCAL_SEARCH_RESTORE_COVERAGE) {
            // empty if block
        }
        if (Properties.SHUTDOWN_HOOK) {
            ShutdownTestWriter writer = new ShutdownTestWriter();
            ga.addStoppingCondition(writer);
            RMIStoppingCondition rmi = RMIStoppingCondition.getInstance();
            ga.addStoppingCondition(rmi);
            if (Properties.STOPPING_PORT != -1) {
                SocketStoppingCondition ss = SocketStoppingCondition.getInstance();
                ss.accept();
                ga.addStoppingCondition(ss);
            }
            Signal.handle(new Signal("INT"), writer);
        }
        ga.addListener(new ResourceController());
        return ga;
    }
}

