/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessReplacementFunction;
import org.evosuite.ga.metaheuristics.BreederGA;
import org.evosuite.ga.metaheuristics.CellularGA;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.LIPS;
import org.evosuite.ga.metaheuristics.MonotonicGA;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.metaheuristics.RandomSearch;
import org.evosuite.ga.metaheuristics.SPEA2;
import org.evosuite.ga.metaheuristics.StandardChemicalReaction;
import org.evosuite.ga.metaheuristics.StandardGA;
import org.evosuite.ga.metaheuristics.SteadyStateGA;
import org.evosuite.ga.metaheuristics.mapelites.MAPElites;
import org.evosuite.ga.metaheuristics.mulambda.MuLambdaEA;
import org.evosuite.ga.metaheuristics.mulambda.MuPlusLambdaEA;
import org.evosuite.ga.metaheuristics.mulambda.OnePlusLambdaLambdaGA;
import org.evosuite.ga.metaheuristics.mulambda.OnePlusOneEA;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointFixedCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointRelativeCrossOver;
import org.evosuite.ga.operators.crossover.UniformCrossOver;
import org.evosuite.ga.operators.ranking.FastNonDominatedSorting;
import org.evosuite.ga.operators.ranking.RankBasedPreferenceSorting;
import org.evosuite.ga.operators.ranking.RankingFunction;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.FitnessProportionateSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.operators.selection.TournamentSelection;
import org.evosuite.ga.operators.selection.TournamentSelectionRankAndCrowdingDistanceComparator;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.seeding.TestCaseRecycler;
import org.evosuite.statistics.StatisticsListener;
import org.evosuite.strategy.PropertiesSearchAlgorithmFactory;
import org.evosuite.testcase.RelativeTestLengthBloatControl;
import org.evosuite.testcase.TestCaseReplacementFunction;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.factories.AllMethodsTestChromosomeFactory;
import org.evosuite.testcase.factories.JUnitTestCarvedChromosomeFactory;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testcase.secondaryobjectives.TestCaseSecondaryObjective;
import org.evosuite.utils.ArrayUtil;

public class PropertiesTestGAFactory
extends PropertiesSearchAlgorithmFactory<TestChromosome> {
    protected ChromosomeFactory<TestChromosome> getChromosomeFactory() {
        switch (Properties.STRATEGY) {
            case ONEBRANCH: {
                switch (Properties.TEST_FACTORY) {
                    case ALLMETHODS: {
                        logger.info("Using all methods chromosome factory");
                        return new AllMethodsTestChromosomeFactory();
                    }
                    case RANDOM: {
                        logger.info("Using random chromosome factory");
                        return new RandomLengthTestFactory();
                    }
                    case JUNIT: {
                        logger.info("Using seeding chromosome factory");
                        return new JUnitTestCarvedChromosomeFactory(new RandomLengthTestFactory());
                    }
                }
            }
            case ENTBUG: {
                return new RandomLengthTestFactory();
            }
        }
        throw new RuntimeException("Unsupported test factory: " + (Object)((Object)Properties.TEST_FACTORY));
    }

    private GeneticAlgorithm<TestChromosome> getGeneticAlgorithm(ChromosomeFactory<TestChromosome> factory) {
        switch (Properties.ALGORITHM) {
            case ONE_PLUS_ONE_EA: {
                logger.info("Chosen search algorithm: (1+1)EA");
                return new OnePlusOneEA<TestChromosome>(factory);
            }
            case MU_PLUS_LAMBDA_EA: {
                logger.info("Chosen search algorithm: (Mu+Lambda)EA");
                return new MuPlusLambdaEA<TestChromosome>(factory, Properties.MU, Properties.LAMBDA);
            }
            case MU_LAMBDA_EA: {
                logger.info("Chosen search algorithm: (Mu,Lambda)EA");
                return new MuLambdaEA<TestChromosome>(factory, Properties.MU, Properties.LAMBDA);
            }
            case BREEDER_GA: {
                logger.info("Chosen search algorithm: BreederGA");
                return new BreederGA<TestChromosome>(factory);
            }
            case MONOTONIC_GA: {
                logger.info("Chosen search algorithm: MonotonicGA");
                MonotonicGA<TestChromosome> ga = new MonotonicGA<TestChromosome>(factory);
                if (Properties.REPLACEMENT_FUNCTION == Properties.TheReplacementFunction.FITNESSREPLACEMENT) {
                    ga.setReplacementFunction(new FitnessReplacementFunction());
                } else {
                    ga.setReplacementFunction(new TestCaseReplacementFunction());
                }
                return ga;
            }
            case CELLULAR_GA: {
                logger.info("Chosen search algorithm: CellularGA");
                CellularGA<TestChromosome> ga = new CellularGA<TestChromosome>(Properties.MODEL, factory);
                if (Properties.REPLACEMENT_FUNCTION == Properties.TheReplacementFunction.FITNESSREPLACEMENT) {
                    ga.setReplacementFunction(new FitnessReplacementFunction());
                } else {
                    ga.setReplacementFunction(new TestCaseReplacementFunction());
                }
                return ga;
            }
            case STEADY_STATE_GA: {
                logger.info("Chosen search algorithm: Steady-StateGA");
                SteadyStateGA<TestChromosome> ga = new SteadyStateGA<TestChromosome>(factory);
                if (Properties.REPLACEMENT_FUNCTION == Properties.TheReplacementFunction.FITNESSREPLACEMENT) {
                    ga.setReplacementFunction(new FitnessReplacementFunction());
                } else {
                    ga.setReplacementFunction(new TestCaseReplacementFunction());
                }
                return ga;
            }
            case RANDOM_SEARCH: {
                logger.info("Chosen search algorithm: Random");
                return new RandomSearch<TestChromosome>(factory);
            }
            case NSGAII: {
                logger.info("Chosen search algorithm: NSGAII");
                return new NSGAII<TestChromosome>(factory);
            }
            case SPEA2: {
                logger.info("Chosen search algorithm: SPEA2");
                return new SPEA2<TestChromosome>(factory);
            }
            case ONE_PLUS_LAMBDA_LAMBDA_GA: {
                logger.info("Chosen search algorithm: 1 + (lambda, lambda)GA");
                return new OnePlusLambdaLambdaGA<TestChromosome>(factory, Properties.LAMBDA);
            }
            case STANDARD_CHEMICAL_REACTION: {
                logger.info("Chosen search algorithm: Standard Chemical Reaction Optimization");
                return new StandardChemicalReaction<TestChromosome>(factory);
            }
            case MAP_ELITES: {
                logger.info("Chosen search algorithm: MAP-Elites");
                return new MAPElites(factory);
            }
            case LIPS: {
                logger.info("Chosen search algorithm: LIPS");
                return new LIPS(factory);
            }
        }
        logger.info("Chosen search algorithm: StandardGA");
        return new StandardGA<TestChromosome>(factory);
    }

    private SelectionFunction<TestChromosome> getSelectionFunction() {
        switch (Properties.SELECTION_FUNCTION) {
            case ROULETTEWHEEL: {
                return new FitnessProportionateSelection<TestChromosome>();
            }
            case TOURNAMENT: {
                return new TournamentSelection<TestChromosome>();
            }
            case BINARY_TOURNAMENT: {
                return new BinaryTournamentSelectionCrowdedComparison<TestChromosome>();
            }
            case RANK_CROWD_DISTANCE_TOURNAMENT: {
                return new TournamentSelectionRankAndCrowdingDistanceComparator<TestChromosome>();
            }
        }
        return new RankSelection<TestChromosome>();
    }

    private CrossOverFunction<TestChromosome> getCrossoverFunction() {
        switch (Properties.CROSSOVER_FUNCTION) {
            case SINGLEPOINTFIXED: {
                return new SinglePointFixedCrossOver<TestChromosome>();
            }
            case SINGLEPOINTRELATIVE: {
                return new SinglePointRelativeCrossOver<TestChromosome>();
            }
            case SINGLEPOINT: {
                return new SinglePointCrossOver<TestChromosome>();
            }
            case UNIFORM: {
                return new UniformCrossOver<TestChromosome>();
            }
        }
        throw new RuntimeException("Unknown crossover function: " + (Object)((Object)Properties.CROSSOVER_FUNCTION));
    }

    private RankingFunction<TestChromosome> getRankingFunction() {
        switch (Properties.RANKING_TYPE) {
            case FAST_NON_DOMINATED_SORTING: {
                return new FastNonDominatedSorting<TestChromosome>();
            }
        }
        return new RankBasedPreferenceSorting<TestChromosome>();
    }

    @Override
    public GeneticAlgorithm<TestChromosome> getSearchAlgorithm() {
        ChromosomeFactory<TestChromosome> factory = this.getChromosomeFactory();
        GeneticAlgorithm<TestChromosome> ga = this.getGeneticAlgorithm(factory);
        if (Properties.NEW_STATISTICS) {
            ga.addListener(new StatisticsListener());
        }
        SelectionFunction<TestChromosome> selection_function = this.getSelectionFunction();
        selection_function.setMaximize(false);
        ga.setSelectionFunction(selection_function);
        RankingFunction<TestChromosome> ranking_function = this.getRankingFunction();
        ga.setRankingFunction(ranking_function);
        StoppingCondition stopping_condition = this.getStoppingCondition();
        ga.setStoppingCondition(stopping_condition);
        if (Properties.STOP_ZERO) {
            ga.addStoppingCondition(new ZeroFitnessStoppingCondition());
        }
        if (!(stopping_condition instanceof MaxTimeStoppingCondition)) {
            ga.addStoppingCondition(new GlobalTimeStoppingCondition());
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            ga.addStoppingCondition(new MutationTimeoutStoppingCondition());
        }
        ga.resetStoppingConditions();
        ga.setPopulationLimit(this.getPopulationLimit());
        CrossOverFunction<TestChromosome> crossover_function = this.getCrossoverFunction();
        ga.setCrossOverFunction(crossover_function);
        if (Properties.CHECK_BEST_LENGTH) {
            RelativeTestLengthBloatControl bloat_control = new RelativeTestLengthBloatControl();
            ga.addBloatControl(bloat_control);
            ga.addListener(bloat_control);
        }
        TestCaseSecondaryObjective.setSecondaryObjectives();
        if (Properties.DYNAMIC_LIMIT) {
            stopping_condition.setLimit(Properties.SEARCH_BUDGET *= (long)(BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getNumBranchlessMethods(Properties.TARGET_CLASS) + BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCountForClass(Properties.TARGET_CLASS) * 2));
            logger.info("Setting dynamic length limit to " + Properties.SEARCH_BUDGET);
        }
        if (Properties.RECYCLE_CHROMOSOMES && Properties.STRATEGY == Properties.Strategy.ONEBRANCH) {
            ga.addListener(TestCaseRecycler.getInstance());
        }
        return ga;
    }
}

