/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.MethodComparator;
import org.evosuite.symbolic.PathCondition;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.vm.ConstraintFactory;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.localsearch.DSETestGenerator;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSEAlgorithm
extends GeneticAlgorithm<TestSuiteChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(DSEAlgorithm.class);
    private final Map<Set<Constraint<?>>, SolverResult> queryCache = new HashMap();
    private static final long serialVersionUID = 964984026539409121L;

    private void generateTestCasesAndAppendToBestIndividual(Method staticEntryMethod) {
        double fitnessBeforeAddingDefaultTest = ((TestSuiteChromosome)this.getBestIndividual()).getFitness();
        logger.debug("Fitness before adding default test case:" + fitnessBeforeAddingDefaultTest);
        ArrayList<TestCase> generatedTests = new ArrayList<TestCase>();
        DefaultTestCase testCaseWithDefaultValues = DSEAlgorithm.buildTestCaseWithDefaultValues(staticEntryMethod);
        ((TestSuiteChromosome)this.getBestIndividual()).addTest(testCaseWithDefaultValues);
        generatedTests.add(testCaseWithDefaultValues);
        logger.debug("Created new default test case with default values:" + testCaseWithDefaultValues.toCode());
        this.calculateFitnessAndSortPopulation();
        double fitnessAfterAddingDefaultTest = ((TestSuiteChromosome)this.getBestIndividual()).getFitness();
        logger.debug("Fitness after adding default test case: " + fitnessAfterAddingDefaultTest);
        if (fitnessAfterAddingDefaultTest == 0.0) {
            logger.debug("No more DSE test generation since fitness is 0");
            return;
        }
        HashSet pathConditions = new HashSet();
        for (int currentTestIndex = 0; currentTestIndex < generatedTests.size(); ++currentTestIndex) {
            TestCase currentTestCase = (TestCase)generatedTests.get(currentTestIndex);
            if (this.isFinished()) {
                logger.debug("DSE test generation met a stopping condition. Exiting with " + generatedTests.size() + " generated test cases for method " + staticEntryMethod.getName());
                return;
            }
            logger.debug("Starting concolic execution of test case: " + currentTestCase.toCode());
            TestCase clonedTestCase = currentTestCase.clone();
            PathCondition pathCondition = ConcolicExecution.executeConcolic((DefaultTestCase)clonedTestCase);
            logger.debug("Path condition collected with : " + pathCondition.size() + " branches");
            HashSet<Constraint<?>> constraintsSet = DSEAlgorithm.canonicalize(pathCondition.getConstraints());
            pathConditions.add(constraintsSet);
            logger.debug("Number of stored path condition: " + pathConditions.size());
            for (int i = pathCondition.size() - 1; i >= 0; --i) {
                logger.debug("negating index " + i + " of path condition");
                List<Constraint<?>> query = DSETestGenerator.buildQuery(pathCondition, i);
                HashSet<Constraint<?>> constraintSet = DSEAlgorithm.canonicalize(query);
                if (this.queryCache.containsKey(constraintSet)) {
                    logger.debug("skipping solving of current query since it is in the query cache");
                    continue;
                }
                if (DSEAlgorithm.isSubSetOf(constraintSet, this.queryCache.keySet())) {
                    logger.debug("skipping solving of current query because it is satisfiable and solved by previous path condition");
                    continue;
                }
                if (pathConditions.contains(constraintSet)) {
                    logger.debug("skipping solving of current query because of existing path condition");
                    continue;
                }
                if (DSEAlgorithm.isSubSetOf(constraintSet, pathConditions)) {
                    logger.debug("skipping solving of current query because it is satisfiable and solved by previous path condition");
                    continue;
                }
                if (this.isFinished()) {
                    logger.debug("DSE test generation met a stopping condition. Exiting with " + generatedTests.size() + " generated test cases for method " + staticEntryMethod.getName());
                    return;
                }
                logger.debug("Solving query with  " + query.size() + " constraints");
                List<Constraint<?>> varBounds = DSEAlgorithm.createVarBounds(query);
                query.addAll(varBounds);
                SolverResult result = DSETestGenerator.solve(query);
                this.queryCache.put(constraintSet, result);
                logger.debug("Number of stored entries in query cache : " + this.queryCache.keySet().size());
                if (result == null) {
                    logger.debug("Solver outcome is null (probably failure/unknown");
                    continue;
                }
                if (result.isSAT()) {
                    logger.debug("query is SAT (solution found)");
                    Map<String, Object> solution = result.getModel();
                    logger.debug("solver found solution " + solution.toString());
                    TestCase newTest = DSETestGenerator.updateTest(currentTestCase, solution);
                    logger.debug("Created new test case from SAT solution:" + newTest.toCode());
                    generatedTests.add(newTest);
                    double fitnessBeforeAddingNewTest = ((TestSuiteChromosome)this.getBestIndividual()).getFitness();
                    logger.debug("Fitness before adding new test" + fitnessBeforeAddingNewTest);
                    ((TestSuiteChromosome)this.getBestIndividual()).addTest(newTest);
                    this.calculateFitness(this.getBestIndividual());
                    double fitnessAfterAddingNewTest = ((TestSuiteChromosome)this.getBestIndividual()).getFitness();
                    logger.debug("Fitness after adding new test " + fitnessAfterAddingNewTest);
                    this.notifyIteration();
                    if (fitnessAfterAddingNewTest != 0.0) continue;
                    logger.debug("No more DSE test generation since fitness is 0");
                    return;
                }
                assert (result.isUNSAT());
                logger.debug("query is UNSAT (no solution found)");
            }
        }
        logger.debug("DSE test generation finished for method " + staticEntryMethod.getName() + ". Exiting with " + generatedTests.size() + " generated test cases");
    }

    protected static HashSet<Constraint<?>> canonicalize(List<Constraint<?>> query) {
        return new HashSet(query);
    }

    private static List<Constraint<?>> createVarBounds(List<Constraint<?>> query) {
        HashSet variables = new HashSet();
        for (Constraint<?> constraint : query) {
            variables.addAll(constraint.getVariables());
        }
        ArrayList boundsForVariables = new ArrayList();
        for (Variable variable : variables) {
            if (variable instanceof IntegerVariable) {
                IntegerVariable integerVariable = (IntegerVariable)variable;
                Long minValue = integerVariable.getMinValue();
                Long maxValue = integerVariable.getMaxValue();
                if (maxValue == Long.MAX_VALUE && minValue == Long.MIN_VALUE) continue;
                IntegerConstant minValueExpr = ExpressionFactory.buildNewIntegerConstant(minValue);
                IntegerConstant maxValueExpr = ExpressionFactory.buildNewIntegerConstant(maxValue);
                IntegerConstraint minValueConstraint = ConstraintFactory.gte(integerVariable, minValueExpr);
                IntegerConstraint maxValueConstraint = ConstraintFactory.lte(integerVariable, maxValueExpr);
                boundsForVariables.add(minValueConstraint);
                boundsForVariables.add(maxValueConstraint);
                continue;
            }
            if (variable instanceof RealVariable || variable instanceof StringVariable) continue;
            throw new UnsupportedOperationException("Unknown variable type " + variable.getClass().getName());
        }
        return boundsForVariables;
    }

    private static boolean isSubSetOf(Set<Constraint<?>> query, Collection<Set<Constraint<?>>> queries) {
        for (Set<Constraint<Constraint<?>>> set : queries) {
            if (!set.containsAll(query)) continue;
            return true;
        }
        return false;
    }

    private static DefaultTestCase buildTestCaseWithDefaultValues(Method targetStaticMethod) {
        TestCaseBuilder testCaseBuilder = new TestCaseBuilder();
        Type[] argumentTypes = Type.getArgumentTypes(targetStaticMethod);
        Class<?>[] argumentClasses = targetStaticMethod.getParameterTypes();
        ArrayList<VariableReference> arguments = new ArrayList<VariableReference>();
        block12: for (int i = 0; i < argumentTypes.length; ++i) {
            Type argumentType = argumentTypes[i];
            Class<?> argumentClass = argumentClasses[i];
            switch (argumentType.getSort()) {
                case 1: {
                    VariableReference booleanVariable = testCaseBuilder.appendBooleanPrimitive(false);
                    arguments.add(booleanVariable);
                    continue block12;
                }
                case 3: {
                    VariableReference byteVariable = testCaseBuilder.appendBytePrimitive((byte)0);
                    arguments.add(byteVariable);
                    continue block12;
                }
                case 2: {
                    VariableReference charVariable = testCaseBuilder.appendCharPrimitive('\u0000');
                    arguments.add(charVariable);
                    continue block12;
                }
                case 4: {
                    VariableReference shortVariable = testCaseBuilder.appendShortPrimitive((short)0);
                    arguments.add(shortVariable);
                    continue block12;
                }
                case 5: {
                    VariableReference intVariable = testCaseBuilder.appendIntPrimitive(0);
                    arguments.add(intVariable);
                    continue block12;
                }
                case 7: {
                    VariableReference longVariable = testCaseBuilder.appendLongPrimitive(0L);
                    arguments.add(longVariable);
                    continue block12;
                }
                case 6: {
                    VariableReference floatVariable = testCaseBuilder.appendFloatPrimitive(0.0f);
                    arguments.add(floatVariable);
                    continue block12;
                }
                case 8: {
                    VariableReference doubleVariable = testCaseBuilder.appendDoublePrimitive(0.0);
                    arguments.add(doubleVariable);
                    continue block12;
                }
                case 9: {
                    ArrayReference arrayVariable = testCaseBuilder.appendArrayStmt(argumentClass, 0);
                    arguments.add(arrayVariable);
                    continue block12;
                }
                case 10: {
                    if (argumentClass.equals(String.class)) {
                        VariableReference stringVariable = testCaseBuilder.appendStringPrimitive("");
                        arguments.add(stringVariable);
                        continue block12;
                    }
                    VariableReference objectVariable = testCaseBuilder.appendNull(argumentClass);
                    arguments.add(objectVariable);
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        testCaseBuilder.appendMethod(null, targetStaticMethod, arguments.toArray(new VariableReference[0]));
        DefaultTestCase testCase = testCaseBuilder.getDefaultTestCase();
        return testCase;
    }

    public DSEAlgorithm() {
        super(null);
    }

    @Override
    protected void evolve() {
    }

    @Override
    public void initializePopulation() {
        TestSuiteChromosome individual = new TestSuiteChromosome();
        this.population.clear();
        this.population.add(individual);
        this.calculateFitness(individual);
    }

    private static List<Method> getTargetStaticMethods(Class<?> targetClass) {
        Method[] declaredMethods = targetClass.getDeclaredMethods();
        LinkedList<Method> targetStaticMethods = new LinkedList<Method>();
        for (Method m : declaredMethods) {
            if (!Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || m.getName().equals("__STATIC_RESET")) continue;
            targetStaticMethods.add(m);
        }
        return targetStaticMethods;
    }

    @Override
    public void generateSolution() {
        this.notifySearchStarted();
        this.initializePopulation();
        Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
        List<Method> targetStaticMethods = DSEAlgorithm.getTargetStaticMethods(targetClass);
        targetStaticMethods.sort(new MethodComparator());
        logger.debug("Found " + targetStaticMethods.size() + " as entry points for DSE");
        for (Method entryMethod : targetStaticMethods) {
            if (this.isFinished()) {
                logger.debug("A stoping condition was met. No more tests can be generated using DSE.");
                break;
            }
            if (((TestSuiteChromosome)this.getBestIndividual()).getFitness() == 0.0) {
                logger.debug("Best individual reached zero fitness");
                break;
            }
            logger.debug("Generating tests for entry method" + entryMethod.getName());
            int testCaseCount = ((TestSuiteChromosome)this.getBestIndividual()).getTests().size();
            this.generateTestCasesAndAppendToBestIndividual(entryMethod);
            int numOfGeneratedTestCases = ((TestSuiteChromosome)this.getBestIndividual()).getTests().size() - testCaseCount;
            logger.debug(numOfGeneratedTestCases + " tests were generated for entry method " + entryMethod.getName());
        }
        this.updateFitnessFunctionsAndValues();
        this.notifySearchFinished();
    }
}

