/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.dse.VM;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.bv.RealToIntegerCast;
import org.evosuite.symbolic.expr.fp.IntegerToRealCast;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.wrappers.Types;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.environment.FileNamePrimitiveStatement;
import org.evosuite.testcase.statements.environment.LocalAddressPrimitiveStatement;
import org.evosuite.testcase.statements.environment.RemoteAddressPrimitiveStatement;
import org.evosuite.testcase.statements.environment.UrlPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BytePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.CharPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.DoublePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.FloatPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.LongPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.ShortPrimitiveStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;

public class SymbolicObserver
extends ExecutionObserver {
    private static final String INIT = "<init>";
    private final SymbolicEnvironment env;
    private static final int COMPONENT_TYPE_BOOLEAN = 4;
    private static final int COMPONENT_TYPE_CHAR = 5;
    private static final int COMPONENT_TYPE_FLOAT = 6;
    private static final int COMPONENT_TYPE_DOUBLE = 7;
    private static final int COMPONENT_TYPE_BYTE = 8;
    private static final int COMPONENT_TYPE_SHORT = 9;
    private static final int COMPONENT_TYPE_INT = 10;
    private static final int COMPONENT_TYPE_LONG = 11;
    private final Map<String, Expression<?>> symb_expressions = new HashMap();
    private final Map<String, ReferenceExpression> symb_references = new HashMap<String, ReferenceExpression>();
    private final Map<String, IntegerVariable> integerVariables = new HashMap<String, IntegerVariable>();
    private final Map<String, RealVariable> realVariables = new HashMap<String, RealVariable>();
    private final Map<String, StringVariable> stringVariables = new HashMap<String, StringVariable>();

    public SymbolicObserver(SymbolicEnvironment env) {
        this.env = env;
    }

    @Override
    public void output(int position, String output) {
    }

    private void before(ConstructorStatement stmt, Scope scope) {
        String className = stmt.getConstructor().getDeclaringClass().getName();
        VM.NEW(className);
        VM.DUP();
        String desc = org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(stmt.getConstructor().getConstructor());
        this.pushParameterList(stmt.getParameterReferences(), scope, desc);
        String owner = className.replace('.', '/');
        VM.INVOKESPECIAL(owner, INIT, desc);
        boolean needThis = true;
        this.call_vm_caller_stack_params(needThis, stmt.getParameterReferences(), scope, desc);
    }

    private void after(ConstructorStatement stmt, Scope scope) {
        String className = stmt.getConstructor().getDeclaringClass().getName();
        String desc = org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(stmt.getConstructor().getConstructor());
        String onwer = className.replace('.', '/');
        VM.CALL_RESULT(onwer, INIT, desc);
        VariableReference varRef = stmt.getReturnValue();
        ReferenceConstant nonNullRef = (ReferenceConstant)this.env.topFrame().operandStack.popRef();
        String varName = varRef.getName();
        this.symb_references.put(varName, nonNullRef);
    }

    @Override
    public void beforeStatement(Statement s, Scope scope) {
        block27: {
            if (VM.getInstance().isStopped()) {
                return;
            }
            VM.enableCallBacks();
            try {
                if (this.env.isEmpty()) {
                    this.env.prepareStack(null);
                }
                if (s instanceof NullStatement) {
                    this.before((NullStatement)s, scope);
                    break block27;
                }
                if (s instanceof AssignmentStatement) {
                    this.before((AssignmentStatement)s, scope);
                    break block27;
                }
                if (s instanceof EnumPrimitiveStatement) {
                    this.before((EnumPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ArrayStatement) {
                    this.before((ArrayStatement)s, scope);
                    break block27;
                }
                if (s instanceof FieldStatement) {
                    this.before((FieldStatement)s, scope);
                    break block27;
                }
                if (s instanceof ConstructorStatement) {
                    this.before((ConstructorStatement)s, scope);
                    break block27;
                }
                if (s instanceof MethodStatement) {
                    this.before((MethodStatement)s, scope);
                    break block27;
                }
                if (s instanceof FunctionalMockStatement) {
                    this.before((FunctionalMockStatement)s, scope);
                    break block27;
                }
                if (s instanceof BooleanPrimitiveStatement) {
                    this.before((BooleanPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof BytePrimitiveStatement) {
                    this.before((BytePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof CharPrimitiveStatement) {
                    this.before((CharPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof DoublePrimitiveStatement) {
                    this.before((DoublePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof FloatPrimitiveStatement) {
                    this.before((FloatPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof IntPrimitiveStatement) {
                    this.before((IntPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof LongPrimitiveStatement) {
                    this.before((LongPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ShortPrimitiveStatement) {
                    this.before((ShortPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof StringPrimitiveStatement) {
                    this.before((StringPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ClassPrimitiveStatement) {
                    this.before((ClassPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof FileNamePrimitiveStatement) {
                    this.before((FileNamePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof LocalAddressPrimitiveStatement) {
                    this.before((LocalAddressPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof RemoteAddressPrimitiveStatement) {
                    this.before((RemoteAddressPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof UrlPrimitiveStatement) {
                    this.before((UrlPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof PrimitiveExpression) {
                    this.before((PrimitiveExpression)s, scope);
                    break block27;
                }
                throw new UnsupportedOperationException("Cannot handle statement of type " + s.getClass());
            }
            catch (Throwable t) {
                throw new EvosuiteError(t);
            }
        }
    }

    private void before(PrimitiveExpression s, Scope scope) {
        throw new UnsupportedOperationException("This method should be implemented!");
    }

    private void before(ClassPrimitiveStatement s, Scope scope) {
    }

    private void after(ArrayStatement s, Scope scope) {
        try {
            ArrayReference arrayRef = (ArrayReference)s.getReturnValue();
            Object conc_array = arrayRef.getObject(scope);
            if (arrayRef.getArrayDimensions() == 1) {
                int length = arrayRef.getArrayLength();
                IntegerConstant lengthExpr = ExpressionFactory.buildNewIntegerConstant(length);
                Class<?> component_class = arrayRef.getComponentClass();
                this.env.topFrame().operandStack.pushBv32(lengthExpr);
                if (component_class.equals(Integer.TYPE)) {
                    VM.NEWARRAY(length, 10);
                } else if (component_class.equals(Character.TYPE)) {
                    VM.NEWARRAY(length, 5);
                } else if (component_class.equals(Short.TYPE)) {
                    VM.NEWARRAY(length, 9);
                } else if (component_class.equals(Byte.TYPE)) {
                    VM.NEWARRAY(length, 8);
                } else if (component_class.equals(Float.TYPE)) {
                    VM.NEWARRAY(length, 6);
                } else if (component_class.equals(Long.TYPE)) {
                    VM.NEWARRAY(length, 11);
                } else if (component_class.equals(Boolean.TYPE)) {
                    VM.NEWARRAY(length, 4);
                } else if (component_class.equals(Double.TYPE)) {
                    VM.NEWARRAY(length, 7);
                } else {
                    String componentTypeName = component_class.getName().replace('.', '/');
                    VM.ANEWARRAY(length, componentTypeName);
                }
            } else {
                List<Integer> dimensions = arrayRef.getLengths();
                for (int i = 0; i < arrayRef.getArrayDimensions(); ++i) {
                    int length = dimensions.get(i);
                    IntegerConstant lengthExpr = ExpressionFactory.buildNewIntegerConstant(length);
                    this.env.topFrame().operandStack.pushBv32(lengthExpr);
                }
                String arrayTypeDesc = org.evosuite.shaded.org.objectweb.asm.Type.getDescriptor(conc_array.getClass());
                VM.MULTIANEWARRAY(arrayTypeDesc, arrayRef.getArrayDimensions());
            }
            ReferenceConstant symb_array = (ReferenceConstant)this.env.topFrame().operandStack.popRef();
            this.env.heap.initializeReference(conc_array, symb_array);
            String varRef_name = arrayRef.getName();
            this.symb_references.put(varRef_name, symb_array);
        }
        catch (CodeUnderTestException e) {
            throw new RuntimeException(e);
        }
    }

    private void before(EnumPrimitiveStatement<?> s, Scope scope) {
    }

    private void before(NullStatement s, Scope scope) {
    }

    private void before(FieldStatement s, Scope scope) {
    }

    private void after(AssignmentStatement s, Scope scope) {
        VariableReference lhs = s.getReturnValue();
        VariableReference rhs = s.getValue();
        ReferenceExpressionPair readResult = this.read(rhs, scope);
        if (lhs instanceof FieldReference) {
            this.writeField((FieldReference)lhs, readResult, scope);
        } else if (lhs instanceof ArrayIndex) {
            this.writeArray((ArrayIndex)lhs, readResult, scope);
        } else {
            this.writeVariable(lhs, readResult);
        }
    }

    private ReferenceExpressionPair read(VariableReference rhs, Scope scope) {
        if (rhs instanceof FieldReference) {
            return this.readField((FieldReference)rhs, scope);
        }
        if (rhs instanceof ArrayIndex) {
            return this.readArray((ArrayIndex)rhs, scope);
        }
        return this.readVariable(rhs, scope);
    }

    private ReferenceExpressionPair readVariable(VariableReference rhs, Scope scope) {
        String rhs_name = rhs.getName();
        ReferenceExpression symb_ref = this.symb_references.get(rhs_name);
        Expression<?> symb_expr = this.symb_expressions.get(rhs_name);
        return new ReferenceExpressionPair(symb_ref, symb_expr);
    }

    private ReferenceExpressionPair readArray(ArrayIndex rhs, Scope scope) {
        ArrayReference arrayReference = rhs.getArray();
        ReferenceConstant symb_array = (ReferenceConstant)this.symb_references.get(arrayReference.getName());
        int conc_index = rhs.getArrayIndex();
        Class<?> componentClass = arrayReference.getComponentClass();
        try {
            Object conc_array = arrayReference.getObject(scope);
            if (componentClass.equals(Integer.TYPE)) {
                int conc_value = Array.getInt(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newIntegerRef = this.newIntegerReference(conc_value, expr);
                return new ReferenceExpressionPair(newIntegerRef, expr);
            }
            if (componentClass.equals(Character.TYPE)) {
                char conc_value = Array.getChar(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newCharacterRef = this.newCharacterReference(Character.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newCharacterRef, expr);
            }
            if (componentClass.equals(Boolean.TYPE)) {
                boolean conc_value = Array.getBoolean(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value ? 1L : 0L);
                ReferenceConstant newBooleanRef = this.newBooleanReference(conc_value, expr);
                return new ReferenceExpressionPair(newBooleanRef, expr);
            }
            if (componentClass.equals(Byte.TYPE)) {
                byte conc_value = Array.getByte(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newByteRef = this.newByteReference(conc_value, expr);
                return new ReferenceExpressionPair(newByteRef, expr);
            }
            if (componentClass.equals(Short.TYPE)) {
                short conc_value = Array.getShort(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newShortRef = this.newShortReference(conc_value, expr);
                return new ReferenceExpressionPair(newShortRef, expr);
            }
            if (componentClass.equals(Long.TYPE)) {
                long conc_value = Array.getLong(conc_array, conc_index);
                IntegerValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newLongRef = this.newLongReference(conc_value, expr);
                return new ReferenceExpressionPair(newLongRef, expr);
            }
            if (componentClass.equals(Float.TYPE)) {
                float conc_value = Array.getFloat(conc_array, conc_index);
                RealValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newFloatRef = this.newFloatReference(Float.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newFloatRef, expr);
            }
            if (componentClass.equals(Double.TYPE)) {
                double conc_value = Array.getDouble(conc_array, conc_index);
                RealValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, conc_value);
                ReferenceConstant newDoubleRef = this.newDoubleReference(conc_value, expr);
                return new ReferenceExpressionPair(newDoubleRef, expr);
            }
            Object conc_value = Array.get(conc_array, conc_index);
            if (conc_value instanceof String) {
                StringValue expr = this.env.heap.array_load((ReferenceExpression)symb_array, conc_index, (String)conc_value);
                ReferenceConstant newStringRef = this.newStringReference((String)conc_value, expr);
                return new ReferenceExpressionPair(newStringRef, expr);
            }
            ReferenceExpression ref = this.env.heap.getReference(conc_value);
            if (conc_value != null && SymbolicObserver.isWrapper(conc_value)) {
                ReferenceConstant nonNullRef = (ReferenceConstant)ref;
                Expression<?> expr = this.findOrCreate(conc_value, nonNullRef);
                return new ReferenceExpressionPair(ref, expr);
            }
            return new ReferenceExpressionPair(ref, null);
        }
        catch (CodeUnderTestException e) {
            throw new RuntimeException(e);
        }
    }

    private ReferenceExpressionPair readField(FieldReference rhs, Scope scope) {
        if (rhs.getSource() != null) {
            return this.readInstanceField(rhs.getSource(), rhs.getField().getField(), scope);
        }
        return this.readStaticField(rhs.getField().getField());
    }

    private ReferenceExpressionPair readStaticField(Field field) {
        String owner = field.getDeclaringClass().getName().replace('.', '/');
        String name = field.getName();
        Class<?> fieldClazz = field.getType();
        try {
            if (fieldClazz.equals(Integer.TYPE)) {
                int conc_value = field.getInt(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newIntegerRef = this.newIntegerReference(conc_value, expr);
                return new ReferenceExpressionPair(newIntegerRef, expr);
            }
            if (fieldClazz.equals(Character.TYPE)) {
                char conc_value = field.getChar(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newCharacterRef = this.newCharacterReference(Character.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newCharacterRef, expr);
            }
            if (fieldClazz.equals(Long.TYPE)) {
                long conc_value = field.getLong(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newLongRef = this.newLongReference(conc_value, expr);
                return new ReferenceExpressionPair(newLongRef, expr);
            }
            if (fieldClazz.equals(Short.TYPE)) {
                short conc_value = field.getShort(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newShortRef = this.newShortReference(conc_value, expr);
                return new ReferenceExpressionPair(newShortRef, expr);
            }
            if (fieldClazz.equals(Byte.TYPE)) {
                byte conc_value = field.getByte(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newByteRef = this.newByteReference(conc_value, expr);
                return new ReferenceExpressionPair(newByteRef, expr);
            }
            if (fieldClazz.equals(Boolean.TYPE)) {
                boolean conc_value = field.getBoolean(null);
                IntegerValue expr = this.env.heap.getStaticField(owner, name, conc_value ? 1L : 0L);
                ReferenceConstant newBooleanRef = this.newBooleanReference(conc_value, expr);
                return new ReferenceExpressionPair(newBooleanRef, expr);
            }
            if (fieldClazz.equals(Float.TYPE)) {
                float conc_value = field.getFloat(null);
                RealValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newFloatRef = this.newFloatReference(Float.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newFloatRef, expr);
            }
            if (fieldClazz.equals(Double.TYPE)) {
                double conc_value = field.getDouble(null);
                RealValue expr = this.env.heap.getStaticField(owner, name, conc_value);
                ReferenceConstant newDoubleRef = this.newDoubleReference(conc_value, expr);
                return new ReferenceExpressionPair(newDoubleRef, expr);
            }
            Object conc_value = field.get(null);
            if (conc_value instanceof String) {
                String string = (String)conc_value;
                StringValue expr = this.env.heap.getStaticField(owner, name, string);
                ReferenceConstant newStringRef = this.newStringReference(string, expr);
                return new ReferenceExpressionPair(newStringRef, expr);
            }
            ReferenceExpression ref = this.env.heap.getReference(conc_value);
            if (conc_value != null && SymbolicObserver.isWrapper(conc_value)) {
                ReferenceConstant nonNullRef = (ReferenceConstant)ref;
                Expression<?> expr = this.findOrCreate(conc_value, nonNullRef);
                return new ReferenceExpressionPair(ref, expr);
            }
            return new ReferenceExpressionPair(ref, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ReferenceExpressionPair readInstanceField(VariableReference source, Field field, Scope scope) {
        String owner = field.getDeclaringClass().getName().replace('.', '/');
        String name = field.getName();
        Class<?> fieldClazz = field.getType();
        String source_name = source.getName();
        ReferenceConstant symb_receiver = (ReferenceConstant)this.symb_references.get(source_name);
        try {
            Object conc_receiver = source.getObject(scope);
            if (fieldClazz.equals(Integer.TYPE)) {
                int conc_value = field.getInt(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newIntegerRef = this.newIntegerReference(conc_value, expr);
                return new ReferenceExpressionPair(newIntegerRef, expr);
            }
            if (fieldClazz.equals(Character.TYPE)) {
                char conc_value = field.getChar(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newCharacterRef = this.newCharacterReference(Character.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newCharacterRef, expr);
            }
            if (fieldClazz.equals(Long.TYPE)) {
                long conc_value = field.getLong(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newLongRef = this.newLongReference(conc_value, expr);
                return new ReferenceExpressionPair(newLongRef, expr);
            }
            if (fieldClazz.equals(Short.TYPE)) {
                short conc_value = field.getShort(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newShortRef = this.newShortReference(conc_value, expr);
                return new ReferenceExpressionPair(newShortRef, expr);
            }
            if (fieldClazz.equals(Byte.TYPE)) {
                byte conc_value = field.getByte(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newByteRef = this.newByteReference(conc_value, expr);
                return new ReferenceExpressionPair(newByteRef, expr);
            }
            if (fieldClazz.equals(Boolean.TYPE)) {
                boolean conc_value = field.getBoolean(conc_receiver);
                IntegerValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value ? 1L : 0L);
                ReferenceConstant newBooleanRef = this.newBooleanReference(conc_value, expr);
                return new ReferenceExpressionPair(newBooleanRef, expr);
            }
            if (fieldClazz.equals(Float.TYPE)) {
                float conc_value = field.getFloat(conc_receiver);
                RealValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newFloatRef = this.newFloatReference(Float.valueOf(conc_value), expr);
                return new ReferenceExpressionPair(newFloatRef, expr);
            }
            if (fieldClazz.equals(Double.TYPE)) {
                double conc_value = field.getDouble(conc_receiver);
                RealValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, conc_value);
                ReferenceConstant newDoubleRef = this.newDoubleReference(conc_value, expr);
                return new ReferenceExpressionPair(newDoubleRef, expr);
            }
            Object conc_value = field.get(conc_receiver);
            if (conc_value instanceof String) {
                String string = (String)conc_value;
                StringValue expr = this.env.heap.getField(owner, name, conc_receiver, (ReferenceExpression)symb_receiver, string);
                ReferenceConstant newStringRef = this.newStringReference(string, expr);
                return new ReferenceExpressionPair(newStringRef, expr);
            }
            ReferenceExpression ref = this.env.heap.getReference(conc_value);
            if (conc_value != null && SymbolicObserver.isWrapper(conc_value)) {
                ReferenceConstant nonNullRef = (ReferenceConstant)ref;
                Expression<?> expr = this.findOrCreate(conc_value, nonNullRef);
                return new ReferenceExpressionPair(ref, expr);
            }
            return new ReferenceExpressionPair(ref, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (CodeUnderTestException e) {
            throw new RuntimeException(e);
        }
    }

    private void before(AssignmentStatement s, Scope scope) {
    }

    private void writeVariable(VariableReference lhs, ReferenceExpressionPair readResult) {
        ReferenceExpression ref;
        String lhs_name = lhs.getName();
        Expression<?> expr = readResult.getExpression();
        if (expr != null) {
            this.symb_expressions.put(lhs_name, expr);
        }
        if ((ref = readResult.getReference()) != null) {
            this.symb_references.put(lhs_name, ref);
        }
    }

    private void writeArray(ArrayIndex lhs, ReferenceExpressionPair readResult, Scope scope) {
        Object conc_array;
        ArrayReference arrayReference = lhs.getArray();
        int conc_index = lhs.getArrayIndex();
        try {
            conc_array = arrayReference.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        org.evosuite.shaded.org.objectweb.asm.Type arrayType = org.evosuite.shaded.org.objectweb.asm.Type.getType(conc_array.getClass());
        org.evosuite.shaded.org.objectweb.asm.Type elementType = arrayType.getElementType();
        if (SymbolicObserver.isValue(elementType) || elementType.equals(org.evosuite.shaded.org.objectweb.asm.Type.getType(String.class))) {
            Expression<?> symb_value = readResult.getExpression();
            symb_value = this.castIfNeeded(elementType, symb_value);
            String array_name = arrayReference.getName();
            ReferenceExpression symb_ref = this.symb_references.get(array_name);
            ReferenceConstant symb_array = (ReferenceConstant)symb_ref;
            this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
        }
    }

    private Expression<?> castIfNeeded(org.evosuite.shaded.org.objectweb.asm.Type elementType, Expression<?> symb_value) {
        if ((SymbolicObserver.isFp32(elementType) || SymbolicObserver.isFp64(elementType)) && symb_value instanceof IntegerValue) {
            IntegerValue intExpr = (IntegerValue)((Object)symb_value);
            double concValue = ((Long)intExpr.getConcreteValue()).doubleValue();
            symb_value = new IntegerToRealCast(intExpr, concValue);
        } else if ((SymbolicObserver.isBv32(elementType) || SymbolicObserver.isBv64(elementType)) && symb_value instanceof RealValue) {
            RealValue realExpr = symb_value;
            long concValue = ((Double)realExpr.getConcreteValue()).longValue();
            symb_value = new RealToIntegerCast(realExpr, concValue);
        }
        return symb_value;
    }

    private void writeField(FieldReference lhs, ReferenceExpressionPair readResult, Scope scope) {
        Field field = lhs.getField().getField();
        String className = field.getDeclaringClass().getName().replace('.', '/');
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        org.evosuite.shaded.org.objectweb.asm.Type fieldType = org.evosuite.shaded.org.objectweb.asm.Type.getType(fieldClass);
        if (SymbolicObserver.isValue(fieldType) || fieldType.equals(org.evosuite.shaded.org.objectweb.asm.Type.getType(String.class))) {
            Expression<?> symb_value = readResult.getExpression();
            symb_value = this.castIfNeeded(fieldType, symb_value);
            VariableReference source = lhs.getSource();
            if (source != null) {
                Object conc_receiver;
                String source_name = source.getName();
                try {
                    conc_receiver = source.getObject(scope);
                }
                catch (CodeUnderTestException e) {
                    throw new RuntimeException(e);
                }
                ReferenceConstant symb_receiver = (ReferenceConstant)this.symb_references.get(source_name);
                this.env.heap.putField(className, fieldName, conc_receiver, symb_receiver, symb_value);
            } else {
                this.env.heap.putStaticField(className, fieldName, symb_value);
            }
        }
    }

    private void before(ShortPrimitiveStatement statement, Scope scope) {
    }

    private void before(LongPrimitiveStatement statement, Scope scope) {
    }

    private void before(FloatPrimitiveStatement statement, Scope scope) {
    }

    private void before(CharPrimitiveStatement statement, Scope scope) {
    }

    private void before(BytePrimitiveStatement statement, Scope scope) {
    }

    private void before(BooleanPrimitiveStatement statement, Scope scope) {
    }

    private void before(DoublePrimitiveStatement statement, Scope scope) {
    }

    private void before(MethodStatement statement, Scope scope) {
        boolean needThis;
        Method method = statement.getMethod().getMethod();
        String owner = method.getDeclaringClass().getName().replace('.', '/');
        String name = method.getName();
        String desc = org.evosuite.shaded.org.objectweb.asm.Type.getMethodDescriptor(method);
        boolean bl = needThis = statement.getCallee() != null;
        if (needThis) {
            VariableReference callee = statement.getCallee();
            ReferenceExpressionPair refExprPair = this.read(callee, scope);
            ReferenceExpression ref = refExprPair.getReference();
            this.env.topFrame().operandStack.pushRef(ref);
        }
        List<VariableReference> parameters = statement.getParameterReferences();
        this.pushParameterList(parameters, scope, desc);
        if (needThis) {
            Object receiver;
            VariableReference callee = statement.getCallee();
            try {
                receiver = callee.getObject(scope);
            }
            catch (CodeUnderTestException e) {
                throw new RuntimeException(e);
            }
            Class<?> ownerClass = this.env.ensurePrepared(owner);
            if (ownerClass.isInterface()) {
                VM.INVOKEINTERFACE(receiver, owner, name, desc);
            } else {
                VM.INVOKEVIRTUAL(receiver, owner, name, desc);
            }
        } else {
            VM.INVOKESTATIC(owner, name, desc);
        }
        this.call_vm_caller_stack_params(needThis, parameters, scope, desc);
    }

    private void call_vm_caller_stack_params(boolean needThis, List<VariableReference> parameters, Scope scope, String desc) {
        int calleeLocalsIndex = 0;
        if (needThis) {
            ++calleeLocalsIndex;
        }
        for (VariableReference p : parameters) {
            calleeLocalsIndex += this.getSize(p.getType());
        }
        org.evosuite.shaded.org.objectweb.asm.Type[] argTypes = org.evosuite.shaded.org.objectweb.asm.Type.getArgumentTypes(desc);
        for (int i = parameters.size() - 1; i >= 0; --i) {
            org.evosuite.shaded.org.objectweb.asm.Type argType = argTypes[i];
            VariableReference p = parameters.get(i);
            try {
                Object param_object = p.getObject(scope);
                calleeLocalsIndex -= this.getSize(p.getType());
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.INT_TYPE)) {
                    int intValue = SymbolicObserver.getIntValue(param_object);
                    VM.CALLER_STACK_PARAM(intValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.CHAR_TYPE)) {
                    char charValue = SymbolicObserver.getCharValue(param_object);
                    VM.CALLER_STACK_PARAM(charValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BYTE_TYPE)) {
                    byte byteValue = SymbolicObserver.getByteValue(param_object);
                    VM.CALLER_STACK_PARAM(byteValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BOOLEAN_TYPE)) {
                    boolean booleanValue = SymbolicObserver.getBooleanValue(param_object);
                    VM.CALLER_STACK_PARAM(booleanValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.SHORT_TYPE)) {
                    short shortValue = SymbolicObserver.getShortValue(param_object);
                    VM.CALLER_STACK_PARAM(shortValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.LONG_TYPE)) {
                    long longValue = SymbolicObserver.getLongValue(param_object);
                    VM.CALLER_STACK_PARAM(longValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.FLOAT_TYPE)) {
                    float floatValue = SymbolicObserver.getFloatValue(param_object);
                    VM.CALLER_STACK_PARAM(floatValue, i, calleeLocalsIndex);
                    continue;
                }
                if (argType.equals(org.evosuite.shaded.org.objectweb.asm.Type.DOUBLE_TYPE)) {
                    double doubleValue = SymbolicObserver.getDoubleValue(param_object);
                    VM.CALLER_STACK_PARAM(doubleValue, i, calleeLocalsIndex);
                    continue;
                }
                VM.CALLER_STACK_PARAM(param_object, i, calleeLocalsIndex);
                continue;
            }
            catch (CodeUnderTestException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static double getDoubleValue(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static float getFloatValue(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0f : 0.0f;
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (float)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static long getLongValue(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Float) {
            return (long)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (long)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static int getIntValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static short getShortValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (short)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return (short)((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return (short)((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (short)((Long)o).longValue();
        }
        if (o instanceof Float) {
            return (short)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (short)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static byte getByteValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (byte)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Short) {
            return (byte)((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Character) {
            return (byte)((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return (byte)((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (byte)((Long)o).longValue();
        }
        if (o instanceof Float) {
            return (byte)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (byte)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static char getCharValue(Object o) {
        if (o == null) {
            return '\u0000';
        }
        if (o instanceof Boolean) {
            return (char)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Short) {
            return (char)((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return (char)((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Integer) {
            return (char)((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (char)((Long)o).longValue();
        }
        if (o instanceof Float) {
            return (char)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (char)((Double)o).doubleValue();
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static boolean getBooleanValue(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Short) {
            return (Short)o == 1;
        }
        if (o instanceof Byte) {
            return (Byte)o == 1;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue() == '\u0001';
        }
        if (o instanceof Integer) {
            return (Integer)o == 1;
        }
        if (o instanceof Long) {
            return (Long)o == 1L;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() == 1.0f;
        }
        if (o instanceof Double) {
            return (Double)o == 1.0;
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private int getSize(Type type) {
        if (type.equals(Double.TYPE)) {
            return 2;
        }
        if (type.equals(Long.TYPE)) {
            return 2;
        }
        return 1;
    }

    private void pushParameterList(List<VariableReference> parameters, Scope scope, String desc) {
        org.evosuite.shaded.org.objectweb.asm.Type[] argTypes = org.evosuite.shaded.org.objectweb.asm.Type.getArgumentTypes(desc);
        for (int i = 0; i < parameters.size(); ++i) {
            VariableReference varRef = parameters.get(i);
            org.evosuite.shaded.org.objectweb.asm.Type argType = argTypes[i];
            ReferenceExpressionPair readResult = this.read(varRef, scope);
            Expression<?> symb_expr = readResult.getExpression();
            ReferenceExpression symb_ref = readResult.getReference();
            if (SymbolicObserver.isValue(argType)) {
                AbstractExpression castExpr;
                AbstractExpression castExpr2;
                if (symb_expr instanceof RealValue) {
                    RealValue realExpr = (RealValue)symb_expr;
                    if (SymbolicObserver.isFp32(argType)) {
                        this.env.topFrame().operandStack.pushFp32(realExpr);
                        continue;
                    }
                    if (SymbolicObserver.isFp64(argType)) {
                        this.env.topFrame().operandStack.pushFp64(realExpr);
                        continue;
                    }
                    if (SymbolicObserver.isBv32(argType)) {
                        int concV = ((Double)realExpr.getConcreteValue()).intValue();
                        castExpr2 = new RealToIntegerCast(realExpr, Long.valueOf(concV));
                        this.env.topFrame().operandStack.pushBv32((IntegerValue)((Object)castExpr2));
                        continue;
                    }
                    if (!SymbolicObserver.isBv64(argType)) continue;
                    long concV = ((Double)realExpr.getConcreteValue()).longValue();
                    castExpr = new RealToIntegerCast(realExpr, concV);
                    this.env.topFrame().operandStack.pushBv64((IntegerValue)((Object)castExpr));
                    continue;
                }
                if (symb_expr instanceof IntegerValue) {
                    IntegerValue integerExpr = (IntegerValue)symb_expr;
                    if (SymbolicObserver.isBv32(argType)) {
                        this.env.topFrame().operandStack.pushBv32(integerExpr);
                        continue;
                    }
                    if (SymbolicObserver.isBv64(argType)) {
                        this.env.topFrame().operandStack.pushBv64(integerExpr);
                        continue;
                    }
                    if (SymbolicObserver.isFp32(argType)) {
                        float concV = ((Long)integerExpr.getConcreteValue()).floatValue();
                        castExpr2 = new IntegerToRealCast(integerExpr, Double.valueOf(concV));
                        this.env.topFrame().operandStack.pushFp32((RealValue)((Object)castExpr2));
                        continue;
                    }
                    if (!SymbolicObserver.isFp64(argType)) continue;
                    double concV = ((Long)integerExpr.getConcreteValue()).doubleValue();
                    castExpr = new IntegerToRealCast(integerExpr, concV);
                    this.env.topFrame().operandStack.pushFp64((RealValue)((Object)castExpr));
                    continue;
                }
                if (symb_ref.getConcreteValue() == null) {
                    this.pushDummyValue(argType);
                    continue;
                }
                ReferenceConstant non_null_symb_ref = (ReferenceConstant)symb_ref;
                Object conc_object = scope.getObject(varRef);
                Expression<?> unboxed_expr = this.unboxReference(argType, conc_object, non_null_symb_ref);
                this.pushValue(argType, unboxed_expr);
                continue;
            }
            ReferenceExpression ref = readResult.getReference();
            this.env.topFrame().operandStack.pushRef(ref);
        }
    }

    private Expression<?> unboxReference(org.evosuite.shaded.org.objectweb.asm.Type argType, Object conc_object, ReferenceConstant non_null_symb_ref) {
        switch (argType.getSort()) {
            case 1: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_BOOLEAN, "$booleanValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 3: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_BYTE, "$byteValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 2: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_CHARACTER, "$charValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 8: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_DOUBLE, "$doubleValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 6: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_FLOAT, "$floatValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 5: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_INTEGER, "$intValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 7: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_LONG, "$longValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
            case 4: {
                Expression<?> symb_expr = this.env.heap.getField(Types.JAVA_LANG_SHORT, "$shortValue", conc_object, non_null_symb_ref);
                return symb_expr;
            }
        }
        throw new EvosuiteError(argType.toString() + " cannot be automatically unboxed");
    }

    private void pushValue(org.evosuite.shaded.org.objectweb.asm.Type argType, Expression<?> symb_expr) {
        if (SymbolicObserver.isBv32(argType)) {
            IntegerValue booleanExpr = (IntegerValue)symb_expr;
            this.env.topFrame().operandStack.pushBv32(booleanExpr);
        } else if (SymbolicObserver.isBv64(argType)) {
            IntegerValue longExpr = (IntegerValue)symb_expr;
            this.env.topFrame().operandStack.pushBv64(longExpr);
        } else if (SymbolicObserver.isFp32(argType)) {
            RealValue realExpr = (RealValue)symb_expr;
            this.env.topFrame().operandStack.pushFp32(realExpr);
        } else if (SymbolicObserver.isFp64(argType)) {
            RealValue realExpr = (RealValue)symb_expr;
            this.env.topFrame().operandStack.pushFp64(realExpr);
        } else {
            throw new EvosuiteError(argType.toString() + " is not a value type!");
        }
    }

    private void pushDummyValue(org.evosuite.shaded.org.objectweb.asm.Type argType) {
        if (SymbolicObserver.isBv32(argType)) {
            IntegerConstant integerExpr = ExpressionFactory.buildNewIntegerConstant(0);
            this.env.topFrame().operandStack.pushBv32(integerExpr);
        } else if (SymbolicObserver.isBv64(argType)) {
            IntegerConstant integerExpr = ExpressionFactory.buildNewIntegerConstant(0);
            this.env.topFrame().operandStack.pushBv64(integerExpr);
        } else if (SymbolicObserver.isFp32(argType)) {
            RealConstant realExpr = ExpressionFactory.buildNewRealConstant(0.0f);
            this.env.topFrame().operandStack.pushFp32(realExpr);
        } else if (SymbolicObserver.isFp64(argType)) {
            RealConstant realExpr = ExpressionFactory.buildNewRealConstant(0.0f);
            this.env.topFrame().operandStack.pushFp64(realExpr);
        } else {
            throw new EvosuiteError(argType.toString() + " is not a value type!");
        }
    }

    private static boolean isValue(org.evosuite.shaded.org.objectweb.asm.Type t) {
        return SymbolicObserver.isBv32(t) || SymbolicObserver.isBv64(t) || SymbolicObserver.isFp32(t) || SymbolicObserver.isFp64(t);
    }

    private static boolean isFp64(org.evosuite.shaded.org.objectweb.asm.Type t) {
        return t.equals(org.evosuite.shaded.org.objectweb.asm.Type.DOUBLE_TYPE);
    }

    private static boolean isFp32(org.evosuite.shaded.org.objectweb.asm.Type t) {
        return t.equals(org.evosuite.shaded.org.objectweb.asm.Type.FLOAT_TYPE);
    }

    private static boolean isBv64(org.evosuite.shaded.org.objectweb.asm.Type t) {
        return t.equals(org.evosuite.shaded.org.objectweb.asm.Type.LONG_TYPE);
    }

    private static boolean isBv32(org.evosuite.shaded.org.objectweb.asm.Type t) {
        return t.equals(org.evosuite.shaded.org.objectweb.asm.Type.CHAR_TYPE) || t.equals(org.evosuite.shaded.org.objectweb.asm.Type.BOOLEAN_TYPE) || t.equals(org.evosuite.shaded.org.objectweb.asm.Type.SHORT_TYPE) || t.equals(org.evosuite.shaded.org.objectweb.asm.Type.BYTE_TYPE) || t.equals(org.evosuite.shaded.org.objectweb.asm.Type.INT_TYPE);
    }

    private void before(StringPrimitiveStatement statement, Scope scope) {
    }

    private void before(FileNamePrimitiveStatement statement, Scope scope) {
    }

    private void before(LocalAddressPrimitiveStatement statement, Scope scope) {
    }

    private void before(RemoteAddressPrimitiveStatement statement, Scope scope) {
    }

    private void before(UrlPrimitiveStatement statement, Scope scope) {
    }

    private void before(FunctionalMockStatement statement, Scope scope) {
    }

    private void before(IntPrimitiveStatement statement, Scope scope) {
    }

    @Override
    public void afterStatement(Statement s, Scope scope, Throwable exception) {
        block27: {
            if (exception != null) {
                return;
            }
            if (VM.getInstance().isStopped()) {
                return;
            }
            try {
                if (s instanceof NullStatement) {
                    this.after((NullStatement)s, scope);
                    break block27;
                }
                if (s instanceof EnumPrimitiveStatement) {
                    this.after((EnumPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ArrayStatement) {
                    this.after((ArrayStatement)s, scope);
                    break block27;
                }
                if (s instanceof AssignmentStatement) {
                    this.after((AssignmentStatement)s, scope);
                    break block27;
                }
                if (s instanceof FieldStatement) {
                    this.after((FieldStatement)s, scope);
                    break block27;
                }
                if (s instanceof ConstructorStatement) {
                    this.after((ConstructorStatement)s, scope);
                    break block27;
                }
                if (s instanceof BooleanPrimitiveStatement) {
                    this.after((BooleanPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof MethodStatement) {
                    this.after((MethodStatement)s, scope);
                    break block27;
                }
                if (s instanceof BytePrimitiveStatement) {
                    this.after((BytePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof CharPrimitiveStatement) {
                    this.after((CharPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof DoublePrimitiveStatement) {
                    this.after((DoublePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof FloatPrimitiveStatement) {
                    this.after((FloatPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof IntPrimitiveStatement) {
                    this.after((IntPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof LongPrimitiveStatement) {
                    this.after((LongPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ShortPrimitiveStatement) {
                    this.after((ShortPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof StringPrimitiveStatement) {
                    this.after((StringPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof ClassPrimitiveStatement) {
                    this.after((ClassPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof FileNamePrimitiveStatement) {
                    this.after((FileNamePrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof LocalAddressPrimitiveStatement) {
                    this.after((LocalAddressPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof RemoteAddressPrimitiveStatement) {
                    this.after((RemoteAddressPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof UrlPrimitiveStatement) {
                    this.after((UrlPrimitiveStatement)s, scope);
                    break block27;
                }
                if (s instanceof PrimitiveExpression) {
                    this.after((PrimitiveExpression)s, scope);
                    break block27;
                }
                if (s instanceof FunctionalMockStatement) {
                    this.after((FunctionalMockStatement)s, scope);
                    break block27;
                }
                throw new UnsupportedOperationException("Cannot handle statement of type " + s.getClass());
            }
            catch (Throwable t) {
                throw new EvosuiteError(t);
            }
        }
    }

    private void after(UrlPrimitiveStatement s, Scope scope) {
        ReferenceExpression urlRef;
        EvoSuiteURL conc_url = (EvoSuiteURL)s.getValue();
        VariableReference varRef = s.getReturnValue();
        String varRefName = varRef.getName();
        if (conc_url == null) {
            urlRef = this.env.heap.getReference(null);
            if (urlRef.getConcreteValue() != null) {
                throw new IllegalStateException("Expected null concrete value");
            }
        } else {
            urlRef = this.env.heap.getReference(conc_url);
            if (urlRef.getConcreteValue() == null) {
                throw new IllegalStateException("Expected non-null concrete value");
            }
        }
        this.symb_references.put(varRefName, urlRef);
    }

    private void after(RemoteAddressPrimitiveStatement s, Scope scope) {
        ReferenceExpression addressRef;
        EvoSuiteRemoteAddress conc_remote_address = (EvoSuiteRemoteAddress)s.getValue();
        VariableReference varRef = s.getReturnValue();
        String varRefName = varRef.getName();
        if (conc_remote_address == null) {
            addressRef = this.env.heap.getReference(null);
            if (addressRef.getConcreteValue() != null) {
                throw new IllegalStateException("Expected null concrete value");
            }
        } else {
            addressRef = this.env.heap.getReference(conc_remote_address);
            if (addressRef.getConcreteValue() == null) {
                throw new IllegalStateException("Expected non-null concrete value");
            }
        }
        this.symb_references.put(varRefName, addressRef);
    }

    private void after(LocalAddressPrimitiveStatement s, Scope scope) {
        ReferenceExpression addressRef;
        EvoSuiteLocalAddress conc_local_address = (EvoSuiteLocalAddress)s.getValue();
        VariableReference varRef = s.getReturnValue();
        String varRefName = varRef.getName();
        if (conc_local_address == null) {
            addressRef = this.env.heap.getReference(null);
            if (addressRef.getConcreteValue() != null) {
                throw new IllegalStateException("Expected null concrete object");
            }
        } else {
            addressRef = this.env.heap.getReference(conc_local_address);
            if (addressRef.getConcreteValue() == null) {
                throw new IllegalStateException("Expected non-null concrete object");
            }
        }
        this.symb_references.put(varRefName, addressRef);
    }

    private void after(PrimitiveExpression s, Scope scope) {
        throw new UnsupportedOperationException("This method should be implemented!");
    }

    private void after(ClassPrimitiveStatement s, Scope scope) {
        VariableReference varRef = s.getReturnValue();
        Class concrete_reference = (Class)s.getValue();
        String varName = varRef.getName();
        ReferenceExpression symb_ref = this.env.heap.getReference(concrete_reference);
        this.symb_references.put(varName, symb_ref);
    }

    private void before(ArrayStatement s, Scope scope) {
    }

    private void after(EnumPrimitiveStatement<?> s, Scope scope) {
        VariableReference varRef = s.getReturnValue();
        String varName = varRef.getName();
        Object conc_value = s.getValue();
        ReferenceExpression symb_value = this.env.heap.getReference(conc_value);
        this.symb_references.put(varName, symb_value);
    }

    private void after(NullStatement s, Scope scope) {
        VariableReference lhs = s.getReturnValue();
        String lhs_name = lhs.getName();
        ReferenceConstant nullConstant = ExpressionFactory.buildNewNullExpression();
        this.symb_references.put(lhs_name, nullConstant);
    }

    private void after(FunctionalMockStatement statement, Scope scope) {
        org.evosuite.shaded.org.objectweb.asm.Type returnType = org.evosuite.shaded.org.objectweb.asm.Type.getType(statement.getReturnClass());
        VariableReference varRef = statement.getReturnValue();
        String varName = varRef.getName();
        try {
            if (!varRef.getType().equals(Void.TYPE)) {
                if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.INT_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BOOLEAN_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.DOUBLE_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.FLOAT_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.LONG_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.SHORT_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BYTE_TYPE) || returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.CHAR_TYPE)) {
                    throw new EvosuiteError("mocking of primitive types is not supported!");
                }
                Object res = varRef.getObject(scope);
                ReferenceExpression ref = this.env.heap.getReference(res);
                if (res != null && res instanceof String) {
                    String string = (String)res;
                    ReferenceConstant newStringRef = (ReferenceConstant)this.env.heap.getReference(string);
                    StringValue str_expr = this.env.heap.getField(Types.JAVA_LANG_STRING, "$stringValue", (Object)string, (ReferenceExpression)newStringRef, string);
                    this.symb_references.put(varName, newStringRef);
                    this.symb_expressions.put(varName, str_expr);
                } else {
                    this.symb_references.put(varName, ref);
                    if (res != null && SymbolicObserver.isWrapper(res)) {
                        ReferenceConstant nonNullRef = (ReferenceConstant)ref;
                        Expression<?> expr = this.findOrCreate(res, nonNullRef);
                        this.symb_expressions.put(varName, expr);
                    }
                }
            }
        }
        catch (CodeUnderTestException e) {
            throw new RuntimeException(e);
        }
    }

    private void after(FieldStatement s, Scope scope) {
        ReferenceExpressionPair readResult = s.getSource() != null ? this.readInstanceField(s.getSource(), s.getField().getField(), scope) : this.readStaticField(s.getField().getField());
        String lhs_name = s.getReturnValue().getName();
        Expression<?> expr = readResult.getExpression();
        ReferenceExpression ref = readResult.getReference();
        if (expr != null) {
            this.symb_expressions.put(lhs_name, expr);
        }
        if (ref != null) {
            this.symb_references.put(lhs_name, ref);
        }
    }

    private void after(ShortPrimitiveStatement statement, Scope scope) {
        Short short_instance;
        short valueOf = (Short)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf, -32768L, 32767L);
        this.symb_expressions.put(varRefName, integerVariable);
        try {
            short_instance = (Short)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant shortRef = this.newShortReference(short_instance, integerVariable);
        this.symb_references.put(varRefName, shortRef);
    }

    private ReferenceConstant newShortReference(Short conc_short, IntegerValue symb_value) {
        ReferenceConstant shortRef = (ReferenceConstant)this.env.heap.getReference(conc_short);
        this.env.heap.putField(Types.JAVA_LANG_SHORT, "$shortValue", conc_short, shortRef, symb_value);
        return shortRef;
    }

    private void after(LongPrimitiveStatement statement, Scope scope) {
        Long long_instance;
        long valueOf = (Long)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf, Long.MIN_VALUE, Long.MAX_VALUE);
        this.symb_expressions.put(varRefName, integerVariable);
        try {
            long_instance = (Long)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant longRef = this.newLongReference(long_instance, integerVariable);
        this.symb_references.put(varRefName, longRef);
    }

    private ReferenceConstant newLongReference(Long conc_long, IntegerValue symb_value) {
        ReferenceConstant longRef = (ReferenceConstant)this.env.heap.getReference(conc_long);
        this.env.heap.putField(Types.JAVA_LANG_LONG, "$longValue", conc_long, longRef, symb_value);
        return longRef;
    }

    private void after(FloatPrimitiveStatement statement, Scope scope) {
        Float float_instance;
        float valueOf = ((Float)statement.getValue()).floatValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        RealVariable realVariable = this.buildRealVariable(varRefName, valueOf, -3.4028234663852886E38, 3.4028234663852886E38);
        this.symb_expressions.put(varRefName, realVariable);
        try {
            float_instance = (Float)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant floatRef = this.newFloatReference(float_instance, realVariable);
        this.symb_references.put(varRefName, floatRef);
    }

    private ReferenceConstant newFloatReference(Float conc_float, RealValue symb_value) {
        ReferenceConstant floatRef = (ReferenceConstant)this.env.heap.getReference(conc_float);
        this.env.heap.putField(Types.JAVA_LANG_FLOAT, "$floatValue", conc_float, floatRef, symb_value);
        return floatRef;
    }

    private void after(CharPrimitiveStatement statement, Scope scope) {
        Character character0;
        char valueOf = ((Character)statement.getValue()).charValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf, 0L, 65535L);
        this.symb_expressions.put(varRefName, integerVariable);
        try {
            character0 = (Character)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant charRef = this.newCharacterReference(character0, integerVariable);
        this.symb_references.put(varRefName, charRef);
    }

    private ReferenceConstant newCharacterReference(Character conc_char, IntegerValue symb_value) {
        ReferenceConstant charRef = (ReferenceConstant)this.env.heap.getReference(conc_char);
        this.env.heap.putField(Types.JAVA_LANG_CHARACTER, "$charValue", conc_char, charRef, symb_value);
        return charRef;
    }

    private void after(BytePrimitiveStatement statement, Scope scope) {
        Byte byte_instance;
        byte valueOf = (Byte)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf, -128L, 127L);
        this.symb_expressions.put(varRefName, integerVariable);
        try {
            byte_instance = (Byte)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant byteRef = this.newByteReference(byte_instance, integerVariable);
        this.symb_references.put(varRefName, byteRef);
    }

    private ReferenceConstant newByteReference(Byte conc_byte, IntegerValue symb_value) {
        ReferenceConstant byteRef = (ReferenceConstant)this.env.heap.getReference(conc_byte);
        this.env.heap.putField(Types.JAVA_LANG_BYTE, "$byteValue", conc_byte, byteRef, symb_value);
        return byteRef;
    }

    private void after(BooleanPrimitiveStatement statement, Scope scope) {
        Boolean boolean_instance;
        boolean valueOf = (Boolean)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf ? 1L : 0L, 0L, 1L);
        try {
            boolean_instance = (Boolean)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        this.symb_expressions.put(varRefName, integerVariable);
        ReferenceConstant booleanRef = this.newBooleanReference(boolean_instance, integerVariable);
        this.symb_references.put(varRefName, booleanRef);
    }

    private ReferenceConstant newBooleanReference(Boolean conc_boolean, IntegerValue symb_value) {
        ReferenceConstant booleanRef = (ReferenceConstant)this.env.heap.getReference(conc_boolean);
        this.env.heap.putField(Types.JAVA_LANG_BOOLEAN, "$booleanValue", conc_boolean, booleanRef, symb_value);
        return booleanRef;
    }

    private void after(DoublePrimitiveStatement statement, Scope scope) {
        Double double_instance;
        double valueOf = (Double)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        RealVariable realVariable = this.buildRealVariable(varRefName, valueOf, -1.7976931348623157E308, Double.MAX_VALUE);
        this.symb_expressions.put(varRefName, realVariable);
        try {
            double_instance = (Double)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant doubleRef = this.newDoubleReference(double_instance, realVariable);
        this.symb_references.put(varRefName, doubleRef);
    }

    private ReferenceConstant newDoubleReference(Double conc_double, RealValue symb_value) {
        ReferenceConstant doubleRef = (ReferenceConstant)this.env.heap.getReference(conc_double);
        this.env.heap.putField(Types.JAVA_LANG_DOUBLE, "$doubleValue", conc_double, doubleRef, symb_value);
        return doubleRef;
    }

    private void after(MethodStatement statement, Scope scope) {
        String owner = statement.getMethod().getDeclaringClass().getName().replace('.', '/');
        String name = statement.getMethod().getName();
        String desc = org.evosuite.shaded.org.objectweb.asm.Type.getMethodDescriptor(statement.getMethod().getMethod());
        org.evosuite.shaded.org.objectweb.asm.Type returnType = org.evosuite.shaded.org.objectweb.asm.Type.getReturnType(statement.getMethod().getMethod());
        VariableReference varRef = statement.getReturnValue();
        String varName = varRef.getName();
        try {
            if (varRef.getType().equals(Void.TYPE)) {
                VM.CALL_RESULT(owner, name, desc);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.INT_TYPE)) {
                Integer res = (Integer)varRef.getObject(scope);
                VM.CALL_RESULT(res, owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
                ReferenceConstant newIntegerRef = this.newIntegerReference(res, intExpr);
                this.symb_references.put(varName, newIntegerRef);
                this.symb_expressions.put(varName, intExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BOOLEAN_TYPE)) {
                Boolean res = (Boolean)varRef.getObject(scope);
                VM.CALL_RESULT(res, owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
                ReferenceConstant newBooleanRef = this.newBooleanReference(res, intExpr);
                this.symb_references.put(varName, newBooleanRef);
                this.symb_expressions.put(varName, intExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.DOUBLE_TYPE)) {
                Double res = (Double)varRef.getObject(scope);
                VM.CALL_RESULT(res, owner, name, desc);
                RealValue realExpr = this.env.topFrame().operandStack.popFp64();
                ReferenceConstant newDoubleRef = this.newDoubleReference(res, realExpr);
                this.symb_references.put(varName, newDoubleRef);
                this.symb_expressions.put(varName, realExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.FLOAT_TYPE)) {
                Float res = (Float)varRef.getObject(scope);
                VM.CALL_RESULT(res.floatValue(), owner, name, desc);
                RealValue realExpr = this.env.topFrame().operandStack.popFp32();
                ReferenceConstant newFloatRef = this.newFloatReference(res, realExpr);
                this.symb_references.put(varName, newFloatRef);
                this.symb_expressions.put(varName, realExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.LONG_TYPE)) {
                Long res = (Long)varRef.getObject(scope);
                VM.CALL_RESULT(res, owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv64();
                ReferenceConstant newBooleanRef = this.newLongReference(res, intExpr);
                this.symb_references.put(varName, newBooleanRef);
                this.symb_expressions.put(varName, intExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.SHORT_TYPE)) {
                Short res = (Short)varRef.getObject(scope);
                VM.CALL_RESULT(res.shortValue(), owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
                ReferenceConstant newShortRef = this.newShortReference(res, intExpr);
                this.symb_references.put(varName, newShortRef);
                this.symb_expressions.put(varName, intExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.BYTE_TYPE)) {
                Byte res = (Byte)varRef.getObject(scope);
                VM.CALL_RESULT(res.byteValue(), owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
                ReferenceConstant newByteRef = this.newByteReference(res, intExpr);
                this.symb_references.put(varName, newByteRef);
                this.symb_expressions.put(varName, intExpr);
            } else if (returnType.equals(org.evosuite.shaded.org.objectweb.asm.Type.CHAR_TYPE)) {
                Character res = (Character)varRef.getObject(scope);
                VM.CALL_RESULT(res.charValue(), owner, name, desc);
                IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
                ReferenceConstant newCharacterRef = this.newCharacterReference(res, intExpr);
                this.symb_references.put(varName, newCharacterRef);
                this.symb_expressions.put(varName, intExpr);
            } else {
                Object res = varRef.getObject(scope);
                VM.CALL_RESULT(res, owner, name, desc);
                ReferenceExpression ref = this.env.topFrame().operandStack.peekRef();
                if (res != null && res instanceof String) {
                    String string = (String)res;
                    ReferenceConstant newStringRef = (ReferenceConstant)this.env.heap.getReference(string);
                    StringValue str_expr = this.env.heap.getField(Types.JAVA_LANG_STRING, "$stringValue", (Object)string, (ReferenceExpression)newStringRef, string);
                    this.symb_references.put(varName, newStringRef);
                    this.symb_expressions.put(varName, str_expr);
                } else {
                    this.symb_references.put(varName, ref);
                    if (res != null && SymbolicObserver.isWrapper(res)) {
                        ReferenceConstant nonNullRef = (ReferenceConstant)ref;
                        Expression<?> expr = this.findOrCreate(res, nonNullRef);
                        this.symb_expressions.put(varName, expr);
                    }
                }
            }
        }
        catch (CodeUnderTestException e) {
            throw new RuntimeException(e);
        }
        this.env.topFrame().operandStack.clearOperands();
    }

    private Expression<?> findOrCreate(Object conc_ref, ReferenceConstant symb_ref) {
        if (conc_ref instanceof Boolean) {
            Boolean boolean0 = (Boolean)conc_ref;
            int conc_val = boolean0 != false ? 1 : 0;
            return this.env.heap.getField(Types.JAVA_LANG_BOOLEAN, "$booleanValue", (Object)boolean0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Byte) {
            Byte byte0 = (Byte)conc_ref;
            byte conc_val = byte0;
            return this.env.heap.getField(Types.JAVA_LANG_BYTE, "$byteValue", (Object)byte0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Short) {
            Short short0 = (Short)conc_ref;
            short conc_val = short0;
            return this.env.heap.getField(Types.JAVA_LANG_SHORT, "$shortValue", (Object)short0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Character) {
            Character character0 = (Character)conc_ref;
            char conc_val = character0.charValue();
            return this.env.heap.getField(Types.JAVA_LANG_CHARACTER, "$charValue", (Object)character0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Integer) {
            Integer integer0 = (Integer)conc_ref;
            int conc_val = integer0;
            return this.env.heap.getField(Types.JAVA_LANG_INTEGER, "$intValue", (Object)integer0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Long) {
            Long long0 = (Long)conc_ref;
            long conc_val = long0;
            return this.env.heap.getField(Types.JAVA_LANG_LONG, "$longValue", (Object)long0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Float) {
            Float float0 = (Float)conc_ref;
            float conc_val = float0.floatValue();
            return this.env.heap.getField(Types.JAVA_LANG_FLOAT, "$floatValue", (Object)float0, (ReferenceExpression)symb_ref, conc_val);
        }
        if (conc_ref instanceof Double) {
            Double double0 = (Double)conc_ref;
            double conc_val = double0;
            return this.env.heap.getField(Types.JAVA_LANG_FLOAT, "$doubleValue", (Object)double0, (ReferenceExpression)symb_ref, conc_val);
        }
        throw new EvosuiteError("Unreachable code!");
    }

    private static boolean isWrapper(Object res) {
        return res instanceof Boolean || res instanceof Short || res instanceof Byte || res instanceof Integer || res instanceof Character || res instanceof Long || res instanceof Float || res instanceof Double;
    }

    private void after(StringPrimitiveStatement statement, Scope scope) {
        String string_instance;
        String valueOf = (String)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        StringVariable stringVariable = this.buildStringVariable(varRefName, valueOf);
        this.symb_expressions.put(varRefName, stringVariable);
        try {
            string_instance = (String)varRef.getObject(scope);
            scope.setObject(varRef, string_instance);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant stringRef = this.newStringReference(string_instance, stringVariable);
        this.symb_references.put(varRefName, stringRef);
    }

    private void after(FileNamePrimitiveStatement statement, Scope scope) {
        ReferenceExpression fileRef;
        EvoSuiteFile conc_evosuite_file = (EvoSuiteFile)statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        if (conc_evosuite_file == null) {
            fileRef = this.env.heap.getReference(null);
            if (fileRef.getConcreteValue() != null) {
                throw new IllegalStateException("Expected null concrete object");
            }
        } else {
            fileRef = this.env.heap.getReference(conc_evosuite_file);
            if (fileRef.getConcreteValue() == null) {
                throw new IllegalStateException("Expected non-null concrete object");
            }
        }
        this.symb_references.put(varRefName, fileRef);
    }

    private ReferenceConstant newStringReference(String conc_string, StringValue str_expr) {
        ReferenceConstant stringRef = (ReferenceConstant)this.env.heap.getReference(conc_string);
        this.env.heap.putField(Types.JAVA_LANG_STRING, "$stringValue", conc_string, stringRef, str_expr);
        return stringRef;
    }

    private void after(IntPrimitiveStatement statement, Scope scope) {
        Integer integer_instance;
        int valueOf = statement.getValue();
        VariableReference varRef = statement.getReturnValue();
        String varRefName = varRef.getName();
        IntegerVariable integerVariable = this.buildIntegerVariable(varRefName, valueOf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.symb_expressions.put(varRefName, integerVariable);
        try {
            integer_instance = (Integer)varRef.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new EvosuiteError(e);
        }
        ReferenceConstant integerRef = this.newIntegerReference(integer_instance, integerVariable);
        this.symb_references.put(varRefName, integerRef);
    }

    private ReferenceConstant newIntegerReference(Integer conc_integer, IntegerValue symb_value) {
        ReferenceConstant integerRef = (ReferenceConstant)this.env.heap.getReference(conc_integer);
        this.env.heap.putField(Types.JAVA_LANG_INTEGER, "$intValue", conc_integer, integerRef, symb_value);
        return integerRef;
    }

    @Override
    public void clear() {
        this.symb_expressions.clear();
        this.symb_references.clear();
    }

    private IntegerVariable buildIntegerVariable(String name, long conV, long minValue, long maxValue) {
        IntegerVariable integerVariable;
        if (this.integerVariables.containsKey(name)) {
            integerVariable = this.integerVariables.get(name);
            integerVariable.setConcreteValue(conV);
            assert (minValue == integerVariable.getMinValue());
            assert (maxValue == integerVariable.getMaxValue());
        } else {
            integerVariable = new IntegerVariable(name, conV, minValue, maxValue);
            this.integerVariables.put(name, integerVariable);
        }
        return integerVariable;
    }

    private RealVariable buildRealVariable(String name, double conV, double minValue, double maxValue) {
        RealVariable realVariable;
        if (this.realVariables.containsKey(name)) {
            realVariable = this.realVariables.get(name);
            realVariable.setConcreteValue(conV);
            assert (minValue == realVariable.getMinValue());
            assert (maxValue == realVariable.getMaxValue());
        } else {
            realVariable = new RealVariable(name, conV, minValue, maxValue);
            this.realVariables.put(name, realVariable);
        }
        return realVariable;
    }

    private StringVariable buildStringVariable(String name, String concVal) {
        StringVariable stringVariable;
        if (this.stringVariables.containsKey(name)) {
            stringVariable = this.stringVariables.get(name);
            stringVariable.setConcreteValue(concVal);
        } else {
            stringVariable = new StringVariable(name, concVal);
            this.stringVariables.put(name, stringVariable);
        }
        return stringVariable;
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }

    private static class ReferenceExpressionPair {
        private final ReferenceExpression ref;
        private final Expression<?> expr;

        public ReferenceExpressionPair(ReferenceExpression ref, Expression<?> expr) {
            this.ref = ref;
            this.expr = expr;
        }

        public ReferenceExpression getReference() {
            return this.ref;
        }

        public Expression<?> getExpression() {
            return this.expr;
        }
    }
}

