/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.ExpressionEvaluator;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintEvaluator
implements ConstraintVisitor<Object, Void> {
    static Logger log = LoggerFactory.getLogger(ConstraintEvaluator.class);

    @Override
    public Object visit(IntegerConstraint n, Void arg) {
        ExpressionEvaluator visitor = new ExpressionEvaluator();
        long left = (Long)n.getLeftOperand().accept(visitor, null);
        long right = (Long)n.getRightOperand().accept(visitor, null);
        Comparator cmpr = n.getComparator();
        switch (cmpr) {
            case EQ: {
                return left == right;
            }
            case NE: {
                return left != right;
            }
            case LT: {
                return left < right;
            }
            case LE: {
                return left <= right;
            }
            case GT: {
                return left > right;
            }
            case GE: {
                return left >= right;
            }
        }
        throw new IllegalArgumentException("unimplemented comparator");
    }

    @Override
    public Object visit(RealConstraint n, Void arg) {
        ExpressionEvaluator visitor = new ExpressionEvaluator();
        double left = (Double)n.getLeftOperand().accept(visitor, null);
        double right = (Double)n.getRightOperand().accept(visitor, null);
        Comparator cmpr = n.getComparator();
        switch (cmpr) {
            case EQ: {
                return left == right;
            }
            case NE: {
                return left != right;
            }
            case LT: {
                return left < right;
            }
            case LE: {
                return left <= right;
            }
            case GT: {
                return left > right;
            }
            case GE: {
                return left >= right;
            }
        }
        throw new IllegalArgumentException("unimplemented comparator");
    }

    @Override
    public Object visit(StringConstraint n, Void arg) {
        ExpressionEvaluator visitor = new ExpressionEvaluator();
        long left = (Long)n.getLeftOperand().accept(visitor, null);
        long right = (Long)n.getRightOperand().accept(visitor, null);
        Comparator cmpr = n.getComparator();
        switch (cmpr) {
            case EQ: {
                return left == right;
            }
            case NE: {
                return left != right;
            }
            case LT: {
                return left < right;
            }
            case LE: {
                return left <= right;
            }
            case GT: {
                return left > right;
            }
            case GE: {
                return left >= right;
            }
        }
        throw new IllegalArgumentException("unimplemented comparator");
    }
}

