/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import java.util.StringTokenizer;
import java.util.Vector;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionEvaluator;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerUnaryExpression;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.expr.bv.StringMultipleComparison;
import org.evosuite.symbolic.expr.bv.StringMultipleToIntegerExpression;
import org.evosuite.symbolic.expr.bv.StringUnaryToIntegerExpression;
import org.evosuite.symbolic.expr.reader.StringReaderExpr;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.expr.token.HasMoreTokensExpr;
import org.evosuite.symbolic.expr.token.TokenizerExpr;
import org.evosuite.utils.RegexDistanceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceCalculator
implements ConstraintVisitor<Object, Void> {
    static Logger log = LoggerFactory.getLogger(DistanceCalculator.class);

    @Override
    public Object visit(IntegerConstraint n, Void arg) {
        long rightVal;
        ExpressionEvaluator visitor = new ExpressionEvaluator();
        long leftVal = (Long)n.getLeftOperand().accept(visitor, null);
        long distance = DistanceCalculator.getDistanceIndexOfCFound(n, leftVal, rightVal = ((Long)n.getRightOperand().accept(visitor, null)).longValue());
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceIndexOfCIFound(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceIndexOfCEqualsK(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceIndexOfCIEqualsK(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceRegex(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceStringReaderLength(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        distance = DistanceCalculator.getDistanceStringIsInteger(n, leftVal, rightVal);
        if (distance != -1L) {
            return distance;
        }
        Comparator cmpr = n.getComparator();
        log.debug("Calculating distance for " + leftVal + " " + (Object)((Object)cmpr) + " " + rightVal);
        distance = leftVal - rightVal;
        switch (cmpr) {
            case EQ: {
                return Math.abs(distance);
            }
            case NE: {
                return distance != 0L ? 0L : 1L;
            }
            case LT: {
                return distance < 0L ? 0L : distance + 1L;
            }
            case LE: {
                return distance <= 0L ? 0L : distance;
            }
            case GT: {
                return distance > 0L ? 0L : Math.abs(distance) + 1L;
            }
            case GE: {
                return distance >= 0L ? 0L : Math.abs(distance);
            }
        }
        log.warn("getIntegerDist: unimplemented comparator");
        return Long.MAX_VALUE;
    }

    private static long getDistanceStringIsInteger(IntegerConstraint n, long leftVal, long rightVal) {
        if (n.getLeftOperand() instanceof StringUnaryToIntegerExpression && n.getComparator() == Comparator.NE && n.getRightOperand() instanceof IntegerConstant) {
            IntegerConstant right_constant = (IntegerConstant)n.getRightOperand();
            StringUnaryToIntegerExpression left_string_expr = (StringUnaryToIntegerExpression)n.getLeftOperand();
            if ((Long)right_constant.getConcreteValue() != 0L) {
                return -1L;
            }
            if (left_string_expr.getOperator() != Operator.IS_INTEGER) {
                return -1L;
            }
            String string = left_string_expr.getOperand().getConcreteValue();
            if (string.length() > 0) {
                char[] charArray = string.toCharArray();
                int maxDistance = 0;
                for (char c : charArray) {
                    int distance;
                    if (Character.isDigit(c)) continue;
                    if (c < '0') {
                        distance = 48 - c;
                    } else if (c > '9') {
                        distance = c - 57;
                    } else {
                        throw new RuntimeException("This branch is unreachable!");
                    }
                    if (maxDistance >= distance) continue;
                    maxDistance = distance;
                }
                return maxDistance;
            }
            return Long.MAX_VALUE;
        }
        return -1L;
    }

    @Override
    public Object visit(RealConstraint n, Void arg) {
        ExpressionEvaluator visitor = new ExpressionEvaluator();
        double left = (Double)n.getLeftOperand().accept(visitor, null);
        double right = (Double)n.getRightOperand().accept(visitor, null);
        Comparator cmpr = n.getComparator();
        switch (cmpr) {
            case EQ: {
                return Math.abs(left - right);
            }
            case NE: {
                return left - right != 0.0 ? 0.0 : 1.0;
            }
            case LT: {
                return left - right < 0.0 ? 0.0 : left - right + 1.0;
            }
            case LE: {
                return left - right <= 0.0 ? 0.0 : left - right;
            }
            case GT: {
                return left - right > 0.0 ? 0.0 : right - left + 1.0;
            }
            case GE: {
                return left - right >= 0.0 ? 0.0 : right - left;
            }
        }
        log.warn("getIntegerDist: unimplemented comparator");
        return Double.MAX_VALUE;
    }

    @Override
    public Object visit(StringConstraint n, Void arg) {
        Expression<?> exprLeft = n.getLeftOperand();
        Comparator cmpr = n.getComparator();
        double distance = 0.0;
        if (exprLeft instanceof StringBinaryComparison) {
            StringBinaryComparison scTarget = (StringBinaryComparison)exprLeft;
            distance = DistanceCalculator.getStringDistance(scTarget);
            log.debug("Calculating distance of constraint " + n);
        } else if (exprLeft instanceof StringMultipleComparison) {
            StringMultipleComparison scTarget = (StringMultipleComparison)exprLeft;
            distance = DistanceCalculator.getStringDistance(scTarget);
            log.debug("Calculating distance of constraint " + n);
        } else if (exprLeft instanceof HasMoreTokensExpr) {
            HasMoreTokensExpr hasMoreTokensExpr = (HasMoreTokensExpr)exprLeft;
            distance = DistanceCalculator.getStringDistance(hasMoreTokensExpr);
            log.debug("Calculating distance of constraint " + n);
        } else assert (false) : "Invalid string comparison";
        assert (((Long)n.getRightOperand().getConcreteValue()).intValue() == 0);
        if (cmpr == Comparator.NE) {
            return distance;
        }
        return distance > 0.0 ? 0.0 : Double.MAX_VALUE;
    }

    private static long getDistanceIndexOfCEqualsK(IntegerConstraint n, long leftVal, long rightVal) {
        if (n.getLeftOperand() instanceof StringBinaryToIntegerExpression && n.getComparator() == Comparator.EQ && n.getRightOperand() instanceof IntegerConstant) {
            IntegerConstant right_constant = (IntegerConstant)n.getRightOperand();
            StringBinaryToIntegerExpression left_string_expr = (StringBinaryToIntegerExpression)n.getLeftOperand();
            if (left_string_expr.getOperator() == Operator.INDEXOFC) {
                Expression<String> theSymbolicString = left_string_expr.getLeftOperand();
                Expression<?> theSymbolicChar = left_string_expr.getRightOperand();
                IntegerConstant theSymbolicIndex = right_constant;
                ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
                String theConcreteString = (String)theSymbolicString.accept(exprExecutor, null);
                Long theConcreteIndex = (Long)theSymbolicIndex.accept(exprExecutor, null);
                if (theConcreteIndex > (long)(theConcreteString.length() - 1)) {
                    return Long.MAX_VALUE;
                }
                if (theConcreteIndex != -1L) {
                    int theIndex = theConcreteIndex.intValue();
                    char theConcreteChar = (char)((Long)theSymbolicChar.accept(exprExecutor, null)).longValue();
                    char theCurrentChar = theConcreteString.charAt(theIndex);
                    return Math.abs(theCurrentChar - theConcreteChar);
                }
            }
        }
        return -1L;
    }

    private static long getDistanceRegex(IntegerConstraint n, long leftVal, long rightVal) {
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        if (n.getLeftOperand() instanceof IntegerUnaryExpression) {
            if (((IntegerUnaryExpression)n.getLeftOperand()).getOperator() == Operator.ISDIGIT) {
                Long leftObject = (Long)((IntegerUnaryExpression)n.getLeftOperand()).getOperand().accept(exprExecutor, null);
                long left_operand = leftObject;
                char theChar = (char)left_operand;
                if (n.getComparator() == Comparator.EQ && rightVal == 1L || n.getComparator() == Comparator.NE && rightVal == 0L) {
                    if (theChar < '0') {
                        return 48 - theChar;
                    }
                    if (theChar > '9') {
                        return theChar - 57;
                    }
                    return 0L;
                }
                if (n.getComparator() == Comparator.EQ && rightVal == 0L || n.getComparator() == Comparator.NE && rightVal == 1L) {
                    if (theChar < '0' || theChar > '9') {
                        return 0L;
                    }
                    return Math.min(Math.abs(57 - theChar), Math.abs(theChar - 48));
                }
            } else if (((IntegerUnaryExpression)n.getLeftOperand()).getOperator() == Operator.ISLETTER) {
                Long leftObject = (Long)((IntegerUnaryExpression)n.getLeftOperand()).getOperand().accept(exprExecutor, null);
                long left_operand = leftObject;
                char theChar = (char)left_operand;
                if (n.getComparator() == Comparator.EQ && rightVal == 1L || n.getComparator() == Comparator.NE && rightVal == 0L) {
                    if (theChar < 'A') {
                        return 65 - theChar;
                    }
                    if (theChar > 'z') {
                        return theChar - 122;
                    }
                    return 0L;
                }
                if (n.getComparator() == Comparator.EQ && rightVal == 0L || n.getComparator() == Comparator.NE && rightVal == 1L) {
                    if (theChar < 'A' || theChar > 'z') {
                        return 0L;
                    }
                    return Math.min(Math.abs(122 - theChar), Math.abs(theChar - 65));
                }
            }
        }
        return -1L;
    }

    private static long getDistanceIndexOfCFound(IntegerConstraint n, long leftVal, long rightVal) {
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        if (n.getLeftOperand() instanceof StringBinaryToIntegerExpression && n.getComparator() == Comparator.NE && n.getRightOperand() instanceof IntegerConstant) {
            IntegerConstant right_constant = (IntegerConstant)n.getRightOperand();
            StringBinaryToIntegerExpression left_string_expr = (StringBinaryToIntegerExpression)n.getLeftOperand();
            if (left_string_expr.getOperator() == Operator.INDEXOFC && (Long)right_constant.getConcreteValue() == -1L) {
                Expression<String> theSymbolicString = left_string_expr.getLeftOperand();
                Expression<?> theSymbolicChar = left_string_expr.getRightOperand();
                String theConcreteString = (String)theSymbolicString.accept(exprExecutor, null);
                if (theConcreteString.length() == 0) {
                    return Long.MAX_VALUE;
                }
                char theConcreteChar = (char)((Long)theSymbolicChar.accept(exprExecutor, null)).longValue();
                char[] charArray = theConcreteString.toCharArray();
                int min_distance_to_char = Integer.MAX_VALUE;
                for (char c : charArray) {
                    if (Math.abs(c - theConcreteChar) >= min_distance_to_char) continue;
                    min_distance_to_char = Math.abs(c - theConcreteChar);
                }
                return min_distance_to_char;
            }
        }
        return -1L;
    }

    private static long getDistanceIndexOfCIEqualsK(IntegerConstraint n, long leftVal, long rightVal) {
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        if (n.getLeftOperand() instanceof StringMultipleToIntegerExpression && n.getComparator() == Comparator.EQ && n.getRightOperand() instanceof IntegerConstant) {
            IntegerConstant right_constant = (IntegerConstant)n.getRightOperand();
            StringMultipleToIntegerExpression left_string_expr = (StringMultipleToIntegerExpression)n.getLeftOperand();
            if (left_string_expr.getOperator() == Operator.INDEXOFCI) {
                Expression<String> theSymbolicString = left_string_expr.getLeftOperand();
                Expression<?> theSymbolicChar = left_string_expr.getRightOperand();
                IntegerConstant theSymbolicIndex = right_constant;
                Expression<?> theOffset = left_string_expr.getOther().get(0);
                Long theConcreteOffset = (Long)theOffset.accept(exprExecutor, null);
                String theConcreteString = (String)theSymbolicString.accept(exprExecutor, null);
                Long theConcreteIndex = (Long)theSymbolicIndex.accept(exprExecutor, null);
                if (theConcreteIndex > (long)theConcreteString.length() - theConcreteOffset - 1L) {
                    return Long.MAX_VALUE;
                }
                if (theConcreteIndex != -1L) {
                    int theIndex = theConcreteIndex.intValue();
                    char theConcreteChar = (char)((Long)theSymbolicChar.accept(exprExecutor, null)).longValue();
                    char theCurrentChar = theConcreteString.charAt(theIndex);
                    return Math.abs(theCurrentChar - theConcreteChar);
                }
            }
        }
        return -1L;
    }

    private static long getDistanceStringReaderLength(IntegerConstraint n, long leftVal, long rightVal) {
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        Expression<?> left = n.getLeftOperand();
        Expression<?> right = n.getRightOperand();
        if (left instanceof StringReaderExpr && right instanceof IntegerConstant) {
            StringReaderExpr stringReaderExpr = (StringReaderExpr)left;
            IntegerConstant intValue = (IntegerConstant)right;
            String conc_string = (String)stringReaderExpr.getString().accept(exprExecutor, null);
            int new_length = stringReaderExpr.getReaderPosition();
            int conc_string_length = conc_string.length();
            if ((Long)intValue.getConcreteValue() == 0L && n.getComparator().equals((Object)Comparator.LT)) {
                if (conc_string_length <= new_length) {
                    return 0L;
                }
                return conc_string_length - new_length;
            }
            if ((Long)intValue.getConcreteValue() == 0L && n.getComparator().equals((Object)Comparator.GE)) {
                if (conc_string_length > new_length) {
                    return 0L;
                }
                return new_length - conc_string_length + 1;
            }
            if ((Long)intValue.getConcreteValue() == -1L && (n.getComparator().equals((Object)Comparator.EQ) || n.getComparator().equals((Object)Comparator.NE))) {
                if (n.getComparator().equals((Object)Comparator.EQ)) {
                    if (conc_string_length <= new_length) {
                        return 0L;
                    }
                    return conc_string_length - new_length;
                }
                if (n.getComparator().equals((Object)Comparator.NE)) {
                    if (conc_string_length > new_length) {
                        return 0L;
                    }
                    return new_length - conc_string_length + 1;
                }
            }
        }
        return -1L;
    }

    private static long getDistanceIndexOfCIFound(IntegerConstraint n, long leftVal, long rightVal) {
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        if (n.getLeftOperand() instanceof StringMultipleToIntegerExpression && n.getComparator() == Comparator.NE && n.getRightOperand() instanceof IntegerConstant) {
            IntegerConstant right_constant = (IntegerConstant)n.getRightOperand();
            StringMultipleToIntegerExpression left_string_expr = (StringMultipleToIntegerExpression)n.getLeftOperand();
            if (left_string_expr.getOperator() == Operator.INDEXOFCI && (Long)right_constant.getConcreteValue() == -1L) {
                Expression<String> theSymbolicString = left_string_expr.getLeftOperand();
                Expression<?> theSymbolicChar = left_string_expr.getRightOperand();
                Expression<?> theOffset = left_string_expr.getOther().get(0);
                String theConcreteString = (String)theSymbolicString.accept(exprExecutor, null);
                Long theConcreteOffset = (Long)theOffset.accept(exprExecutor, null);
                if (theConcreteOffset > (long)(theConcreteString.length() - 1)) {
                    return Long.MAX_VALUE;
                }
                char theConcreteChar = (char)((Long)theSymbolicChar.accept(exprExecutor, null)).longValue();
                char[] charArray = theConcreteString.substring(theConcreteOffset.intValue(), theConcreteString.length()).toCharArray();
                int min_distance_to_char = Integer.MAX_VALUE;
                for (char c : charArray) {
                    if (Math.abs(c - theConcreteChar) >= min_distance_to_char) continue;
                    min_distance_to_char = Math.abs(c - theConcreteChar);
                }
                return min_distance_to_char;
            }
        }
        return -1L;
    }

    private static double getStringDistance(HasMoreTokensExpr hasMoreTokensExpr) {
        TokenizerExpr tokenizerExpr = hasMoreTokensExpr.getTokenizerExpr();
        StringValue string = tokenizerExpr.getString();
        StringValue delimiter = tokenizerExpr.getDelimiter();
        int nextTokenCount = tokenizerExpr.getNextTokenCount();
        ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
        String concreteString = (String)string.accept(exprExecutor, null);
        String concreteDelimiter = (String)delimiter.accept(exprExecutor, null);
        if (concreteString.length() < concreteDelimiter.length() * nextTokenCount) {
            return Double.MAX_VALUE;
        }
        StringTokenizer tokenizer = new StringTokenizer(concreteString, concreteDelimiter);
        Vector<String> tokens = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        if (tokens.size() > nextTokenCount) {
            return 0.0;
        }
        return DistanceCalculator.StrEquals("", concreteDelimiter);
    }

    private static double getStringDistance(StringBinaryComparison comparison) {
        try {
            ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
            String first = (String)comparison.getLeftOperand().accept(exprExecutor, null);
            String second = (String)comparison.getRightOperand().accept(exprExecutor, null);
            switch (comparison.getOperator()) {
                case EQUALSIGNORECASE: {
                    return DistanceCalculator.StrEqualsIgnoreCase(first, second);
                }
                case EQUALS: {
                    log.debug("Edit distance between " + first + " and " + second + " is: " + DistanceCalculator.StrEquals(first, second));
                    return DistanceCalculator.StrEquals(first, second);
                }
                case ENDSWITH: {
                    return DistanceCalculator.StrEndsWith(first, second);
                }
                case CONTAINS: {
                    return DistanceCalculator.StrContains(first, second);
                }
                case PATTERNMATCHES: {
                    return DistanceCalculator.RegexMatches(second, first);
                }
                case APACHE_ORO_PATTERN_MATCHES: {
                    return DistanceCalculator.RegexMatches(second, first);
                }
            }
            log.warn("StringComparison: unimplemented operator!" + (Object)((Object)comparison.getOperator()));
            return Double.MAX_VALUE;
        }
        catch (Exception e) {
            return Double.MAX_VALUE;
        }
    }

    private static double StrContains(String val, CharSequence subStr) {
        int val_length = val.length();
        int subStr_length = subStr.length();
        double min_dist = Double.MAX_VALUE;
        String sub = subStr.toString();
        if (subStr_length > val_length) {
            return DistanceCalculator.avmDistance(val, sub);
        }
        int diff = val_length - subStr_length;
        for (int i = 0; i < diff + 1; ++i) {
            double res = DistanceCalculator.StrEquals(val.substring(i, subStr_length + i), sub);
            if (!(res < min_dist)) continue;
            min_dist = res;
        }
        return min_dist;
    }

    private static double StrEndsWith(String value, String suffix) {
        int len = Math.min(suffix.length(), value.length());
        String val1 = value.substring(value.length() - len);
        return DistanceCalculator.StrEquals(val1, suffix);
    }

    private static double avmDistance(String s, String t) {
        double distance = Math.abs(s.length() - t.length());
        int max = Math.min(s.length(), t.length());
        for (int i = 0; i < max; ++i) {
            distance += Constraint.normalize(Math.abs(s.charAt(i) - t.charAt(i)));
        }
        return distance;
    }

    private static double getStringDistance(StringMultipleComparison comparison) {
        try {
            ExpressionEvaluator exprExecutor = new ExpressionEvaluator();
            String first = (String)comparison.getLeftOperand().accept(exprExecutor, null);
            String second = (String)comparison.getRightOperand().accept(exprExecutor, null);
            switch (comparison.getOperator()) {
                case STARTSWITH: {
                    long start = (Long)comparison.getOther().get(0).accept(exprExecutor, null);
                    return DistanceCalculator.StrStartsWith(first, second, (int)start);
                }
                case REGIONMATCHES: {
                    long frstStart = (Long)comparison.getOther().get(0).accept(exprExecutor, null);
                    long secStart = (Long)comparison.getOther().get(1).accept(exprExecutor, null);
                    long length = (Long)comparison.getOther().get(2).accept(exprExecutor, null);
                    long ignoreCase = (Long)comparison.getOther().get(3).accept(exprExecutor, null);
                    return DistanceCalculator.StrRegionMatches(first, (int)frstStart, second, (int)secStart, (int)length, ignoreCase != 0L);
                }
            }
            log.warn("StringComparison: unimplemented operator!" + (Object)((Object)comparison.getOperator()));
            return Double.MAX_VALUE;
        }
        catch (Exception e) {
            return Double.MAX_VALUE;
        }
    }

    private static double StrRegionMatches(String value, int thisStart, String string, int start, int length, boolean ignoreCase) {
        if (value == null || string == null) {
            throw new NullPointerException();
        }
        if (start < 0 || string.length() - start < length) {
            return length - string.length() + start;
        }
        if (thisStart < 0 || value.length() - thisStart < length) {
            return length - value.length() + thisStart;
        }
        if (length <= 0) {
            return 0.0;
        }
        String s1 = value;
        String s2 = string;
        if (ignoreCase) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
        }
        String substring1 = s1.substring(thisStart, thisStart + length);
        String substring2 = s2.substring(start, start + length);
        return DistanceCalculator.StrEquals(substring1, substring2);
    }

    private static double StrEqualsIgnoreCase(String first, String second) {
        return DistanceCalculator.StrEquals(first.toLowerCase(), second.toLowerCase());
    }

    private static double StrEquals(String first, Object second) {
        if (first.equals(second)) {
            return 0.0;
        }
        return DistanceCalculator.avmDistance(first, second.toString());
    }

    private static double StrStartsWith(String value, String prefix, int start) {
        int len = Math.min(prefix.length(), value.length());
        int end = start + len > value.length() ? value.length() : start + len;
        return DistanceCalculator.StrEquals(value.substring(start, end), prefix);
    }

    private static double RegexMatches(String val, String regex) {
        return RegexDistanceUtils.getDistanceTailoredForStringAVM(val, regex);
    }
}

