/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.bv;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.UnaryExpression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntegerUnaryExpression
extends AbstractExpression<Long>
implements IntegerValue,
UnaryExpression<Long> {
    private static final long serialVersionUID = 1966395070897274841L;
    protected static final Logger log = LoggerFactory.getLogger(IntegerUnaryExpression.class);
    private final Operator op;
    private final Expression<Long> expr;

    public IntegerUnaryExpression(Expression<Long> e, Operator op2, Long con) {
        super(con, 1 + e.getSize(), e.containsSymbolicVariable());
        this.expr = e;
        this.op = op2;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Expression<Long> getOperand() {
        return this.expr;
    }

    @Override
    public Operator getOperator() {
        return this.op;
    }

    public String toString() {
        return "(" + this.op.toString() + "(" + this.expr + "))";
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerUnaryExpression) {
            IntegerUnaryExpression v = (IntegerUnaryExpression)obj;
            return this.op.equals((Object)v.op) && this.expr.equals(v.expr);
        }
        return false;
    }

    public int hashCode() {
        return this.expr.hashCode() + this.op.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet(this.expr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.expr.getConstants();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

