/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.str;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Cast;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.str.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntegerToStringCast
extends AbstractExpression<String>
implements StringValue,
Cast<Long> {
    private static final long serialVersionUID = 2414222998301630838L;
    protected static Logger log = LoggerFactory.getLogger(IntegerToStringCast.class);
    private final Expression<Long> expr;

    public IntegerToStringCast(Expression<Long> expr, String concV) {
        super(concV, 1 + expr.getSize(), expr.containsSymbolicVariable());
        this.expr = expr;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    public String toString() {
        return "((String)" + this.expr + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntegerToStringCast) {
            IntegerToStringCast other = (IntegerToStringCast)obj;
            return this.expr.equals(other.expr);
        }
        return false;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    public Expression<Long> getArgument() {
        return this.expr;
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet(this.expr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.expr.getConstants();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

