/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.str;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.MultipleExpression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.str.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringMultipleExpression
extends AbstractExpression<String>
implements StringValue,
MultipleExpression<String> {
    private static final long serialVersionUID = 7172041118401792672L;
    private final ArrayList<Expression<?>> other_v;
    private final Operator op;
    private final Expression<String> left;
    private final Expression<?> right;
    protected static final Logger log = LoggerFactory.getLogger(StringMultipleExpression.class);

    public StringMultipleExpression(Expression<String> _left, Operator _op, Expression<?> _right, ArrayList<Expression<?>> _other, String con) {
        super(con, 1 + _left.getSize() + _right.getSize() + StringMultipleExpression.countSizes(_other), _left.containsSymbolicVariable() || _right.containsSymbolicVariable() || StringMultipleExpression.containsSymbolicVariable(_other));
        this.op = _op;
        this.left = _left;
        this.right = _right;
        this.other_v = _other;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public ArrayList<Expression<?>> getOther() {
        return this.other_v;
    }

    @Override
    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Expression<String> getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression<?> getRightOperand() {
        return this.right;
    }

    public String toString() {
        String str_other_v = "";
        for (Expression<?> expression : this.other_v) {
            str_other_v = str_other_v + " " + expression.toString();
        }
        return "(" + this.left + this.op.toString() + (this.right == null ? "" : this.right) + str_other_v + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringMultipleExpression) {
            StringMultipleExpression other = (StringMultipleExpression)obj;
            return this.op.equals((Object)other.op) && this.left.equals(other.left) && this.right.equals(other.right) && this.other_v.equals(other.other_v);
        }
        return false;
    }

    public int hashCode() {
        return this.op.hashCode() + this.left.hashCode() + this.right.hashCode() + this.other_v.hashCode();
    }

    private static boolean containsSymbolicVariable(ArrayList<Expression<?>> list) {
        for (Expression<?> e : list) {
            if (!e.containsSymbolicVariable()) continue;
            return true;
        }
        return false;
    }

    private static int countSizes(ArrayList<Expression<?>> list) {
        int retVal = 0;
        for (Expression<?> e : list) {
            retVal += e.getSize();
        }
        return retVal;
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.left.getVariables());
        variables.addAll(this.right.getVariables());
        for (Expression<?> other_e : this.other_v) {
            variables.addAll(other_e.getVariables());
        }
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.left.getConstants());
        result.addAll(this.right.getConstants());
        for (Expression<?> other_e : this.other_v) {
            result.addAll(other_e.getConstants());
        }
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

