/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.token;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.token.TokenizerExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HasMoreTokensExpr
extends AbstractExpression<Long>
implements StringComparison {
    private static final long serialVersionUID = 2154812241163764621L;
    protected static Logger log = LoggerFactory.getLogger(HasMoreTokensExpr.class);
    private final TokenizerExpr tokenizerExpr;

    public HasMoreTokensExpr(TokenizerExpr tokenizerExpr, Long con) {
        super(con, 1 + tokenizerExpr.getSize(), tokenizerExpr.containsSymbolicVariable());
        this.tokenizerExpr = tokenizerExpr;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HasMoreTokensExpr) {
            HasMoreTokensExpr other = (HasMoreTokensExpr)obj;
            return this.tokenizerExpr.equals(other.tokenizerExpr);
        }
        return false;
    }

    public int hashCode() {
        return this.tokenizerExpr.hashCode();
    }

    public String toString() {
        return "hasMoreTokens(" + this.tokenizerExpr.toString() + ")";
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet(this.tokenizerExpr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.tokenizerExpr.getConstants();
    }

    public TokenizerExpr getTokenizerExpr() {
        return this.tokenizerExpr;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

