/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.instrument;

import org.evosuite.Properties;
import org.evosuite.instrumentation.EndOfClassInitializerVisitor;
import org.evosuite.instrumentation.StaticAccessClassAdapter;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.instrumentation.CreateClassResetClassAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.ClassWriter;
import org.evosuite.symbolic.instrument.ConcolicClassAdapter;

public class ConcolicBytecodeInstrumentation {
    public byte[] transformBytes(String className, ClassReader reader) {
        ClassWriter writer;
        int readFlags = 4;
        ClassVisitor cv = writer = new ClassWriter(2);
        if (Properties.RESET_STATIC_FIELDS) {
            cv = new StaticAccessClassAdapter(cv, className);
        }
        cv = new ConcolicClassAdapter(cv, className);
        if (Properties.RESET_STATIC_FIELDS) {
            CreateClassResetClassAdapter resetClassAdapter = new CreateClassResetClassAdapter(cv, className, Properties.RESET_STATIC_FINAL_FIELDS);
            cv = resetClassAdapter;
            cv = new EndOfClassInitializerVisitor(cv, className);
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            cv = new MethodCallReplacementClassAdapter(cv, className);
        }
        reader.accept(cv, readFlags);
        return writer.toByteArray();
    }
}

