/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.instrument;

import org.evosuite.dse.util.Assertions;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.instrument.ConcolicConfig;

final class OperandStack {
    private final MethodVisitor mv;
    private static final String CALLER_STACK_PARAM = "CALLER_STACK_PARAM";
    private static final Type TYPE_OBJECT = Type.getObjectType("java/lang/Object");

    OperandStack(MethodVisitor mv) {
        this.mv = mv;
    }

    private String desc(Type returnType, Type ... argumentTypes) {
        StringBuffer desc = new StringBuffer();
        desc.append("(");
        for (Type type : argumentTypes) {
            desc.append(type.getDescriptor());
        }
        desc.append(")");
        desc.append(returnType.getDescriptor());
        return desc.toString();
    }

    void pushInt(int i) {
        switch (i) {
            case -1: {
                this.mv.visitInsn(2);
                return;
            }
            case 0: {
                this.mv.visitInsn(3);
                return;
            }
            case 1: {
                this.mv.visitInsn(4);
                return;
            }
            case 2: {
                this.mv.visitInsn(5);
                return;
            }
            case 3: {
                this.mv.visitInsn(6);
                return;
            }
            case 4: {
                this.mv.visitInsn(7);
                return;
            }
            case 5: {
                this.mv.visitInsn(8);
                return;
            }
        }
        if (i >= -128 && i <= 127) {
            this.mv.visitIntInsn(16, i);
            return;
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, i);
            return;
        }
        this.mv.visitLdcInsn(i);
    }

    void pushStrings(String a, String b, String c) {
        this.mv.visitLdcInsn(a);
        this.mv.visitLdcInsn(b);
        this.mv.visitLdcInsn(c);
    }

    void b1a1__b1a1b1() {
        this.mv.visitInsn(95);
        this.mv.visitInsn(90);
    }

    void b1a2__b1a2b1() {
        this.mv.visitInsn(93);
        this.mv.visitInsn(88);
        this.mv.visitInsn(91);
    }

    void b2a1__b2a1b2() {
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitInsn(93);
    }

    void b2a2__b2a2b2() {
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
        this.mv.visitInsn(94);
    }

    void c1b1a1__c1b1a1c1() {
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitInsn(91);
    }

    void c1b1a2__c1b1a2c1() {
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
        this.mv.visitInsn(94);
        this.mv.visitInsn(87);
    }

    void c1b2a1__c1b2a1c1() {
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
        this.mv.visitInsn(94);
        this.mv.visitInsn(87);
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
    }

    void passCallerStackParam(Type argType, int paramNr, int calleeLocalsIndex) {
        Type type = argType;
        if (type.getSort() == 10 || type.getSort() == 9) {
            type = TYPE_OBJECT;
        }
        this.pushInt(paramNr);
        this.pushInt(calleeLocalsIndex);
        String signature = this.desc(Type.VOID_TYPE, type, Type.INT_TYPE, Type.INT_TYPE);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, CALLER_STACK_PARAM, signature, false);
    }

    void passCallerStackParams(Type[] argTypes, boolean needThis) {
        int paramNr;
        if (argTypes == null || argTypes.length == 0) {
            return;
        }
        int calleeLocalsIndex = 0;
        for (Type type : argTypes) {
            calleeLocalsIndex += type.getSize();
        }
        if (needThis) {
            ++calleeLocalsIndex;
        }
        if (argTypes[paramNr = argTypes.length - 1].getSize() == 1) {
            this.mv.visitInsn(89);
            this.passCallerStackParam(argTypes[paramNr], paramNr, --calleeLocalsIndex);
            if (argTypes.length == 1) {
                return;
            }
            if (argTypes[--paramNr].getSize() == 1) {
                this.b1a1__b1a1b1();
                this.passCallerStackParam(argTypes[paramNr], paramNr, --calleeLocalsIndex);
            } else if (argTypes[paramNr].getSize() == 2) {
                this.b2a1__b2a1b2();
                this.passCallerStackParam(argTypes[paramNr], paramNr, calleeLocalsIndex -= 2);
            } else {
                Assertions.check(false);
            }
        } else if (argTypes[paramNr].getSize() == 2) {
            this.mv.visitInsn(92);
            this.passCallerStackParam(argTypes[paramNr], paramNr, calleeLocalsIndex -= 2);
            if (argTypes.length == 1) {
                return;
            }
            if (argTypes[--paramNr].getSize() == 1) {
                this.b1a2__b1a2b1();
                this.passCallerStackParam(argTypes[paramNr], paramNr, --calleeLocalsIndex);
            } else if (argTypes[paramNr].getSize() == 2) {
                this.b2a2__b2a2b2();
                this.passCallerStackParam(argTypes[paramNr], paramNr, calleeLocalsIndex -= 2);
            } else {
                Assertions.check(false);
            }
        } else {
            Assertions.check(false);
        }
    }
}

