/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.evosuite.shaded.org.apache.commons.exec.ExecuteException;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.utils.ProcessLauncher;
import org.evosuite.utils.ProcessTimeoutException;

public abstract class SmtSolver
extends Solver {
    public SmtSolver(boolean addMissingVariables) {
        super(addMissingVariables);
    }

    public SmtSolver() {
    }

    protected static void launchNewSolvingProcess(String solverCmd, String smtQueryStr, int hardTimeout, OutputStream stdout) throws IOException, SolverTimeoutException, SolverErrorException {
        ByteArrayInputStream input = new ByteArrayInputStream(smtQueryStr.getBytes());
        ProcessLauncher launcher = new ProcessLauncher(stdout, input);
        long solver_start_time_millis = System.currentTimeMillis();
        try {
            int exit_code = launcher.launchNewProcess(solverCmd, hardTimeout);
            if (exit_code == 0) {
                logger.debug("Solver execution finished normally");
                return;
            }
            try {
                String errMsg = String.format("Solver execution finished abnormally with exit code {}", exit_code);
                logger.debug(errMsg);
                throw new SolverErrorException(errMsg);
            }
            catch (ExecuteException ex) {
                logger.debug("Solver subprocesses failed");
                throw new SolverErrorException("Solver subprocesses failed");
            }
            catch (ProcessTimeoutException ex) {
                logger.debug("Solver stopped due to solver timeout");
                throw new SolverTimeoutException();
            }
        }
        finally {
            long solver_end_time_millis = System.currentTimeMillis();
            long solver_duration_secs = (solver_end_time_millis - solver_start_time_millis) / 1000L;
            logger.debug("Solver execution time was {}s", (Object)solver_duration_secs);
        }
    }
}

