/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.IntegerAVM;
import org.evosuite.symbolic.solver.avm.RealAVM;
import org.evosuite.symbolic.solver.avm.StringAVM;
import org.evosuite.symbolic.solver.avm.VariableAVM;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvoSuiteSolver
extends Solver {
    static Logger log = LoggerFactory.getLogger(EvoSuiteSolver.class);

    @Override
    public SolverResult solve(Collection<Constraint<?>> constraints) throws SolverTimeoutException, SolverEmptyQueryException {
        long timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        long startTimeMillis = System.currentTimeMillis();
        Set<Variable<?>> variables = EvoSuiteSolver.getVariables(constraints);
        Map<String, Object> initialValues = EvoSuiteSolver.getConcreteValues(variables);
        double distance = DistanceEstimator.getDistance(constraints);
        if (distance == 0.0) {
            log.info("Initial distance already is 0.0, skipping search");
            SolverResult satResult = SolverResult.newSAT(initialValues);
            return satResult;
        }
        for (int attempt = 0; attempt <= Properties.DSE_VARIABLE_RESETS; ++attempt) {
            for (Variable<?> v : variables) {
                VariableAVM avm;
                long currentTimeMillis = System.currentTimeMillis();
                long elapsed_solving_time = currentTimeMillis - startTimeMillis;
                if (elapsed_solving_time > timeout) {
                    throw new SolverTimeoutException();
                }
                log.debug("Variable: " + v + ", " + variables);
                if (v instanceof IntegerVariable) {
                    IntegerVariable integerVariable = (IntegerVariable)v;
                    avm = new IntegerAVM(integerVariable, constraints, startTimeMillis, timeout);
                    ((IntegerAVM)avm).applyAVM();
                } else if (v instanceof RealVariable) {
                    RealVariable realVariable = (RealVariable)v;
                    avm = new RealAVM(realVariable, constraints, startTimeMillis, timeout);
                    ((RealAVM)avm).applyAVM();
                } else if (v instanceof StringVariable) {
                    StringVariable strVariable = (StringVariable)v;
                    avm = new StringAVM(strVariable, constraints, startTimeMillis, timeout);
                    ((StringAVM)avm).applyAVM();
                } else {
                    throw new RuntimeException("Unknown variable type " + v.getClass().getName());
                }
                if (!((distance = DistanceEstimator.getDistance(constraints)) <= 0.0)) continue;
                log.info("Distance is 0, ending search");
                break;
            }
            if (distance <= 0.0) {
                log.info("Distance is 0, ending search");
                break;
            }
            log.info("Randomizing variables");
            EvoSuiteSolver.randomizeValues(variables, EvoSuiteSolver.getConstants(constraints));
        }
        if (distance <= 0.0) {
            log.debug("Distance is " + distance + ", found solution");
            Map<String, Object> new_model = EvoSuiteSolver.getConcreteValues(variables);
            EvoSuiteSolver.setConcreteValues(variables, initialValues);
            SolverResult satResult = SolverResult.newSAT(new_model);
            return satResult;
        }
        EvoSuiteSolver.setConcreteValues(variables, initialValues);
        log.debug("Returning unknown, search was not successful");
        SolverResult unknownResult = SolverResult.newUnknown();
        return unknownResult;
    }

    private static void randomizeValues(Set<Variable<?>> variables, Set<Object> constants) {
        HashSet<String> stringConstants = new HashSet<String>();
        HashSet<Long> longConstants = new HashSet<Long>();
        HashSet<Double> realConstants = new HashSet<Double>();
        for (Object object : constants) {
            if (object instanceof String) {
                stringConstants.add((String)object);
                continue;
            }
            if (object instanceof Double) {
                realConstants.add((Double)object);
                continue;
            }
            if (object instanceof Long) {
                longConstants.add((Long)object);
                continue;
            }
            assert (false) : "Unexpected constant type: " + object;
        }
        for (Variable variable : variables) {
            if (variable instanceof StringVariable) {
                StringVariable sv = (StringVariable)variable;
                if (!stringConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                    sv.setConcreteValue((String)Randomness.choice(stringConstants));
                    continue;
                }
                sv.setConcreteValue(Randomness.nextString(Properties.STRING_LENGTH));
                continue;
            }
            if (variable instanceof IntegerVariable) {
                IntegerVariable iv = (IntegerVariable)variable;
                if (!longConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                    iv.setConcreteValue((Long)Randomness.choice(longConstants));
                    continue;
                }
                iv.setConcreteValue((long)Randomness.nextInt(Properties.MAX_INT * 2) - (long)Properties.MAX_INT);
                continue;
            }
            if (!(variable instanceof RealVariable)) continue;
            RealVariable rv = (RealVariable)variable;
            if (!realConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                rv.setConcreteValue((Double)Randomness.choice(realConstants));
                continue;
            }
            rv.setConcreteValue((long)Randomness.nextInt(Properties.MAX_INT * 2) - (long)Properties.MAX_INT);
        }
    }

    private static Set<Object> getConstants(Collection<Constraint<?>> constraints) {
        HashSet<Object> constants = new HashSet<Object>();
        for (Constraint<?> c : constraints) {
            constants.addAll(c.getConstants());
        }
        return constants;
    }
}

