/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.SmtSolver;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.cvc4.ConstraintToCVC4Visitor;
import org.evosuite.symbolic.solver.cvc4.NonLinearConstraintVisitor;
import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtFunctionDeclaration;
import org.evosuite.symbolic.solver.smt.SmtFunctionDefinition;
import org.evosuite.symbolic.solver.smt.SmtIntVariable;
import org.evosuite.symbolic.solver.smt.SmtModelParser;
import org.evosuite.symbolic.solver.smt.SmtOperation;
import org.evosuite.symbolic.solver.smt.SmtOperatorCollector;
import org.evosuite.symbolic.solver.smt.SmtQuery;
import org.evosuite.symbolic.solver.smt.SmtQueryPrinter;
import org.evosuite.symbolic.solver.smt.SmtRealVariable;
import org.evosuite.symbolic.solver.smt.SmtStringVariable;
import org.evosuite.symbolic.solver.smt.SmtVariable;
import org.evosuite.symbolic.solver.smt.SmtVariableCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CVC4Solver
extends SmtSolver {
    private boolean reWriteNonLinearConstraints = false;
    static Logger logger = LoggerFactory.getLogger(CVC4Solver.class);
    private static final String CVC4_LOGIC = "QF_ALL_SUPPORTED";
    private static final int ASCII_TABLE_LENGTH = 256;

    public void setRewriteNonLinearConstraints(boolean rewrite) {
        this.reWriteNonLinearConstraints = rewrite;
    }

    public CVC4Solver(boolean addMissingValues) {
        super(addMissingValues);
    }

    public CVC4Solver() {
    }

    @Override
    public SolverResult solve(Collection<Constraint<?>> constraints) throws SolverTimeoutException, SolverEmptyQueryException, SolverErrorException, SolverParseException, IOException {
        if (Properties.CVC4_PATH == null) {
            String errMsg = "Property CVC4_PATH should be setted in order to use the CVC4 Solver!";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (!this.reWriteNonLinearConstraints && CVC4Solver.hasNonLinearConstraints(constraints)) {
            logger.debug("Skipping query due to (unsupported) non-linear constraints");
            throw new SolverEmptyQueryException("Skipping query due to (unsupported) non-linear constraints");
        }
        long cvcTimeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        HashSet variables = new HashSet();
        for (Constraint<?> c : constraints) {
            Set<Variable<?>> c_variables = c.getVariables();
            variables.addAll(c_variables);
        }
        SmtQuery query = CVC4Solver.buildSmtQuery(constraints);
        if (query.getFunctionDeclarations().isEmpty()) {
            logger.debug("No variables found during the creation of the SMT query.");
            throw new SolverEmptyQueryException("No variables found during the creation of the SMT query.");
        }
        if (query.getAssertions().isEmpty()) {
            HashMap<String, Object> emptySolution = new HashMap<String, Object>();
            SolverResult emptySAT = SolverResult.newSAT(emptySolution);
            return emptySAT;
        }
        SmtQueryPrinter printer = new SmtQueryPrinter();
        String smtQueryStr = printer.print(query);
        if (smtQueryStr == null) {
            logger.debug("No variables found during constraint solving.");
            throw new SolverEmptyQueryException("No variables found during constraint solving.");
        }
        logger.debug("CVC4 Query:");
        logger.debug(smtQueryStr);
        String cmd = CVC4Solver.buildCVC4cmd(cvcTimeout);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        try {
            boolean check;
            CVC4Solver.launchNewSolvingProcess(cmd, smtQueryStr, (int)cvcTimeout, stdout);
            String output = stdout.toString("UTF-8");
            if (output.startsWith("unknown")) {
                logger.debug("timeout reached when using cvc4");
                throw new SolverTimeoutException();
            }
            if (output.startsWith("unsat") && output.contains("(error \"Cannot get the current model unless immediately preceded by SAT/INVALID or UNKNOWN response.\")")) {
                SolverResult unsatResult = SolverResult.newUNSAT();
                return unsatResult;
            }
            if (output.contains("error")) {
                String errMsg = "An error occurred while executing CVC4!";
                logger.error(errMsg);
                throw new SolverErrorException(errMsg);
            }
            Map<String, Object> initialValues = CVC4Solver.getConcreteValues(variables);
            SmtModelParser resultParser = this.addMissingVariables() ? new SmtModelParser(initialValues) : new SmtModelParser();
            SolverResult solverResult = resultParser.parse(output);
            if (solverResult.isSAT() && !(check = CVC4Solver.checkSAT(constraints, solverResult))) {
                logger.debug("CVC4 solution does not solve the original constraint system. ");
                SolverResult unsatResult = SolverResult.newUNSAT();
                return unsatResult;
            }
            return solverResult;
        }
        catch (IOException e) {
            if (e.getMessage().contains("Permission denied")) {
                logger.error("No permissions for running CVC4 binary");
            } else {
                logger.error("IO Exception during launching of CVC4 command");
            }
            throw e;
        }
    }

    private static SmtQuery buildSmtQuery(Collection<Constraint<?>> constraints) {
        boolean addIntToChar;
        SmtQuery query = new SmtQuery();
        query.setLogic(CVC4_LOGIC);
        query.addOption(":produce-models", "true");
        query.addOption(":strings-exp", "true");
        ConstraintToCVC4Visitor v = new ConstraintToCVC4Visitor(true);
        SmtVariableCollector varCollector = new SmtVariableCollector();
        SmtOperatorCollector funCollector = new SmtOperatorCollector();
        for (Constraint<?> c : constraints) {
            SmtExpr smtExpr = c.accept(v, null);
            if (smtExpr == null) continue;
            SmtAssertion smtAssertion = new SmtAssertion(smtExpr);
            query.addAssertion(smtAssertion);
            smtExpr.accept(varCollector, null);
            smtExpr.accept(funCollector, null);
        }
        Set<SmtVariable> variables = varCollector.getSmtVariables();
        boolean addCharToInt = funCollector.getOperators().contains((Object)SmtOperation.Operator.CHAR_TO_INT);
        if (addCharToInt) {
            String charToIntFunction = CVC4Solver.buildCharToIntFunction();
            SmtFunctionDefinition funcDefinition = new SmtFunctionDefinition(charToIntFunction);
            query.addFunctionDefinition(funcDefinition);
        }
        if (addIntToChar = funCollector.getOperators().contains((Object)SmtOperation.Operator.INT_TO_CHAR)) {
            String intToCharFunction = CVC4Solver.buildIntToCharFunction();
            SmtFunctionDefinition funcDefinition = new SmtFunctionDefinition(intToCharFunction);
            query.addFunctionDefinition(funcDefinition);
        }
        for (SmtVariable var : variables) {
            String varName = var.getName();
            if (var instanceof SmtIntVariable) {
                SmtFunctionDeclaration intVar = SmtExprBuilder.mkIntFunctionDeclaration(varName);
                query.addFunctionDeclaration(intVar);
                continue;
            }
            if (var instanceof SmtRealVariable) {
                SmtFunctionDeclaration realVar = SmtExprBuilder.mkRealFunctionDeclaration(varName);
                query.addFunctionDeclaration(realVar);
                continue;
            }
            if (var instanceof SmtStringVariable) {
                SmtFunctionDeclaration stringVar = SmtExprBuilder.mkStringFunctionDeclaration(varName);
                query.addFunctionDeclaration(stringVar);
                continue;
            }
            throw new RuntimeException("Unknown variable type " + var.getClass().getCanonicalName());
        }
        return query;
    }

    private static String buildCVC4cmd(long cvcTimeout) {
        String cmd = Properties.CVC4_PATH;
        cmd = cmd + "  --rewrite-divk";
        cmd = cmd + " --lang smt";
        cmd = cmd + " --finite-model-find";
        cmd = cmd + " --tlimit=" + cvcTimeout;
        return cmd;
    }

    private static boolean hasNonLinearConstraints(Collection<Constraint<?>> constraints) {
        NonLinearConstraintVisitor v = new NonLinearConstraintVisitor();
        for (Constraint<?> constraint : constraints) {
            Boolean ret_val = constraint.accept(v, null);
            if (!ret_val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static String buildIntToCharFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)SmtOperation.Operator.INT_TO_CHAR) + "((!x Int)) String");
        buff.append("\n");
        for (i = 0; i < 256; ++i) {
            String hexStr = i < 16 ? "0" + Integer.toHexString(i) : Integer.toHexString(i);
            String escapedHexStr = "\\x" + hexStr;
            if (i < 255) {
                String iteStr = String.format("(ite (= !x %s) \"%s\"", i, escapedHexStr);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(String.format("\"%s\"", escapedHexStr));
        }
        for (i = 0; i < 255; ++i) {
            buff.append(")");
        }
        return buff.toString();
    }

    private static String buildCharToIntFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)SmtOperation.Operator.CHAR_TO_INT) + "((!x String)) Int");
        buff.append("\n");
        for (i = 0; i < 256; ++i) {
            String hexStr = i < 16 ? "0" + Integer.toHexString(i) : Integer.toHexString(i);
            String escapedHexStr = "\\x" + hexStr;
            if (i < 255) {
                String iteStr = String.format("(ite (= !x \"%s\") %s", escapedHexStr, i);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(i);
        }
        for (i = 0; i < 255; ++i) {
            buff.append(")");
        }
        return buff.toString();
    }
}

