/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.cvc4.ExprToCVC4Visitor;
import org.evosuite.symbolic.solver.smt.SmtExpr;

final class ConstraintToCVC4Visitor
implements ConstraintVisitor<SmtExpr, Void> {
    private final ExprToCVC4Visitor exprVisitor;

    public ConstraintToCVC4Visitor() {
        this(false);
    }

    private static SmtExpr translateCompareTo(Expression<?> left, Comparator cmp, Expression<?> right) {
        if (!(left instanceof StringBinaryToIntegerExpression)) {
            return null;
        }
        if (!(right instanceof IntegerConstant)) {
            return null;
        }
        if (cmp != Comparator.NE && cmp != Comparator.EQ) {
            return null;
        }
        StringBinaryToIntegerExpression leftExpr = (StringBinaryToIntegerExpression)left;
        if (leftExpr.getOperator() != Operator.COMPARETO) {
            return null;
        }
        IntegerConstant rightExpr = (IntegerConstant)right;
        if ((Long)rightExpr.getConcreteValue() != 0L) {
            return null;
        }
        ExprToCVC4Visitor v = new ExprToCVC4Visitor();
        SmtExpr leftEquals = leftExpr.getLeftOperand().accept(v, null);
        SmtExpr rightEquals = leftExpr.getRightOperand().accept(v, null);
        if (leftEquals == null || rightEquals == null) {
            return null;
        }
        SmtExpr eqExpr = SmtExprBuilder.mkEq(leftEquals, rightEquals);
        if (cmp == Comparator.EQ) {
            return eqExpr;
        }
        return SmtExprBuilder.mkNot(eqExpr);
    }

    public ConstraintToCVC4Visitor(boolean rewriteNonLinearConstraints) {
        this.exprVisitor = new ExprToCVC4Visitor(rewriteNonLinearConstraints);
    }

    @Override
    public SmtExpr visit(IntegerConstraint c, Void arg) {
        Expression<?> leftOperand = c.getLeftOperand();
        Expression<?> rightOperand = c.getRightOperand();
        Comparator cmp = c.getComparator();
        SmtExpr expr = ConstraintToCVC4Visitor.translateCompareTo(leftOperand, cmp, rightOperand);
        if (expr != null) {
            return expr;
        }
        return this.visit(leftOperand, cmp, rightOperand);
    }

    private SmtExpr visit(Expression<?> leftOperand, Comparator cmp, Expression<?> rightOperand) {
        SmtExpr left = leftOperand.accept(this.exprVisitor, null);
        SmtExpr right = rightOperand.accept(this.exprVisitor, null);
        if (left == null || right == null) {
            return null;
        }
        return ConstraintToCVC4Visitor.mkComparison(left, cmp, right);
    }

    @Override
    public SmtExpr visit(RealConstraint c, Void arg) {
        Expression<Double> leftOperand = c.getLeftOperand();
        Expression<Double> rightOperand = c.getRightOperand();
        Comparator cmp = c.getComparator();
        return this.visit(leftOperand, cmp, rightOperand);
    }

    @Override
    public SmtExpr visit(StringConstraint c, Void arg) {
        Expression<?> leftOperand = c.getLeftOperand();
        Expression<?> rightOperand = c.getRightOperand();
        Comparator cmp = c.getComparator();
        SmtExpr equalsExpr = ConstraintToCVC4Visitor.translateCompareTo(leftOperand, cmp, rightOperand);
        if (equalsExpr != null) {
            return equalsExpr;
        }
        return this.visit(leftOperand, cmp, rightOperand);
    }

    private static SmtExpr mkComparison(SmtExpr left, Comparator cmp, SmtExpr right) {
        switch (cmp) {
            case LT: {
                SmtExpr lt = SmtExprBuilder.mkLt(left, right);
                return lt;
            }
            case LE: {
                SmtExpr le = SmtExprBuilder.mkLe(left, right);
                return le;
            }
            case GT: {
                SmtExpr gt = SmtExprBuilder.mkGt(left, right);
                return gt;
            }
            case GE: {
                SmtExpr ge = SmtExprBuilder.mkGe(left, right);
                return ge;
            }
            case EQ: {
                SmtExpr ge = SmtExprBuilder.mkEq(left, right);
                return ge;
            }
            case NE: {
                SmtExpr ge = SmtExprBuilder.mkEq(left, right);
                SmtExpr ne = SmtExprBuilder.mkNot(ge);
                return ne;
            }
        }
        throw new RuntimeException("Unknown comparator for constraint " + cmp.toString());
    }
}

