/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.smt;

import java.util.Arrays;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtExprVisitor;

public final class SmtOperation
extends SmtExpr {
    private final Operator operator;
    private final SmtExpr[] arguments;
    private final boolean hasSymbolicValues;

    public SmtOperation(Operator op, SmtExpr ... arg) {
        this.operator = op;
        this.arguments = arg;
        this.hasSymbolicValues = SmtOperation.hasSymbolicValue(arg);
    }

    @Override
    public <K, V> K accept(SmtExprVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }

    public SmtExpr[] getArguments() {
        return this.arguments;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmtOperation other = (SmtOperation)obj;
        if (!Arrays.equals(this.arguments, other.arguments)) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    public boolean isSymbolic() {
        return this.hasSymbolicValues;
    }

    private static boolean hasSymbolicValue(SmtExpr[] arguments) {
        for (SmtExpr smtExpr : arguments) {
            if (!smtExpr.isSymbolic()) continue;
            return true;
        }
        return false;
    }

    public static enum Operator {
        MUL("*"),
        MINUS("-"),
        ADD("+"),
        MOD("mod"),
        INT2BV32("(_ int2bv 32)"),
        BVOR("bvor"),
        BV2Nat("bv2nat"),
        BVAND("bvand"),
        BVXOR("bvxor"),
        BV2INT("bv2int"),
        BVSHL("bvshl"),
        BVASHR("bvashr"),
        BVLSHR("bvlshr"),
        GT(">"),
        ITE("ite"),
        LT("<"),
        GE(">="),
        TO_INT("to_int"),
        TO_REAL("to_real"),
        DIV("div"),
        SLASH("/"),
        STR_SUBSTR("str.substr"),
        STR_REPLACE("str.replace"),
        STR_INDEXOF("str.indexof"),
        EQ("="),
        STR_CONCAT("str.++"),
        INT_TO_STR("int.to.str"),
        STR_SUFFIXOF("str.suffixof"),
        STR_CONTAINS("str.contains"),
        STR_AT("str.at"),
        CHAR_TO_INT("char_to_int"),
        STR_PREFIXOF("str.prefixof"),
        INT_TO_CHAR("int_to_char"),
        STR_LEN("str.len"),
        LE("<="),
        NOT("not"),
        STR_TO_INT("str.to.int"),
        ABS("abs"),
        BVADD("bvadd"),
        STR_IN_RE("str.in.re"),
        STR_TO_RE("str.to.re"),
        RE_CONCAT("re.++"),
        RE_KLEENE_STAR("re.*"),
        RE_UNION("re.union"),
        RE_OPT("re.opt"),
        RE_ALLCHAR("re.allchar"),
        RE_KLEENE_CROSS("re.+"),
        RE_LOOP("re.loop"),
        RE_RANGE("re.range"),
        REM("rem"),
        CONCAT("Concat"),
        REPLACE("Replace"),
        SUBSTRING("Substring"),
        ENDSWITH("Endswith"),
        CONTAINS("Contains"),
        STARTSWITH("StarsWith"),
        INDEXOF("Indexof"),
        LENGTH("Length");

        private final String rep;

        private Operator(String rep) {
            this.rep = rep;
        }

        public String toString() {
            return this.rep;
        }
    }
}

