/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.smt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtConstantDeclaration;
import org.evosuite.symbolic.solver.smt.SmtFunctionDeclaration;
import org.evosuite.symbolic.solver.smt.SmtFunctionDefinition;
import org.evosuite.symbolic.solver.smt.SmtQueryPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmtQuery {
    static Logger logger = LoggerFactory.getLogger(SmtQuery.class);
    private final List<SmtConstantDeclaration> constantDeclarations = new ArrayList<SmtConstantDeclaration>();
    private final List<SmtFunctionDeclaration> functionDeclarations = new ArrayList<SmtFunctionDeclaration>();
    private final List<SmtFunctionDefinition> functionDefinitions = new ArrayList<SmtFunctionDefinition>();
    private final List<SmtAssertion> assertions = new ArrayList<SmtAssertion>();
    private final Map<String, String> options = new HashMap<String, String>();
    private String smtLogic;

    public void addConstantDeclaration(SmtConstantDeclaration constDecl) {
        this.constantDeclarations.add(constDecl);
    }

    public void addFunctionDefinition(SmtFunctionDefinition funcDef) {
        this.functionDefinitions.add(funcDef);
    }

    public void addFunctionDeclaration(SmtFunctionDeclaration funcDecl) {
        this.functionDeclarations.add(funcDecl);
    }

    public void addAssertion(SmtAssertion smtAssert) {
        this.assertions.add(smtAssert);
    }

    public List<SmtAssertion> getAssertions() {
        return this.assertions;
    }

    public List<SmtConstantDeclaration> getConstantDeclarations() {
        return this.constantDeclarations;
    }

    public List<SmtFunctionDefinition> getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    public List<SmtFunctionDeclaration> getFunctionDeclarations() {
        return this.functionDeclarations;
    }

    public void setLogic(String smtLogic) {
        this.smtLogic = smtLogic;
    }

    public void addOption(String optionName, String optionValue) {
        this.options.put(optionName, optionValue);
    }

    public boolean hasLogic() {
        return this.smtLogic != null;
    }

    public String getLogic() {
        return this.smtLogic;
    }

    public Set<String> getOptions() {
        return this.options.keySet();
    }

    public String getOptionValue(String optionName) {
        return this.options.get(optionName);
    }

    public String toString() {
        SmtQueryPrinter printer = new SmtQueryPrinter();
        String str = printer.print(this);
        return str;
    }
}

