/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.smt;

import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtConstantDeclaration;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtExprPrinter;
import org.evosuite.symbolic.solver.smt.SmtFunctionDeclaration;
import org.evosuite.symbolic.solver.smt.SmtFunctionDefinition;
import org.evosuite.symbolic.solver.smt.SmtQuery;

public class SmtQueryPrinter {
    public String print(SmtQuery query) {
        String str;
        StringBuffer buff = new StringBuffer();
        buff.append("\n");
        if (query.hasLogic()) {
            buff.append("(set-logic " + query.getLogic() + ")");
            buff.append("\n");
        }
        for (String string : query.getOptions()) {
            String optionValue = query.getOptionValue(string);
            buff.append(String.format("(set-option %s %s)\n", string, optionValue));
            buff.append("\n");
        }
        buff.append("\n");
        for (SmtConstantDeclaration smtConstantDeclaration : query.getConstantDeclarations()) {
            str = this.print(smtConstantDeclaration);
            buff.append(str);
            buff.append("\n");
        }
        for (SmtFunctionDeclaration smtFunctionDeclaration : query.getFunctionDeclarations()) {
            str = this.print(smtFunctionDeclaration);
            buff.append(str);
            buff.append("\n");
        }
        for (SmtFunctionDefinition smtFunctionDefinition : query.getFunctionDefinitions()) {
            str = this.print(smtFunctionDefinition);
            buff.append(str);
            buff.append("\n");
        }
        for (SmtAssertion smtAssertion : query.getAssertions()) {
            str = this.print(smtAssertion);
            buff.append(str);
            buff.append("\n");
        }
        buff.append("(check-sat)");
        buff.append("\n");
        buff.append("(get-model)");
        buff.append("\n");
        buff.append("(exit)");
        buff.append("\n");
        return buff.toString();
    }

    public String print(SmtAssertion smtAssertion) {
        SmtExprPrinter printer = new SmtExprPrinter();
        SmtExpr expr = smtAssertion.getFormula();
        String exprStr = expr.accept(printer, null);
        String str = String.format("(assert %s)", exprStr);
        return str;
    }

    public String print(SmtFunctionDefinition functionDeclaration) {
        String str = String.format("(define-fun %s)", functionDeclaration.getFunctionDefinition());
        return str;
    }

    public String print(SmtFunctionDeclaration functionDeclaration) {
        String str = String.format("(declare-fun %s () %s)", functionDeclaration.getFunctionName(), functionDeclaration.getFunctionSort());
        return str;
    }

    public String print(SmtConstantDeclaration constantDeclaration) {
        String str = String.format("(declare-const %s %s)", constantDeclaration.getConstantName(), constantDeclaration.getConstantSort());
        return str;
    }
}

