/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3;

import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.smt.ExprToSmtVisitor;
import org.evosuite.symbolic.solver.smt.SmtExpr;

class ConstraintToZ3Visitor
implements ConstraintVisitor<SmtExpr, Void> {
    @Override
    public SmtExpr visit(IntegerConstraint c, Void arg) {
        Expression<?> right;
        Comparator cmp;
        Expression<?> left = c.getLeftOperand();
        SmtExpr equalsExpr = ConstraintToZ3Visitor.translateCompareTo(left, cmp = c.getComparator(), right = c.getRightOperand());
        if (equalsExpr != null) {
            return equalsExpr;
        }
        ExprToSmtVisitor v = new ExprToSmtVisitor();
        SmtExpr leftExpr = left.accept(v, null);
        SmtExpr rightExpr = right.accept(v, null);
        if (leftExpr == null || rightExpr == null) {
            return null;
        }
        return ConstraintToZ3Visitor.mkComparison(leftExpr, cmp, rightExpr);
    }

    private static SmtExpr translateCompareTo(Expression<?> left, Comparator cmp, Expression<?> right) {
        if (!(left instanceof StringBinaryToIntegerExpression)) {
            return null;
        }
        if (!(right instanceof IntegerConstant)) {
            return null;
        }
        if (cmp != Comparator.NE && cmp != Comparator.EQ) {
            return null;
        }
        StringBinaryToIntegerExpression leftExpr = (StringBinaryToIntegerExpression)left;
        if (leftExpr.getOperator() != Operator.COMPARETO) {
            return null;
        }
        IntegerConstant rightExpr = (IntegerConstant)right;
        if ((Long)rightExpr.getConcreteValue() != 0L) {
            return null;
        }
        ExprToSmtVisitor v = new ExprToSmtVisitor();
        SmtExpr leftEquals = leftExpr.getLeftOperand().accept(v, null);
        SmtExpr rightEquals = leftExpr.getRightOperand().accept(v, null);
        if (leftEquals == null || rightEquals == null) {
            return null;
        }
        SmtExpr eqExpr = SmtExprBuilder.mkEq(leftEquals, rightEquals);
        if (cmp == Comparator.EQ) {
            return eqExpr;
        }
        return SmtExprBuilder.mkNot(eqExpr);
    }

    private static SmtExpr mkComparison(SmtExpr left, Comparator cmp, SmtExpr right) {
        switch (cmp) {
            case LT: {
                SmtExpr lt = SmtExprBuilder.mkLt(left, right);
                return lt;
            }
            case LE: {
                SmtExpr le = SmtExprBuilder.mkLe(left, right);
                return le;
            }
            case GT: {
                SmtExpr gt = SmtExprBuilder.mkGt(left, right);
                return gt;
            }
            case GE: {
                SmtExpr ge = SmtExprBuilder.mkGe(left, right);
                return ge;
            }
            case EQ: {
                SmtExpr ge = SmtExprBuilder.mkEq(left, right);
                return ge;
            }
            case NE: {
                SmtExpr ge = SmtExprBuilder.mkEq(left, right);
                SmtExpr ne = SmtExprBuilder.mkNot(ge);
                return ne;
            }
        }
        throw new RuntimeException("Unknown comparator for constraint " + cmp.toString());
    }

    @Override
    public SmtExpr visit(RealConstraint c, Void arg) {
        ExprToSmtVisitor v = new ExprToSmtVisitor();
        SmtExpr left = c.getLeftOperand().accept(v, null);
        SmtExpr right = c.getRightOperand().accept(v, null);
        if (left == null || right == null) {
            return null;
        }
        Comparator cmp = c.getComparator();
        SmtExpr boolExpr = ConstraintToZ3Visitor.mkComparison(left, cmp, right);
        return boolExpr;
    }

    @Override
    public SmtExpr visit(StringConstraint c, Void arg) {
        ExprToSmtVisitor v = new ExprToSmtVisitor();
        StringComparison stringComparison = (StringComparison)c.getLeftOperand();
        Comparator cmp = c.getComparator();
        IntegerConstant integerConstant = (IntegerConstant)c.getRightOperand();
        SmtExpr left = stringComparison.accept(v, null);
        SmtExpr right = integerConstant.accept(v, null);
        if (left == null || right == null) {
            return null;
        }
        return ConstraintToZ3Visitor.mkComparison(left, cmp, right);
    }
}

