/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.evosuite.dse.AbstractVM;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.instrument.ConcolicInstrumentingClassLoader;
import org.evosuite.symbolic.vm.ConstructorFrame;
import org.evosuite.symbolic.vm.DoubleWordOperand;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.FakeBottomFrame;
import org.evosuite.symbolic.vm.Frame;
import org.evosuite.symbolic.vm.MethodFrame;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.ReferenceOperand;
import org.evosuite.symbolic.vm.SingleWordOperand;
import org.evosuite.symbolic.vm.StaticInitializerFrame;
import org.evosuite.symbolic.vm.SymbolicEnvironment;

public final class CallVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final HashMap<Member, MemberInfo> memberInfos = new HashMap();
    private final ConcolicInstrumentingClassLoader classLoader;
    int stackParamCount = 0;

    public CallVM(SymbolicEnvironment env, ConcolicInstrumentingClassLoader classLoader) {
        this.env = env;
        this.classLoader = classLoader;
    }

    private void CLINIT_BEGIN(String className) {
        this.env.ensurePrepared(className);
        StaticInitializerFrame frame = new StaticInitializerFrame(className);
        this.env.pushFrame(frame);
    }

    private boolean discardFrames(String className, String methName, Member function) {
        if (function == null) {
            throw new IllegalArgumentException("function should be non null");
        }
        if (this.env.topFrame() instanceof FakeBottomFrame) {
            return false;
        }
        Frame topFrame = this.env.topFrame();
        if (topFrame instanceof StaticInitializerFrame) {
            StaticInitializerFrame clinitFrame = (StaticInitializerFrame)topFrame;
            if (methName.equals(this.conf.INIT) && clinitFrame.getClassName().equals(className)) {
                return true;
            }
        }
        if (function != null && function.equals(topFrame.getMember())) {
            return true;
        }
        this.env.popFrame();
        return this.discardFrames(className, methName, function);
    }

    @Override
    public void HANDLER_BEGIN(int access, String className, String methName, String methDesc) {
        if (this.conf.CLINIT.equals(methName)) {
            this.discardFramesClassInitializer(className, methName);
        } else {
            Executable function = null;
            function = this.conf.INIT.equals(methName) ? this.resolveConstructorOverloading(className, methDesc) : this.resolveMethodOverloading(className, methName, methDesc);
            this.discardFrames(className, methName, function);
        }
        this.env.topFrame().operandStack.clearOperands();
        ReferenceConstant exception_reference = new ReferenceConstant(Type.getType(Exception.class), -1);
        this.env.topFrame().operandStack.pushRef(exception_reference);
    }

    private boolean discardFramesClassInitializer(String className, String methName) {
        if (!this.conf.CLINIT.equals(methName)) {
            throw new IllegalArgumentException("methName should be <clinit>");
        }
        if (this.env.topFrame() instanceof FakeBottomFrame) {
            return false;
        }
        Frame topFrame = this.env.topFrame();
        if (topFrame instanceof StaticInitializerFrame) {
            StaticInitializerFrame clinitFrame = (StaticInitializerFrame)topFrame;
            if (methName.equals(this.conf.CLINIT) && clinitFrame.getClassName().equals(className)) {
                return true;
            }
        }
        this.env.popFrame();
        return this.discardFramesClassInitializer(className, methName);
    }

    @Override
    public void METHOD_MAXS(String className, String methName, String methDesc, int maxStack, int maxLocals) {
        if (this.conf.CLINIT.equals(methName)) {
            return;
        }
        Executable member = null;
        member = this.conf.INIT.equals(methName) ? this.resolveConstructorOverloading(className, methDesc) : this.resolveMethodOverloading(className, methName, methDesc);
        if (member == null) {
            return;
        }
        if (this.memberInfos.containsKey(member)) {
            return;
        }
        this.memberInfos.put(member, new MemberInfo(maxStack, maxLocals));
    }

    @Override
    public void METHOD_BEGIN(int access, String className, String methName, String methDesc) {
        Object param;
        Frame frame;
        MemberInfo memberInfo;
        int maxLocals;
        if (this.conf.CLINIT.equals(methName)) {
            this.CLINIT_BEGIN(className);
            return;
        }
        if (!this.env.topFrame().weInvokedInstrumentedCode()) {
            // empty if block
        }
        this.prepareStackIfNeeded(className, methName, methDesc);
        Frame callerFrame = this.env.topFrame();
        boolean calleeNeedsThis = false;
        if (this.conf.INIT.equals(methName)) {
            Constructor<?> constructor = this.resolveConstructorOverloading(className, methDesc);
            maxLocals = this.conf.MAX_LOCALS_DEFAULT;
            memberInfo = this.memberInfos.get(constructor);
            if (memberInfo != null) {
                maxLocals = memberInfo.maxLocals;
            }
            frame = new ConstructorFrame(constructor, maxLocals);
            calleeNeedsThis = true;
            if (!callerFrame.weInvokedInstrumentedCode()) {
                Class<?> clazz = this.classLoader.getClassForName(className);
                Type objectType = Type.getType(clazz);
                ReferenceConstant referenceConstant = this.env.heap.buildNewReferenceConstant(objectType);
                frame.localsTable.setRefLocal(0, referenceConstant);
            }
        } else {
            Method method = this.resolveMethodOverloading(className, methName, methDesc);
            maxLocals = this.conf.MAX_LOCALS_DEFAULT;
            memberInfo = this.memberInfos.get(method);
            if (memberInfo != null) {
                maxLocals = memberInfo.maxLocals;
            }
            frame = new MethodFrame(method, maxLocals);
            boolean bl = calleeNeedsThis = !Modifier.isStatic(method.getModifiers());
        }
        if (!callerFrame.weInvokedInstrumentedCode()) {
            this.env.pushFrame(frame);
            return;
        }
        Class<?>[] paramTypes = this.getArgumentClasses(methDesc);
        LinkedList<Object> params = new LinkedList<Object>();
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = paramTypes.length - 1; i >= 0; --i) {
            param = it.next();
            params.push(param);
        }
        int index = 0;
        for (Operand operand : params) {
            frame.localsTable.setOperand(index + (calleeNeedsThis ? 1 : 0), operand);
            if (operand instanceof SingleWordOperand) {
                ++index;
                continue;
            }
            if (operand instanceof DoubleWordOperand) {
                index += 2;
                continue;
            }
            throw new IllegalStateException("Unknown operand type " + operand.getClass().getName());
        }
        if (calleeNeedsThis) {
            param = it.next();
            ReferenceOperand referenceOperand = (ReferenceOperand)param;
            frame.localsTable.setRefLocal(0, referenceOperand.getReference());
        }
        this.env.pushFrame(frame);
    }

    private void prepareStackIfNeeded(String className, String methName, String methDesc) {
        Method method = null;
        if (this.env.isEmpty()) {
            Method[] declMeths;
            Class<?> claz = this.classLoader.getClassForName(className);
            for (Method declMeth : declMeths = claz.getDeclaredMethods()) {
                if (!Modifier.isPublic(declMeth.getModifiers()) || !declMeth.getName().equals(methName)) continue;
                method = declMeth;
            }
            if (method != null) {
                this.env.prepareStack(method);
            }
        }
        if (this.env.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void METHOD_BEGIN_RECEIVER(Object value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            ReferenceExpression ref = this.env.heap.getReference(value);
            this.env.topFrame().localsTable.setRefLocal(0, ref);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, int value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            IntegerConstant literal_value = ExpressionFactory.buildNewIntegerConstant(value);
            this.env.topFrame().localsTable.setBv32Local(index, literal_value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, boolean value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, value ? 1 : 0);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, byte value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, char value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, short value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, long value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            IntegerConstant literal_value = ExpressionFactory.buildNewIntegerConstant(value);
            this.env.topFrame().localsTable.setBv64Local(index, literal_value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, double value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            RealConstant literal_value = ExpressionFactory.buildNewRealConstant(value);
            this.env.topFrame().localsTable.setFp64Local(index, literal_value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, float value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            RealConstant literal_value = ExpressionFactory.buildNewRealConstant(value);
            this.env.topFrame().localsTable.setFp32Local(index, literal_value);
        }
    }

    @Override
    public void METHOD_BEGIN_PARAM(int nr, int index, Object conc_ref) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            ReferenceExpression symb_ref = this.env.heap.getReference(conc_ref);
            this.env.topFrame().localsTable.setRefLocal(index, symb_ref);
        }
    }

    private Class<?>[] getArgumentClasses(String methDesc) {
        Type[] asmTypes = Type.getArgumentTypes(methDesc);
        Class[] classes = new Class[asmTypes.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.classLoader.getClassForType(asmTypes[i]);
        }
        return classes;
    }

    private static Method findMethodFromClass(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private Method resolveMethodOverloading(String owner, String name, String methDesc) {
        if (owner.equals("com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl")) {
            boolean bl = false;
        }
        Method method = null;
        LinkedList interfaces = new LinkedList();
        Class claz = this.env.ensurePrepared(owner);
        Class<?>[] argTypes = this.getArgumentClasses(methDesc);
        while (method == null && claz != null) {
            interfaces.addAll(Arrays.asList(claz.getInterfaces()));
            method = CallVM.findMethodFromClass(claz, name, argTypes);
            if (method == null) {
                claz = claz.getSuperclass();
            }
            if (claz != null || interfaces.isEmpty()) continue;
            claz = (Class)interfaces.pop();
        }
        if (method == null) {
            throw new IllegalArgumentException("Failed to resolve " + owner + "." + name);
        }
        return method;
    }

    private Constructor<?> resolveConstructorOverloading(String owner, String desc) {
        Constructor<?> constructor = null;
        Class<?> claz = this.env.ensurePrepared(owner);
        Class<?>[] argTypes = this.getArgumentClasses(desc);
        try {
            constructor = claz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Failed to resolve constructor of " + owner);
        }
        return constructor;
    }

    private boolean isIgnored(Method method) {
        if (Modifier.isNative(method.getModifiers())) {
            return false;
        }
        if (method.getDeclaringClass().isAnonymousClass()) {
            int indexOf;
            String name = method.getDeclaringClass().getName();
            String fullyQualifiedTopLevelClassName = name.substring(0, indexOf = name.indexOf("$"));
            return !this.conf.isIgnored(fullyQualifiedTopLevelClassName);
        }
        String declClass = method.getDeclaringClass().getCanonicalName();
        return !this.conf.isIgnored(declClass);
    }

    private Method methodCall(String className, String methName, String methDesc) {
        Method method = this.resolveMethodOverloading(className, methName, methDesc);
        boolean instrumented = this.isIgnored(method);
        this.env.topFrame().invokeInstrumentedCode(instrumented);
        return method;
    }

    @Override
    public void INVOKESTATIC(String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = false;
        this.methodCall(className, methName, methDesc);
    }

    @Override
    public void INVOKESPECIAL(String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        if (this.conf.INIT.equals(methName)) {
            boolean instrumented = !this.conf.isIgnored(className);
            this.env.topFrame().invokeInstrumentedCode(instrumented);
        } else {
            this.methodCall(className, methName, methDesc);
        }
    }

    @Override
    public void INVOKESPECIAL(Object conc_receiver, String className, String methName, String methDesc) {
        this.INVOKESPECIAL(className, methName, methDesc);
    }

    @Override
    public void INVOKEVIRTUAL(Object conc_receiver, String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        Type[] argTypes = Type.getArgumentTypes(methDesc);
        for (int i = 0; i < argTypes.length; ++i) {
            it.next();
        }
        ReferenceOperand ref_operand = (ReferenceOperand)it.next();
        ReferenceExpression symb_receiver = ref_operand.getReference();
        this.env.heap.initializeReference(conc_receiver, symb_receiver);
        if (this.nullReferenceViolation(conc_receiver, symb_receiver)) {
            return;
        }
        String concreteClassName = conc_receiver.getClass().getName();
        Method virtualMethod = this.methodCall(concreteClassName, methName, methDesc);
        this.chooseReceiverType(className, conc_receiver, methDesc, virtualMethod);
    }

    private boolean nullReferenceViolation(Object conc_receiver, ReferenceExpression symb_receiver) {
        return conc_receiver == null;
    }

    @Override
    public void INVOKEINTERFACE(Object conc_receiver, String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        if (this.nullReferenceViolation(conc_receiver, null)) {
            return;
        }
        String concreteClassName = conc_receiver.getClass().getName();
        Method method = this.methodCall(concreteClassName, methName, methDesc);
        this.chooseReceiverType(className, conc_receiver, methDesc, method);
    }

    private void chooseReceiverType(String className, Object receiver, String methDesc, Method staticMethod) {
        if (this.nullReferenceViolation(receiver, null)) {
            throw new IllegalArgumentException("we are post null-deref check");
        }
        Class<?> staticReceiver = this.env.ensurePrepared(className);
        if (Modifier.isFinal(staticReceiver.getModifiers())) {
            return;
        }
        int methodModifiers = staticMethod.getModifiers();
        if (Modifier.isNative(methodModifiers) && Modifier.isFinal(methodModifiers)) {
            return;
        }
    }

    private Frame popFrameAndDisposeCallerParams() {
        Frame frame = this.env.popFrame();
        if (!this.env.isEmpty() && this.env.topFrame().weInvokedInstrumentedCode()) {
            this.env.topFrame().disposeMethInvokeArgs(frame);
        }
        return frame;
    }

    @Override
    public void RETURN() {
        this.popFrameAndDisposeCallerParams();
    }

    @Override
    public void IRETURN() {
        Frame returningFrame = this.popFrameAndDisposeCallerParams();
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            Operand ret_val = returningFrame.operandStack.popOperand();
            this.env.topFrame().operandStack.pushOperand(ret_val);
        }
    }

    @Override
    public void LRETURN() {
        this.IRETURN();
    }

    @Override
    public void FRETURN() {
        this.IRETURN();
    }

    @Override
    public void DRETURN() {
        this.IRETURN();
    }

    @Override
    public void ARETURN() {
        this.IRETURN();
    }

    @Override
    public void CALL_RESULT(String owner, String name, String desc) {
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        this.env.topFrame().disposeMethInvokeArgs(desc);
    }

    @Override
    public void CALL_RESULT(boolean res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        int i = res ? 1 : 0;
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(i);
        this.env.topFrame().operandStack.pushBv32(value);
    }

    @Override
    public void CALL_RESULT(int res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(res);
        this.env.topFrame().operandStack.pushBv32(value);
    }

    @Override
    public void CALL_RESULT(Object res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        ReferenceExpression symb_ref = this.env.heap.getReference(res);
        this.env.topFrame().operandStack.pushRef(symb_ref);
    }

    @Override
    public void CALL_RESULT(long res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(res);
        this.env.topFrame().operandStack.pushBv64(value);
    }

    @Override
    public void CALL_RESULT(double res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        RealConstant value = ExpressionFactory.buildNewRealConstant(res);
        this.env.topFrame().operandStack.pushFp64(value);
    }

    @Override
    public void CALL_RESULT(float res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        RealConstant value = ExpressionFactory.buildNewRealConstant(res);
        this.env.topFrame().operandStack.pushFp32(value);
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, int value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, boolean value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, short value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, byte value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, char value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, long value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, float value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, double value) {
        ++this.stackParamCount;
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, Object conc_ref) {
        ++this.stackParamCount;
        int operand_index = this.stackParamCount - 1;
        Operand op = this.getOperand(operand_index);
        ReferenceOperand ref_op = (ReferenceOperand)op;
        ReferenceExpression symb_ref = ref_op.getReference();
        this.env.heap.initializeReference(conc_ref, symb_ref);
    }

    private Operand getOperand(int index) {
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = 0; i < index + 1; ++i) {
            Operand op = it.next();
            if (i != index) continue;
            return op;
        }
        return null;
    }

    private static final class MemberInfo {
        final int maxStack;
        final int maxLocals;

        MemberInfo(int maxStack, int maxLocals) {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }
}

