/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.IfBranchCondition;
import org.evosuite.symbolic.SwitchBranchCondition;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.vm.ConstraintNormalizer;

public final class PathConditionCollector {
    private final List<BranchCondition> branchConditions = new LinkedList<BranchCondition>();
    private final LinkedList<Constraint<?>> currentSupportingConstraints = new LinkedList();

    private static Constraint<?> normalizeConstraint(IntegerConstraint c) {
        return ConstraintNormalizer.normalize(c);
    }

    public void appendSupportingConstraint(IntegerConstraint c) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        this.currentSupportingConstraints.add(normalizedConstraint);
    }

    public void appendIfBranchCondition(String className, String methName, int branchIndex, boolean isTrueBranch, IntegerConstraint c) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        LinkedList branch_supporting_constraints = new LinkedList(this.currentSupportingConstraints);
        IfBranchCondition new_branch = new IfBranchCondition(className, methName, branchIndex, normalizedConstraint, branch_supporting_constraints, isTrueBranch);
        this.branchConditions.add(new_branch);
        this.currentSupportingConstraints.clear();
    }

    public void appendSwitchBranchCondition(String className, String methodName, int instructionIndex, IntegerConstraint c, int goal) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        LinkedList branch_supporting_constraints = new LinkedList(this.currentSupportingConstraints);
        SwitchBranchCondition new_branch = new SwitchBranchCondition(className, methodName, instructionIndex, normalizedConstraint, branch_supporting_constraints, goal);
        this.branchConditions.add(new_branch);
        this.currentSupportingConstraints.clear();
    }

    public List<BranchCondition> getPathCondition() {
        return new LinkedList<BranchCondition>(this.branchConditions);
    }

    public void appendDefaultSwitchBranchCondition(String className, String methodName, int instructionIndex, IntegerConstraint c) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        LinkedList branch_supporting_constraints = new LinkedList(this.currentSupportingConstraints);
        SwitchBranchCondition new_branch = new SwitchBranchCondition(className, methodName, instructionIndex, normalizedConstraint, branch_supporting_constraints);
        this.branchConditions.add(new_branch);
        this.currentSupportingConstraints.clear();
    }
}

