/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class SCALB {
    private static final String SCALB = "scalb";

    public static class SCALB_F
    extends SymbolicFunction {
        public SCALB_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.SCALB.SCALB, Types.FI2F_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue scalbExpr;
            float res = this.getConcFloatRetVal();
            RealValue left = this.getSymbRealArgument(0);
            IntegerValue right = this.getSymbIntegerArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.SCALB;
                scalbExpr = new RealBinaryExpression(left, op, right, Double.valueOf(res));
            } else {
                scalbExpr = this.getSymbRealRetVal();
            }
            return scalbExpr;
        }
    }

    public static class SCALB_D
    extends SymbolicFunction {
        public SCALB_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.SCALB.SCALB, Types.DI2D_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue scalbExpr;
            double res = this.getConcDoubleRetVal();
            RealValue left = this.getSymbRealArgument(0);
            IntegerValue right = this.getSymbIntegerArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.SCALB;
                scalbExpr = new RealBinaryExpression(left, op, right, res);
            } else {
                scalbExpr = this.getSymbRealRetVal();
            }
            return scalbExpr;
        }
    }
}

