/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.extraction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.testcarver.capture.FieldRegistry;
import org.evosuite.testcarver.extraction.CarvingClassLoader;
import org.evosuite.testcarver.extraction.CarvingRunListener;
import org.evosuite.testcarver.testcase.CarvedTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.utils.LoggingUtils;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarvingManager {
    private static final Logger logger = LoggerFactory.getLogger(CarvingManager.class);
    private static CarvingManager instance = null;
    private Map<Class<?>, List<TestCase>> carvedTests = new LinkedHashMap();
    private boolean carvingDone = false;

    private CarvingManager() {
    }

    public static CarvingManager getInstance() {
        if (instance == null) {
            instance = new CarvingManager();
        }
        return instance;
    }

    private Collection<String> getListOfJUnitClassNames() throws IllegalStateException {
        String prop = Properties.SELECTED_JUNIT;
        if (prop == null || prop.trim().isEmpty()) {
            throw new IllegalStateException("Trying to use a test carver factory, but empty Properties.SELECTED_JUNIT");
        }
        String[] paths = prop.split(":");
        HashSet<String> junitTestNames = new HashSet<String>();
        for (String s : paths) {
            junitTestNames.add(s.trim());
        }
        return junitTestNames;
    }

    private void chopException(TestCase test, ExecutionResult result) {
        if (!result.noThrownExceptions()) {
            Integer pos = result.getFirstPositionOfThrownException();
            if (pos != null) {
                test.chop(pos);
            } else {
                test.chop(test.size() - 1);
            }
        }
    }

    private void readTestCases() throws IllegalStateException {
        ClientServices.getInstance().getClientNode().changeState(ClientState.CARVING);
        Collection<String> junitTestNames = this.getListOfJUnitClassNames();
        LoggingUtils.getEvoLogger().info("* Executing tests from {} test {} for carving", (Object)junitTestNames.size(), (Object)(junitTestNames.size() == 1 ? "class" : "classes"));
        JUnitCore runner = new JUnitCore();
        CarvingRunListener listener = new CarvingRunListener();
        runner.addListener(listener);
        ArrayList junitTestClasses = new ArrayList();
        CarvingClassLoader classLoader = new CarvingClassLoader();
        FieldRegistry.carvingClassLoader = classLoader;
        try {
            classLoader.loadClass(Properties.TARGET_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (String className : junitTestNames) {
            String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
            try {
                Class<?> junitClass = classLoader.loadClass(classNameWithDots);
                junitTestClasses.add(junitClass);
            }
            catch (ClassNotFoundException e) {
                logger.error("Failed to load JUnit test class {}: {}", (Object)classNameWithDots, (Object)e);
            }
        }
        Class[] classes = new Class[junitTestClasses.size()];
        junitTestClasses.toArray(classes);
        Result result = runner.run(classes);
        logger.info("Result: {}/{}", (Object)result.getFailureCount(), (Object)result.getRunCount());
        for (Failure failure : result.getFailures()) {
            logger.info("Failure: {}", (Object)failure.getMessage());
            logger.info("Exception: {}", failure.getException());
        }
        Map<Class<?>, List<TestCase>> testMap = listener.getTestCases();
        for (Class<?> targetClass : testMap.keySet()) {
            ArrayList<TestCase> processedTests = new ArrayList<TestCase>();
            for (TestCase test : testMap.get(targetClass)) {
                String testName = ((CarvedTestCase)test).getName();
                if (test.isEmpty()) continue;
                ExecutionResult executionResult = null;
                try {
                    executionResult = TestCaseExecutor.runTest(test);
                }
                catch (Throwable t) {
                    logger.info("Error while executing carved test {}: {}", (Object)testName, (Object)t);
                    continue;
                }
                if (executionResult.noThrownExceptions()) {
                    logger.info("Adding carved test without exception");
                    logger.info(test.toCode());
                    processedTests.add(test);
                    continue;
                }
                logger.info("Exception thrown in carved test {}: {}", (Object)testName, (Object)executionResult.getExceptionThrownAtPosition(executionResult.getFirstPositionOfThrownException()));
                for (StackTraceElement elem : executionResult.getExceptionThrownAtPosition(executionResult.getFirstPositionOfThrownException()).getStackTrace()) {
                    logger.info(elem.toString());
                }
                logger.info(test.toCode(executionResult.exposeExceptionMapping()));
                if (Properties.CHOP_CARVED_EXCEPTIONS) {
                    logger.info("Chopping exception of carved test");
                    this.chopException(test, executionResult);
                    if (test.hasObject(Properties.getTargetClassAndDontInitialise(), test.size())) {
                        processedTests.add(test);
                        continue;
                    }
                    logger.info("Chopped test is empty");
                    continue;
                }
                logger.info("Not adding carved test with exception: ");
            }
            if (processedTests.size() > 0) {
                LoggingUtils.getEvoLogger().info(" -> Carved {} tests for class {} from existing JUnit tests", (Object)processedTests.size(), (Object)targetClass);
                if (logger.isDebugEnabled()) {
                    for (TestCase test : processedTests) {
                        logger.debug("Carved Test {}: {}", (Object)((CarvedTestCase)test).getName(), (Object)test.toCode());
                    }
                }
            } else {
                logger.info("It was not possible to carve any test case for class {} from {}", (Object)targetClass.getName(), (Object)Arrays.toString(junitTestNames.toArray()));
            }
            this.carvedTests.put(targetClass, processedTests);
        }
        this.carvingDone = true;
        FieldRegistry.carvingClassLoader = null;
    }

    public void clear() {
        this.carvingDone = false;
        this.carvedTests.clear();
    }

    public List<TestCase> getTestsForClass(Class<?> clazz) {
        if (!this.carvingDone) {
            this.readTestCases();
        }
        if (!this.carvedTests.containsKey(clazz)) {
            return new ArrayList<TestCase>();
        }
        return this.carvedTests.get(clazz);
    }

    public Set<Class<?>> getClassesWithTests() {
        if (!this.carvingDone) {
            this.readTestCases();
        }
        return this.carvedTests.keySet();
    }
}

