/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.runtime.util.Inputs;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericMethod;

public class ConstraintHelper {
    public static int countNumberOfNewInstances(TestCase test, Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(test, klass);
        int counter = 0;
        for (int i = 0; i < test.size(); ++i) {
            ConstructorStatement cs;
            Statement st = test.getStatement(i);
            if (!(st instanceof ConstructorStatement) || !klass.isAssignableFrom((cs = (ConstructorStatement)st).getConstructor().getDeclaringClass())) continue;
            ++counter;
        }
        return counter;
    }

    public static int countNumberOfMethodCalls(TestCase test, Class<?> klass, String methodName) throws IllegalArgumentException {
        Inputs.checkNull(test, klass);
        int counter = 0;
        for (int i = 0; i < test.size(); ++i) {
            MethodStatement ms;
            GenericMethod gm;
            Statement st = test.getStatement(i);
            if (!(st instanceof MethodStatement) || !(gm = (ms = (MethodStatement)st).getMethod()).getDeclaringClass().equals(klass) || !gm.getName().equals(methodName)) continue;
            ++counter;
        }
        return counter;
    }

    public static int getLastPositionOfMethodCall(TestCase test, String className, String methodName, int lastPosition) {
        Inputs.checkNull(test, className, methodName);
        int pos = -1;
        for (int i = 0; i < lastPosition; ++i) {
            MethodStatement ms;
            GenericMethod gm;
            Statement st = test.getStatement(i);
            if (!(st instanceof MethodStatement) || !(gm = (ms = (MethodStatement)st).getMethod()).getDeclaringClass().getCanonicalName().equals(className) || !gm.getName().equals(methodName)) continue;
            pos = i;
        }
        return pos;
    }

    public static String[] getClassAndMethod(String s, Class<?> c) {
        String klassName = null;
        String methodName = null;
        if (s.contains("#")) {
            int pos = s.indexOf(35);
            klassName = s.substring(0, pos);
            methodName = s.substring(pos + 1, s.length());
        } else {
            klassName = c.getCanonicalName();
            methodName = s;
        }
        return new String[]{klassName, methodName};
    }

    public static boolean isNull(VariableReference vr, TestCase tc) {
        Object obj;
        if (vr instanceof NullReference) {
            return true;
        }
        Statement varSource = tc.getStatement(vr.getStPosition());
        return varSource instanceof PrimitiveStatement && (obj = ((PrimitiveStatement)varSource).getValue()) == null;
    }
}

