/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.StructuredTestCodeVisitor;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFitnessFunction;

public class StructuredTestCase
extends DefaultTestCase {
    private static final long serialVersionUID = -1896651382970358963L;
    private final Set<TestFitnessFunction> primaryTargets = new HashSet<TestFitnessFunction>();
    private final Set<TestFitnessFunction> secondaryTargets = new HashSet<TestFitnessFunction>();
    private final Set<Integer> targetStatements = new HashSet<Integer>();

    public StructuredTestCase(TestCase test) {
        test.forEach(statement -> this.addStatement(statement.clone(this)));
    }

    public void addPrimaryGoal(TestFitnessFunction goal) {
        this.primaryTargets.add(goal);
    }

    public Set<String> getTargetMethods() {
        return this.primaryTargets.stream().map(TestFitnessFunction::getTargetMethod).collect(Collectors.toCollection(HashSet::new));
    }

    public String getTargetClass() {
        return null;
    }

    public boolean isSetupStatement(int position) {
        int exerciseStart = Collections.min(this.targetStatements);
        return position < exerciseStart;
    }

    public boolean isExerciseStatement(int position) {
        return this.targetStatements.contains(position);
    }

    public int getFirstExerciseStatement() {
        return Collections.min(this.targetStatements);
    }

    public void setExerciseStatement(int position) {
        this.targetStatements.add(position);
    }

    public int getFirstCheckingStatement() {
        return Collections.max(this.targetStatements);
    }

    @Override
    public String toCode() {
        StructuredTestCodeVisitor visitor = new StructuredTestCodeVisitor();
        this.accept(visitor);
        return visitor.getCode();
    }

    @Override
    public String toCode(Map<Integer, Throwable> exceptions) {
        StructuredTestCodeVisitor visitor = new StructuredTestCodeVisitor();
        visitor.setExceptions(exceptions);
        this.accept(visitor);
        return visitor.getCode();
    }

    @Override
    public DefaultTestCase clone() {
        StructuredTestCase copy = new StructuredTestCase(this);
        copy.targetStatements.addAll(this.targetStatements);
        copy.primaryTargets.addAll(this.primaryTargets);
        copy.secondaryTargets.addAll(this.secondaryTargets);
        return copy;
    }
}

