/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationExecutionResult;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.operators.mutation.MutationHistory;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.setup.TestCluster;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.ConcolicMutation;
import org.evosuite.testcase.AbstractTestChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestMutationHistoryEntry;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestChromosome
extends AbstractTestChromosome<TestChromosome> {
    private static final long serialVersionUID = 7532366007973252782L;
    private static final Logger logger = LoggerFactory.getLogger(TestChromosome.class);
    protected MutationHistory<TestMutationHistoryEntry> mutationHistory = new MutationHistory();
    private static final List<SecondaryObjective<TestChromosome>> secondaryObjectives = new ArrayList<SecondaryObjective<TestChromosome>>();
    public static final TestChromosomeCollector toTestSuiteCollector = new TestChromosomeCollector();

    @Override
    public void setLastExecutionResult(ExecutionResult lastExecutionResult) {
        if (lastExecutionResult == null) {
            return;
        }
        assert (lastExecutionResult.test.equals(this.test));
        this.lastExecutionResult = lastExecutionResult;
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        if (changed) {
            this.clearCachedResults();
        }
    }

    @Override
    public TestChromosome self() {
        return this;
    }

    @Override
    public TestChromosome clone() {
        TestChromosome c = new TestChromosome();
        c.test = this.test.clone();
        c.setFitnessValues(this.getFitnessValues());
        c.setPreviousFitnessValues(this.getPreviousFitnessValues());
        c.copyCachedResults(this);
        c.setChanged(this.isChanged());
        c.setLocalSearchApplied(this.hasLocalSearchBeenApplied());
        if (Properties.LOCAL_SEARCH_SELECTIVE) {
            for (TestMutationHistoryEntry mutation : this.mutationHistory) {
                if (!this.test.contains(mutation.getStatement())) continue;
                c.mutationHistory.addMutationEntry(mutation.clone(c.getTestCase()));
            }
        }
        c.setNumberOfMutations(this.getNumberOfMutations());
        c.setNumberOfEvaluations(this.getNumberOfEvaluations());
        c.setKineticEnergy(this.getKineticEnergy());
        c.setNumCollisions(this.getNumCollisions());
        return c;
    }

    @Override
    public void copyCachedResults(TestChromosome other) {
        if (this.test == null) {
            throw new RuntimeException("Test is null!");
        }
        if (other.lastExecutionResult != null) {
            this.lastExecutionResult = other.lastExecutionResult.clone();
            this.lastExecutionResult.setTest(this.test);
        }
        if (other.lastMutationResult != null) {
            for (Mutation mutation : other.lastMutationResult.keySet()) {
                MutationExecutionResult copy = (MutationExecutionResult)other.lastMutationResult.get(mutation);
                this.lastMutationResult.put(mutation, copy);
            }
        }
    }

    @Override
    public void crossOver(TestChromosome other, int position1, int position2) throws ConstructionFailedException {
        int i;
        logger.debug("Crossover starting");
        TestChromosome offspring = new TestChromosome();
        TestFactory testFactory = TestFactory.getInstance();
        for (i = 0; i < position1; ++i) {
            offspring.test.addStatement(this.test.getStatement(i).clone(offspring.test));
        }
        for (i = position2; i < other.size(); ++i) {
            testFactory.appendStatement(offspring.test, other.test.getStatement(i));
        }
        if (!Properties.CHECK_MAX_LENGTH || offspring.test.size() <= Properties.CHROMOSOME_LENGTH) {
            this.test = offspring.test;
            this.setChanged(true);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestChromosome other = (TestChromosome)obj;
        if (this.test == null) {
            return other.test == null;
        }
        return this.test.equals(other.test);
    }

    @Override
    public int hashCode() {
        return this.test.hashCode();
    }

    public MutationHistory<TestMutationHistoryEntry> getMutationHistory() {
        return this.mutationHistory;
    }

    public void clearMutationHistory() {
        this.mutationHistory.clear();
    }

    public boolean hasRelevantMutations() {
        Integer lastPos;
        if (this.mutationHistory.isEmpty()) {
            logger.info("Mutation history is empty");
            return false;
        }
        int lastPosition = this.test.size() - 1;
        if (this.lastExecutionResult != null && !this.isChanged() && (lastPos = this.lastExecutionResult.getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        for (TestMutationHistoryEntry mutation : this.mutationHistory) {
            logger.info("Considering: " + (Object)((Object)mutation.getMutationType()));
            if (mutation.getMutationType() == TestMutationHistoryEntry.TestMutation.DELETION || mutation.getStatement().getPosition() > lastPosition || Properties.LOCAL_SEARCH_SELECTIVE_PRIMITIVES && !(mutation.getStatement() instanceof PrimitiveStatement)) continue;
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (!this.test.hasReferences(mutation.getStatement().getReturnValue()) && !mutation.getStatement().getReturnClass().equals(targetClass)) continue;
            int newPosition = IntStream.rangeClosed(0, lastPosition).filter(pos -> this.test.getStatement(pos) == mutation.getStatement()).findFirst().orElse(-1);
            assert (newPosition >= 0);
            if (newPosition < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean localSearch(LocalSearchObjective<TestChromosome> objective) {
        TestCaseLocalSearch<TestChromosome> localSearch = TestCaseLocalSearch.selectTestCaseLocalSearch();
        return localSearch.doSearch(this, objective);
    }

    @Override
    public void mutate() {
        boolean changed = false;
        this.mutationHistory.clear();
        if (this.mockChange()) {
            changed = true;
        }
        if (Properties.CHOP_MAX_LENGTH && this.size() >= Properties.CHROMOSOME_LENGTH) {
            int lastPosition = this.getLastMutatableStatement();
            this.test.chop(lastPosition + 1);
        }
        if (Randomness.nextDouble() <= Properties.P_TEST_DELETE) {
            logger.debug("Mutation: delete");
            if (this.mutationDelete()) {
                changed = true;
            }
        }
        if (Randomness.nextDouble() <= Properties.P_TEST_CHANGE) {
            logger.debug("Mutation: change");
            if (this.mutationChange()) {
                changed = true;
            }
        }
        if (Randomness.nextDouble() <= Properties.P_TEST_INSERT) {
            logger.debug("Mutation: insert");
            if (this.mutationInsert()) {
                changed = true;
            }
        }
        if (changed) {
            this.increaseNumberOfMutations();
            this.setChanged(true);
            this.test.clearCoveredGoals();
        }
        this.test.forEach(Statement::isValid);
    }

    private boolean mockChange() {
        boolean changed = false;
        for (int i = 0; i < this.test.size(); ++i) {
            FunctionalMockStatement fms;
            Statement st = this.test.getStatement(i);
            if (!(st instanceof FunctionalMockStatement) || !(fms = (FunctionalMockStatement)st).doesNeedToUpdateInputs()) continue;
            int preLength = this.test.size();
            try {
                List<Type> missing = fms.updateMockedMethods();
                int pos = st.getPosition();
                logger.debug("Generating parameters for mock call");
                List<VariableReference> refs = TestFactory.getInstance().satisfyParameters(this.test, null, missing, null, pos, 0, true, false, true);
                fms.addMissingInputs(refs);
            }
            catch (Exception e) {
                String msg = "Functional mock problem: " + e.toString();
                AtMostOnceLogger.warn(logger, msg);
                fms.fillWithNullRefs();
                return changed;
            }
            changed = true;
            int increase = this.test.size() - preLength;
            i += increase;
        }
        return changed;
    }

    private int getLastMutatableStatement() {
        ExecutionResult result = this.getLastExecutionResult();
        int size = this.test.size();
        if (result != null && !result.noThrownExceptions()) {
            int pos = result.getFirstPositionOfThrownException();
            return pos >= size ? size - 1 : pos;
        }
        return this.test.size() - 1;
    }

    private boolean mutationDelete() {
        if (this.test.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int lastMutableStatement = this.getLastMutatableStatement();
        double pl = 1.0 / (double)(lastMutableStatement + 1);
        TestFactory testFactory = TestFactory.getInstance();
        for (int num = lastMutableStatement; num >= 0; --num) {
            if (num >= this.test.size() || !(Randomness.nextDouble() <= pl)) continue;
            changed |= this.deleteStatement(testFactory, num);
        }
        return changed;
    }

    protected boolean deleteStatement(TestFactory testFactory, int num) {
        try {
            TestCase copy = this.test.clone();
            this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.DELETION));
            boolean modified = testFactory.deleteStatementGracefully(copy, num);
            this.test = copy;
            return modified;
        }
        catch (ConstructionFailedException e) {
            logger.warn("Deletion of statement failed: " + this.test.getStatement(num).getCode());
            logger.warn(this.test.toCode());
            return false;
        }
    }

    private boolean mutationChange() {
        boolean changed = false;
        int lastMutatableStatement = this.getLastMutatableStatement();
        double pl = 1.0 / (double)(lastMutatableStatement + 1);
        TestFactory testFactory = TestFactory.getInstance();
        if (Randomness.nextDouble() < Properties.CONCOLIC_MUTATION) {
            try {
                changed = this.mutationConcolic();
            }
            catch (Exception exc) {
                logger.warn("Encountered exception when trying to use concolic mutation: {}", (Object)exc.getMessage());
                logger.debug("Detailed exception trace: ", exc);
            }
        }
        if (!changed) {
            for (int position = 0; position <= lastMutatableStatement; ++position) {
                if (!(Randomness.nextDouble() <= pl)) continue;
                assert (this.test.isValid());
                Statement statement = this.test.getStatement(position);
                if (statement.isReflectionStatement()) continue;
                int oldDistance = statement.getReturnValue().getDistance();
                if (statement.mutate(this.test, testFactory)) {
                    changed = true;
                    this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.CHANGE, statement));
                    assert (this.test.isValid());
                } else if (!statement.isAssignmentStatement()) {
                    int pos = statement.getPosition();
                    if (testFactory.changeRandomCall(this.test, statement)) {
                        changed = true;
                        this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.CHANGE, this.test.getStatement(pos)));
                    }
                    assert (this.test.isValid());
                }
                statement.getReturnValue().setDistance(oldDistance);
                position = statement.getPosition();
            }
        }
        return changed;
    }

    public boolean mutationInsert() {
        boolean changed = false;
        double ALPHA = Properties.P_STATEMENT_INSERTION;
        int count = 0;
        TestFactory testFactory = TestFactory.getInstance();
        while (Randomness.nextDouble() <= Math.pow(ALPHA, count) && (!Properties.CHECK_MAX_LENGTH || this.size() < Properties.CHROMOSOME_LENGTH)) {
            ++count;
            int position = testFactory.insertRandomStatement(this.test, this.getLastMutatableStatement());
            if (position < 0 || position >= this.test.size()) continue;
            changed = true;
            this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.INSERTION, this.test.getStatement(position)));
        }
        return changed;
    }

    private boolean mutationConcolic() {
        logger.info("Applying DSE mutation");
        List branches = ConcolicExecution.getSymbolicPath(this);
        logger.debug("Conditions: " + branches);
        if (branches.isEmpty()) {
            return false;
        }
        boolean mutated = false;
        List targetBranches = branches.stream().filter(b -> TestCluster.isTargetClassName(b.getClassName())).collect(Collectors.toCollection(ArrayList::new));
        List bs = targetBranches.isEmpty() ? branches : targetBranches;
        BranchCondition branch = (BranchCondition)Randomness.choice(bs);
        logger.debug("Trying to negate branch " + branch.getInstructionIndex() + " - have " + targetBranches.size() + "/" + branches.size() + " target branches");
        TestCase newTest = ConcolicMutation.negateCondition(branches, branch, this.test);
        if (newTest != null) {
            logger.debug("CONCOLIC: Created new test");
            this.test = newTest;
            this.setChanged(true);
            this.lastExecutionResult = null;
        } else {
            logger.debug("CONCOLIC: Did not create new test");
        }
        return mutated;
    }

    @Override
    public int size() {
        return this.test.size();
    }

    @Override
    public int compareTo(TestChromosome o) {
        int result = super.compareTo(o);
        if (result != 0) {
            return result;
        }
        return this.test.toCode().compareTo(o.test.toCode());
    }

    public String toString() {
        return this.test.toCode();
    }

    public boolean hasException() {
        return this.lastExecutionResult != null && !this.lastExecutionResult.noThrownExceptions();
    }

    @Override
    public ExecutionResult executeForFitnessFunction(TestSuiteFitnessFunction testSuiteFitnessFunction) {
        return testSuiteFitnessFunction.runTest(this.test);
    }

    @Override
    public int compareSecondaryObjective(TestChromosome o) {
        SecondaryObjective<TestChromosome> so;
        int objective = 0;
        int c = 0;
        while (c == 0 && objective < secondaryObjectives.size() && (so = secondaryObjectives.get(objective++)) != null) {
            c = so.compareChromosomes(this.self(), o);
        }
        return c;
    }

    public static void addSecondaryObjective(SecondaryObjective<TestChromosome> objective) {
        secondaryObjectives.add(objective);
    }

    public static void ShuffleSecondaryObjective() {
        Collections.shuffle(secondaryObjectives);
    }

    public static void reverseSecondaryObjective() {
        Collections.reverse(secondaryObjectives);
    }

    public static void removeSecondaryObjective(SecondaryObjective<TestChromosome> objective) {
        secondaryObjectives.remove(objective);
    }

    public static List<SecondaryObjective<TestChromosome>> getSecondaryObjectives() {
        return secondaryObjectives;
    }

    public TestSuiteChromosome toSuite() {
        return Stream.of(this).collect(toTestSuiteCollector);
    }

    public static class TestChromosomeCollector
    implements Collector<TestChromosome, TestSuiteChromosome, TestSuiteChromosome> {
        private static final Set<Collector.Characteristics> characteristics = Collections.unmodifiableSet(new HashSet<Collector.Characteristics>(Arrays.asList(Collector.Characteristics.CONCURRENT, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED)));

        @Override
        public Supplier<TestSuiteChromosome> supplier() {
            return TestSuiteChromosome::new;
        }

        @Override
        public BiConsumer<TestSuiteChromosome, TestChromosome> accumulator() {
            return AbstractTestSuiteChromosome::addTest;
        }

        @Override
        public BinaryOperator<TestSuiteChromosome> combiner() {
            return (suite1, suite2) -> {
                suite1.addTestChromosomes(suite2.getTestChromosomes());
                return suite1;
            };
        }

        @Override
        public Function<TestSuiteChromosome, TestSuiteChromosome> finisher() {
            return suite -> suite;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return characteristics;
        }
    }
}

