/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.ga.metaheuristics.mapelites.FeatureVector;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResult
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionResult.class);
    public TestCase test;
    public Mutation mutation;
    protected Map<Integer, Throwable> exceptions = new HashMap<Integer, Throwable>();
    public Map<Integer, Boolean> explicitExceptions = new HashMap<Integer, Boolean>();
    protected ExecutionTrace trace = null;
    protected long executionTime = 0L;
    protected int executedStatements = 0;
    protected boolean hasSecurityException = false;
    protected Set<String> readProperties;
    protected boolean wasAnyPropertyWritten;
    private List<FeatureVector> featureVectors = new ArrayList<FeatureVector>(1);
    protected final Map<Class<?>, OutputTrace<?>> traces = new HashMap();
    private Map<Integer, Set<InputCoverageGoal>> inputGoals = new LinkedHashMap<Integer, Set<InputCoverageGoal>>();
    private Map<Integer, Set<OutputCoverageGoal>> outputGoals = new LinkedHashMap<Integer, Set<OutputCoverageGoal>>();

    public int getExecutedStatements() {
        return this.executedStatements;
    }

    public void setExecutedStatements(int executedStatements) {
        this.executedStatements = executedStatements;
    }

    public ExecutionResult(TestCase t) {
        this.mutation = null;
        this.test = t;
    }

    public void setThrownExceptions(Map<Integer, Throwable> data) {
        this.exceptions.clear();
        data.forEach(this::reportNewThrownException);
    }

    public Integer getFirstPositionOfThrownException() {
        return this.exceptions.keySet().stream().min(Comparator.naturalOrder()).orElse(null);
    }

    public void reportNewThrownException(Integer position, Throwable t) {
        this.exceptions.put(position, t);
    }

    public Set<Integer> getPositionsWhereExceptionsWereThrown() {
        return this.exceptions.keySet();
    }

    public Collection<Throwable> getAllThrownExceptions() {
        return this.exceptions.values();
    }

    public boolean isThereAnExceptionAtPosition(Integer position) {
        return this.exceptions.containsKey(position);
    }

    public boolean noThrownExceptions() {
        return this.exceptions.isEmpty();
    }

    public Throwable getExceptionThrownAtPosition(Integer position) {
        return this.exceptions.get(position);
    }

    public int getNumberOfThrownExceptions() {
        return this.exceptions.size();
    }

    @Deprecated
    public Map<Integer, Throwable> exposeExceptionMapping() {
        return this.exceptions;
    }

    public Map<Integer, Throwable> getCopyOfExceptionMapping() {
        return new HashMap<Integer, Throwable>(this.exceptions);
    }

    public ExecutionResult(TestCase t, Mutation m) {
        this.mutation = m;
        this.test = t;
    }

    public ExecutionTrace getTrace() {
        return this.trace;
    }

    public void setTrace(ExecutionTrace trace) throws IllegalArgumentException {
        if (trace == null) {
            throw new IllegalArgumentException("Trace cannot be null");
        }
        this.trace = trace;
    }

    public void setTrace(OutputTrace<?> trace, Class<?> clazz) {
        this.traces.put(clazz, trace);
    }

    public OutputTrace<?> getTrace(Class<?> clazz) {
        return this.traces.get(clazz);
    }

    public Collection<OutputTrace<?>> getTraces() {
        return this.traces.values();
    }

    public boolean hasTimeout() {
        if (this.test == null) {
            return false;
        }
        int size = this.test.size();
        return this.exceptions.containsKey(size) && this.exceptions.get(size) instanceof TestCaseExecutor.TimeoutExceeded;
    }

    public boolean hasTestException() {
        if (this.test == null) {
            return false;
        }
        return this.exceptions.values().stream().anyMatch(t -> t instanceof CodeUnderTestException);
    }

    public boolean hasUndeclaredException() {
        if (this.test == null) {
            return false;
        }
        for (int i : this.exceptions.keySet()) {
            Throwable t = this.exceptions.get(i);
            assert (i >= 0 && i <= this.test.size()) : "Exception " + t + " at position " + i + " in test of length " + this.test.size() + ": " + this.test.toCode(this.exceptions);
            if (i >= this.test.size() || this.test.getStatement(i).getDeclaredExceptions().contains(t.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean calledReflection() {
        return IntStream.range(0, this.getExecutedStatements()).mapToObj(numStatement -> this.test.getStatement(numStatement)).anyMatch(Statement::isReflectionStatement);
    }

    public boolean hasSecurityException() {
        return this.hasSecurityException;
    }

    public void setSecurityException(boolean value) {
        logger.debug("Changing hasSecurityException from " + this.hasSecurityException + " to " + value);
        this.hasSecurityException = value;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public ExecutionResult clone() {
        ExecutionResult copy = new ExecutionResult(this.test, this.mutation);
        copy.exceptions.putAll(this.exceptions);
        copy.trace = this.trace.lazyClone();
        copy.explicitExceptions.putAll(this.explicitExceptions);
        copy.executionTime = this.executionTime;
        copy.inputGoals = new LinkedHashMap<Integer, Set<InputCoverageGoal>>(this.inputGoals);
        copy.outputGoals = new LinkedHashMap<Integer, Set<OutputCoverageGoal>>(this.outputGoals);
        for (Class<?> clazz : this.traces.keySet()) {
            copy.traces.put(clazz, (OutputTrace<?>)this.traces.get(clazz).clone());
        }
        if (this.readProperties != null) {
            copy.readProperties = new LinkedHashSet<String>();
            copy.readProperties.addAll(this.readProperties);
        }
        copy.wasAnyPropertyWritten = this.wasAnyPropertyWritten;
        copy.featureVectors = new ArrayList<FeatureVector>(this.featureVectors);
        return copy;
    }

    public String toString() {
        return "Trace:" + this.trace;
    }

    public Set<String> getReadProperties() {
        return this.readProperties;
    }

    public void setReadProperties(Set<String> readProperties) {
        this.readProperties = readProperties;
    }

    public boolean wasAnyPropertyWritten() {
        return this.wasAnyPropertyWritten;
    }

    public void setWasAnyPropertyWritten(boolean wasAnyPropertyWritten) {
        this.wasAnyPropertyWritten = wasAnyPropertyWritten;
    }

    public void setTest(TestCase tc) {
        this.test = tc;
    }

    public void setInputGoals(Map<Integer, Set<InputCoverageGoal>> coveredGoals) {
        this.inputGoals.putAll(coveredGoals);
    }

    public void setOutputGoals(Map<Integer, Set<OutputCoverageGoal>> coveredGoals) {
        this.outputGoals.putAll(coveredGoals);
    }

    public Map<Integer, Set<InputCoverageGoal>> getInputGoals() {
        return this.inputGoals;
    }

    public Map<Integer, Set<OutputCoverageGoal>> getOutputGoals() {
        return this.outputGoals;
    }

    public void addFeatureVector(FeatureVector vector) {
        this.featureVectors.add(vector);
    }

    public List<FeatureVector> getFeatureVectors() {
        return Collections.unmodifiableList(this.featureVectors);
    }
}

