/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;

public class Scope {
    private final Map<VariableReference, Object> pool = Collections.synchronizedMap(new LinkedHashMap());

    public synchronized void setObject(VariableReference reference, Object o) {
        if (reference instanceof ArrayReference) {
            ArrayReference arrayRef = (ArrayReference)reference;
            if (o != null && !o.getClass().isArray()) {
                System.out.println("Trying to access object of class " + o.getClass() + " as array: " + o);
            } else if (o != null) {
                Object value = o;
                ArrayList<Integer> lengths = new ArrayList<Integer>();
                int idx = 0;
                while (value != null && value.getClass().isArray()) {
                    if (idx == lengths.size()) {
                        lengths.add(Array.getLength(value));
                    } else {
                        lengths.set(idx, Array.getLength(value));
                    }
                    if (Array.getLength(value) == 0) break;
                    value = Array.get(value, 0);
                    ++idx;
                }
                arrayRef.setLengths(lengths);
            } else {
                arrayRef.setArrayLength(0);
            }
        }
        if (o != null && !o.getClass().equals(reference.getVariableClass()) && reference.getGenericClass().getNumParameters() == 0 && !reference.isPrimitive() && !o.getClass().isArray() && TestUsageChecker.canUse(o.getClass())) {
            if (Proxy.isProxyClass(o.getClass())) {
                reference.setType(o.getClass().getSuperclass());
            } else if (o.getClass().getName().contains("EnhancerByMockito")) {
                Class<?> target;
                String mockName = o.getClass().getName();
                if (!mockName.startsWith((target = o.getClass().getSuperclass()).getName() + "$")) {
                    for (Class<?> inter : o.getClass().getInterfaces()) {
                        if (!mockName.startsWith(inter.getName() + "$")) continue;
                        target = inter;
                        break;
                    }
                }
                reference.setType(target);
            } else {
                reference.setType(o.getClass());
            }
        }
        this.pool.put(reference, o);
    }

    public void printPool() {
        for (Map.Entry<VariableReference, Object> entry : this.pool.entrySet()) {
            System.out.println("Pool: " + entry.getKey().getName() + ", " + entry.getKey().getType() + " : " + entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<VariableReference, Object> entry : this.pool.entrySet()) {
            sb.append(entry.getKey().getName());
            sb.append(", ");
            sb.append(entry.getKey().getType());
            sb.append(" : ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized Object getObject(VariableReference reference) {
        return this.pool.get(reference);
    }

    public List<VariableReference> getElements(Type type) {
        ArrayList<VariableReference> refs = new ArrayList<VariableReference>();
        for (Map.Entry<VariableReference, Object> entry : this.pool.entrySet()) {
            if (!type.equals(entry.getKey().getType()) && (entry.getValue() == null || !type.equals(entry.getValue().getClass()))) continue;
            refs.add(entry.getKey());
        }
        return refs;
    }

    public Collection<Object> getObjects() {
        return this.pool.values();
    }

    public Collection<VariableReference> getVariables() {
        return this.pool.keySet();
    }

    public Collection<Object> getObjects(Type type) {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Object o : this.pool.values()) {
            if (o == null || !o.getClass().equals(type)) continue;
            objects.add(o);
        }
        return objects;
    }
}

